/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiMethodParser<T> {
    private static final String METHOD_PREFIX = "^(\\s*(public|final|synchronized|native)\\s+)*(\\s*<((?!\\sextends\\s)[^>])+>)?\\s*(\\S+)\\s+([^\\(]+\\s*)\\(";
    private static final String JAVA_LANG = "java.lang.";
    private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Class<T> proxyType;
    private List<String> signatures;
    private final Map<String, Map<String, String>> signaturesArguments = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> parameters;
    private final Map<String, String> descriptions = new HashMap<String, String>();
    private ClassLoader classLoader = ApiMethodParser.class.getClassLoader();

    public ApiMethodParser(Class<T> proxyType) {
        this.proxyType = proxyType;
    }

    public Class<T> getProxyType() {
        return this.proxyType;
    }

    public final List<String> getSignatures() {
        return this.signatures;
    }

    public final void setSignatures(List<String> signatures) {
        this.signatures = new ArrayList<String>();
        this.signatures.addAll(signatures);
    }

    public Map<String, Map<String, String>> getSignaturesArguments() {
        return this.signaturesArguments;
    }

    public void addSignatureArguments(String name, Map<String, String> arguments) {
        this.signaturesArguments.put(name, arguments);
    }

    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Map<String, String> descriptions) {
        this.descriptions.putAll(descriptions);
    }

    public Map<String, Map<String, String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Map<String, String>> parameters) {
        this.parameters = parameters;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public final List<ApiMethodModel> parse() {
        List<ApiMethodModel> result = new ArrayList<ApiMethodModel>();
        for (String signature : this.signatures) {
            Method method;
            int max2;
            if (signature.startsWith("##") || ObjectHelper.isEmpty(signature)) continue;
            signature = signature.replaceAll(METHOD_PREFIX, "$5 $6(");
            signature = signature.replaceAll("(\\(|,\\s*)final\\s+", "$1");
            signature = signature.replaceAll("\\s*<\\s*", "<").replaceAll("\\s*>", ">");
            this.log.debug("Processing {}", (Object)signature);
            ArrayList<ApiMethodArg> arguments = new ArrayList<ApiMethodArg>();
            ArrayList argTypes = new ArrayList();
            int space = 0;
            for (int i = max2 = signature.indexOf(40); i > 0; --i) {
                char ch = signature.charAt(i);
                if (!Character.isWhitespace(ch)) continue;
                space = i;
                break;
            }
            String name = signature.substring(space, max2).trim();
            String rt = signature.substring(0, space).trim();
            int pos = rt.indexOf(60);
            if (pos != -1) {
                rt = rt.substring(0, pos);
            }
            String returnType = rt;
            Class<?> resultType = this.forName(returnType);
            Map<String, String> args = this.signaturesArguments.get(signature);
            if (args != null) {
                for (Map.Entry<String, String> entry : args.entrySet()) {
                    Map<String, String> params;
                    String rawTypeArg;
                    String argName = entry.getKey();
                    String shortTypeArgs = rawTypeArg = entry.getValue();
                    String typeArg = null;
                    pos = shortTypeArgs.indexOf(60);
                    if (pos != -1) {
                        typeArg = shortTypeArgs.substring(pos);
                        if (typeArg.startsWith("<")) {
                            typeArg = typeArg.substring(1);
                        }
                        if (typeArg.endsWith(">")) {
                            typeArg = typeArg.substring(0, typeArg.length() - 1);
                        }
                        shortTypeArgs = shortTypeArgs.substring(0, pos);
                    }
                    Class<?> type = this.forName(shortTypeArgs);
                    argTypes.add(type);
                    String typeDesc = null;
                    if (this.parameters != null && argName != null && (params = this.parameters.get(name)) != null) {
                        typeDesc = params.get(argName);
                    }
                    arguments.add(new ApiMethodArg(argName, type, typeArg, rawTypeArg, typeDesc));
                }
            }
            try {
                method = this.proxyType.getMethod(name, argTypes.toArray(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Method not found [" + signature + "] in type " + this.proxyType.getName());
            }
            result.add(new ApiMethodModel(name, resultType, arguments, method, this.descriptions.get(name), signature));
        }
        result = this.processResults(result);
        Map<String, Class<?>> allArguments = ApiMethodParser.extractArguments(result);
        allArguments.clear();
        result.sort(new Comparator<ApiMethodModel>(){

            @Override
            public int compare(ApiMethodModel model1, ApiMethodModel model2) {
                int nameCompare = model1.name.compareTo(model2.name);
                if (nameCompare != 0) {
                    return nameCompare;
                }
                int nArgs1 = model1.arguments.size();
                int nArgsCompare = nArgs1 - model2.arguments.size();
                if (nArgsCompare != 0) {
                    return nArgsCompare;
                }
                for (int i = 0; i < nArgs1; ++i) {
                    int argCompare = model1.arguments.get(i).getName().compareTo(model2.arguments.get(i).getName());
                    if (argCompare == 0) continue;
                    return argCompare;
                }
                ApiMethodParser.this.log.warn("Duplicate methods found [{}], [{}]", (Object)model1, (Object)model2);
                return 0;
            }
        });
        HashMap<String, Integer> dups = new HashMap<String, Integer>();
        for (ApiMethodModel model : result) {
            Object uniqueName = StringHelper.camelCaseToDash(model.getName());
            uniqueName = ((String)uniqueName).replace('-', '_');
            Integer suffix = (Integer)dups.get(uniqueName = ((String)uniqueName).toUpperCase(Locale.ENGLISH));
            if (suffix == null) {
                dups.put((String)uniqueName, 1);
            } else {
                dups.put((String)uniqueName, suffix + 1);
                uniqueName = (String)uniqueName + "_" + suffix;
            }
            model.uniqueName = uniqueName;
        }
        return result;
    }

    private static Map<String, Class<?>> extractArguments(List<ApiMethodModel> result) {
        HashMap allArguments = new HashMap();
        for (ApiMethodModel model : result) {
            for (ApiMethodArg argument : model.getArguments()) {
                String name = argument.getName();
                Class argClass = (Class)allArguments.get(name);
                Class<?> type = argument.getType();
                if (argClass == null) {
                    allArguments.put(name, type);
                    continue;
                }
                if (argClass == type) continue;
                throw new IllegalArgumentException("Argument [" + name + "] is used in multiple methods with different types " + argClass.getCanonicalName() + ", " + type.getCanonicalName());
            }
        }
        return allArguments;
    }

    protected List<ApiMethodModel> processResults(List<ApiMethodModel> result) {
        return result;
    }

    protected Class<?> forName(String className) {
        try {
            return ApiMethodParser.forName(className, this.classLoader);
        }
        catch (ClassNotFoundException e1) {
            throw new IllegalArgumentException("Error loading class " + className);
        }
    }

    public static Class<?> forName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> result;
        block12: {
            result = null;
            try {
                result = PRIMITIVE_TYPES.get(className);
                if (result == null) {
                    result = Class.forName(className, true, classLoader);
                }
            }
            catch (ClassNotFoundException e) {
                if (className.endsWith("[]")) {
                    int firstDim = className.indexOf(91);
                    int nDimensions = (className.length() - firstDim) / 2;
                    result = Array.newInstance(ApiMethodParser.forName(className.substring(0, firstDim), classLoader), new int[nDimensions]).getClass();
                } else if (className.indexOf(46) != -1) {
                    Object innerClass = className;
                    while (result == null && ((String)innerClass).indexOf(46) != -1) {
                        int endIndex = ((String)innerClass).lastIndexOf(46);
                        innerClass = ((String)innerClass).substring(0, endIndex) + "$" + ((String)innerClass).substring(endIndex + 1);
                        try {
                            result = Class.forName((String)innerClass, true, classLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                }
                if (result != null || className.startsWith(JAVA_LANG)) break block12;
                try {
                    result = ApiMethodParser.forName(JAVA_LANG + className, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            throw new ClassNotFoundException(className);
        }
        return result;
    }

    static {
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
    }

    public static final class ApiMethodModel {
        private final String name;
        private final Class<?> resultType;
        private final List<ApiMethodArg> arguments;
        private final Method method;
        private final String description;
        private final String signature;
        private String uniqueName;

        ApiMethodModel(String name, Class<?> resultType, List<ApiMethodArg> arguments, Method method, String description, String signature) {
            this.name = name;
            this.resultType = resultType;
            this.arguments = arguments;
            this.method = method;
            this.description = description;
            this.signature = signature;
        }

        ApiMethodModel(String uniqueName, String name, Class<?> resultType, List<ApiMethodArg> arguments, Method method, String description, String signature) {
            this.name = name;
            this.uniqueName = uniqueName;
            this.resultType = resultType;
            this.arguments = arguments;
            this.method = method;
            this.description = description;
            this.signature = signature;
        }

        public String getUniqueName() {
            return this.uniqueName;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getResultType() {
            return this.resultType;
        }

        public Method getMethod() {
            return this.method;
        }

        public List<ApiMethodArg> getArguments() {
            return this.arguments;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSignature() {
            return this.signature;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(256);
            builder.append(this.resultType.getName()).append(" ");
            builder.append(this.name).append("(");
            for (ApiMethodArg argument : this.arguments) {
                builder.append(argument.getType().getCanonicalName()).append(" ");
                builder.append(argument.getName()).append(", ");
            }
            if (!this.arguments.isEmpty()) {
                builder.delete(builder.length() - 2, builder.length());
            }
            builder.append(");");
            return builder.toString();
        }
    }
}

