/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.JpaHelper;
import org.apache.camel.component.jpa.QueryBuilder;
import org.apache.camel.component.jpa.QueryFactory;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JpaProducer.class);
    private static final String PROPERTY_PREFIX = "property:";
    private Language simple;
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionStrategy transactionStrategy;
    private final Expression expression;
    private String query;
    private String namedQuery;
    private String nativeQuery;
    private boolean findEntity;
    private Map<String, Object> parameters;
    private Class<?> resultClass;
    private QueryFactory queryFactory;
    private Boolean useExecuteUpdate;

    public JpaProducer(JpaEndpoint endpoint, Expression expression) {
        super(endpoint);
        this.expression = expression;
        this.entityManagerFactory = endpoint.getEntityManagerFactory();
        this.transactionStrategy = endpoint.getTransactionStrategy();
    }

    @Override
    public JpaEndpoint getEndpoint() {
        return (JpaEndpoint)super.getEndpoint();
    }

    public QueryFactory getQueryFactory() {
        if (this.queryFactory == null) {
            if (this.query != null) {
                this.queryFactory = QueryBuilder.query(this.query);
            } else if (this.namedQuery != null) {
                this.queryFactory = QueryBuilder.namedQuery(this.namedQuery);
            } else if (this.nativeQuery != null) {
                this.queryFactory = this.resultClass != null ? QueryBuilder.nativeQuery(this.nativeQuery, this.resultClass) : QueryBuilder.nativeQuery(this.nativeQuery);
            }
        }
        return this.queryFactory;
    }

    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public void setParameters(Map<String, Object> params) {
        this.parameters = params;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query2) {
        this.query = query2;
    }

    public boolean isFindEntity() {
        return this.findEntity;
    }

    public void setFindEntity(boolean findEntity) {
        this.findEntity = findEntity;
    }

    public Class<?> getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    public void setUseExecuteUpdate(Boolean executeUpdate) {
        this.useExecuteUpdate = executeUpdate;
    }

    public boolean isUseExecuteUpdate() {
        if (this.useExecuteUpdate == null) {
            this.useExecuteUpdate = this.query != null ? (this.query.regionMatches(true, 0, "select", 0, 6) ? Boolean.valueOf(false) : Boolean.valueOf(true)) : (this.nativeQuery != null ? (this.nativeQuery.regionMatches(true, 0, "select", 0, 6) ? Boolean.valueOf(false) : Boolean.valueOf(true)) : Boolean.valueOf(false));
        }
        return this.useExecuteUpdate;
    }

    @Override
    public void process(Exchange exchange) {
        EntityManager entityManager = JpaHelper.getTargetEntityManager(exchange, this.entityManagerFactory, this.getEndpoint().isUsePassedInEntityManager(), this.getEndpoint().isSharedEntityManager(), true);
        if (this.findEntity) {
            this.processFind(exchange, entityManager);
        } else if (this.getQueryFactory() != null) {
            this.processQuery(exchange, entityManager);
        } else {
            this.processEntity(exchange, entityManager);
        }
    }

    protected void processQuery(Exchange exchange, EntityManager entityManager) {
        Query innerQuery = this.getQueryFactory().createQuery(entityManager);
        this.configureParameters(innerQuery, exchange);
        this.transactionStrategy.executeInTransaction(new QueryProcessor(entityManager, innerQuery, exchange));
    }

    private void configureParameters(Query query2, Exchange exchange) {
        Map params;
        int firstResult;
        int maxResults = exchange.getIn().getHeader("CamelJpaMaximumResults", this.getEndpoint().getMaximumResults(), Integer.class);
        if (maxResults > 0) {
            query2.setMaxResults(maxResults);
        }
        if ((firstResult = exchange.getIn().getHeader("CamelJpaFirstResult", this.getEndpoint().getFirstResult(), Integer.class).intValue()) > 0) {
            query2.setFirstResult(firstResult);
        }
        if ((params = this.parameters != null ? this.parameters : exchange.getIn().getHeader("CamelJpaParameters", Map.class)) != null) {
            params.forEach((key, value) -> {
                Object resolvedValue = value;
                if (value instanceof String) {
                    resolvedValue = this.simple.createExpression((String)value).evaluate(exchange, Object.class);
                }
                query2.setParameter((String)key, resolvedValue);
            });
        }
    }

    protected void processFind(Exchange exchange, EntityManager entityManager) {
        Object key = exchange.getMessage().getBody();
        if (key != null) {
            this.transactionStrategy.executeInTransaction(new FindProcessor(entityManager, key, exchange));
        }
    }

    protected void processEntity(Exchange exchange, EntityManager entityManager) {
        Object values = this.expression.evaluate(exchange, Object.class);
        if (values != null) {
            this.transactionStrategy.executeInTransaction(new EntityProcessor(entityManager, values, exchange));
        }
    }

    private static void putAnswer(Exchange exchange, Object answer, String outputTarget) {
        if (outputTarget == null || outputTarget.isBlank()) {
            JpaProducer.getTargetMessage(exchange).setBody(answer);
        } else if (outputTarget.startsWith(PROPERTY_PREFIX)) {
            exchange.setProperty(outputTarget.substring(PROPERTY_PREFIX.length()), answer);
        } else {
            JpaProducer.getTargetMessage(exchange).setHeader(outputTarget, answer);
        }
    }

    private static Message getTargetMessage(Exchange exchange) {
        Message target;
        if (ExchangeHelper.isOutCapable(exchange)) {
            target = exchange.getMessage();
            target.getHeaders().putAll(exchange.getIn().getHeaders());
        } else {
            target = exchange.getIn();
        }
        return target;
    }

    @Override
    protected void doBuild() throws Exception {
        this.simple = this.getEndpoint().getCamelContext().resolveLanguage("simple");
    }

    private class QueryProcessor
    implements Runnable {
        private final EntityManager entityManager;
        private final Query innerQuery;
        private final Exchange exchange;

        public QueryProcessor(EntityManager entityManager, Query innerQuery, Exchange exchange) {
            this.entityManager = entityManager;
            this.innerQuery = innerQuery;
            this.exchange = exchange;
        }

        @Override
        public void run() {
            if (JpaProducer.this.getEndpoint().isJoinTransaction()) {
                this.entityManager.joinTransaction();
            }
            Object answer = JpaProducer.this.isUseExecuteUpdate() ? Integer.valueOf(this.innerQuery.executeUpdate()) : (JpaProducer.this.getEndpoint().isSingleResult() ? this.innerQuery.getSingleResult() : this.innerQuery.getResultList());
            JpaProducer.putAnswer(this.exchange, answer, JpaProducer.this.getEndpoint().getOutputTarget());
            if (JpaProducer.this.getEndpoint().isFlushOnSend()) {
                this.entityManager.flush();
            }
        }
    }

    private class FindProcessor
    implements Runnable {
        private final EntityManager entityManager;
        private final Object key;
        private final Exchange exchange;

        public FindProcessor(EntityManager entityManager, Object key, Exchange exchange) {
            this.entityManager = entityManager;
            this.key = key;
            this.exchange = exchange;
        }

        @Override
        public void run() {
            if (JpaProducer.this.getEndpoint().isJoinTransaction()) {
                this.entityManager.joinTransaction();
            }
            Object answer = this.entityManager.find(JpaProducer.this.getEndpoint().getEntityType(), this.key);
            LOG.debug("Find: {} -> {}", this.key, answer);
            if (JpaProducer.this.getEndpoint().isSingleResult() && answer == null) {
                throw new NoResultException(String.format("No results for key %s and singleResult requested", this.key));
            }
            JpaProducer.putAnswer(this.exchange, answer, JpaProducer.this.getEndpoint().getOutputTarget());
            if (JpaProducer.this.getEndpoint().isFlushOnSend()) {
                this.entityManager.flush();
            }
        }
    }

    private class EntityProcessor
    implements Runnable {
        private final EntityManager entityManager;
        private final Object values;
        private final Exchange exchange;

        public EntityProcessor(EntityManager entityManager, Object values, Exchange exchange) {
            this.entityManager = entityManager;
            this.values = values;
            this.exchange = exchange;
        }

        @Override
        public void run() {
            if (JpaProducer.this.getEndpoint().isJoinTransaction()) {
                this.entityManager.joinTransaction();
            }
            if (this.values.getClass().isArray()) {
                this.processArray();
            } else if (this.values instanceof Collection) {
                this.processCollection();
            } else {
                this.processOther();
            }
            if (JpaProducer.this.getEndpoint().isFlushOnSend()) {
                this.entityManager.flush();
            }
        }

        private void processOther() {
            Object managedEntity = !JpaProducer.this.getEndpoint().isRemove() ? this.save(this.values) : this.remove(this.values);
            if (!JpaProducer.this.getEndpoint().isUsePersist()) {
                this.exchange.getIn().setBody(managedEntity);
            }
        }

        private void processCollection() {
            Collection collection = (Collection)this.values;
            ArrayList<Object> managedCollection = new ArrayList<Object>(collection.size());
            for (Object entity : collection) {
                Object managedEntity = !JpaProducer.this.getEndpoint().isRemove() ? this.save(entity) : this.remove(entity);
                managedCollection.add(managedEntity);
            }
            if (!JpaProducer.this.getEndpoint().isUsePersist()) {
                this.exchange.getIn().setBody(managedCollection);
            }
        }

        private void processArray() {
            Object[] array = (Object[])this.values;
            Object[] managedArray = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                Object managedEntity = !JpaProducer.this.getEndpoint().isRemove() ? this.save(element) : this.remove(element);
                managedArray[i] = managedEntity;
            }
            if (!JpaProducer.this.getEndpoint().isUsePersist()) {
                System.arraycopy(managedArray, 0, array, 0, array.length);
                this.exchange.getIn().setBody(array);
            }
        }

        private Object save(Object entity) {
            LOG.debug("save: {}", entity);
            if (JpaProducer.this.getEndpoint().isUsePersist()) {
                this.entityManager.persist(entity);
                return entity;
            }
            return this.entityManager.merge(entity);
        }

        private Object remove(Object entity) {
            LOG.debug("remove: {}", entity);
            Object managedEntity = this.entityManager.contains(entity) ? entity : this.entityManager.merge(entity);
            this.entityManager.remove(managedEntity);
            return managedEntity;
        }
    }
}

