/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.ref;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.PredicateToExpressionAdapter;
import org.apache.camel.support.TypedLanguageSupport;
import org.apache.camel.support.builder.ExpressionBuilder;

@Language(value="ref")
public class RefLanguage
extends TypedLanguageSupport {
    @Override
    public Predicate createPredicate(String expression) {
        if (RefLanguage.hasSimpleFunction(expression)) {
            return this.createDynamic(expression);
        }
        return this.createStaticPredicate(expression);
    }

    @Override
    public Expression createExpression(String expression) {
        if (RefLanguage.hasSimpleFunction(expression)) {
            return this.createDynamic(expression);
        }
        return this.createStaticExpression(expression);
    }

    protected Expression createStaticExpression(String expression) {
        Expression answer;
        Object obj = this.getCamelContext().getRegistry().lookupByName(expression);
        if (obj instanceof Expression) {
            Expression exp;
            answer = exp = (Expression)obj;
        } else if (obj instanceof Predicate) {
            Predicate predicate = (Predicate)obj;
            answer = PredicateToExpressionAdapter.toExpression(predicate);
        } else {
            throw new IllegalArgumentException("Cannot find expression or predicate in registry with ref: " + expression);
        }
        answer.init(this.getCamelContext());
        return answer;
    }

    protected Predicate createStaticPredicate(String expression) {
        Predicate answer;
        Object obj = this.getCamelContext().getRegistry().lookupByName(expression);
        if (obj instanceof Expression) {
            Expression exp = (Expression)obj;
            answer = ExpressionToPredicateAdapter.toPredicate(exp);
        } else if (obj instanceof Predicate) {
            Predicate predicate;
            answer = predicate = (Predicate)obj;
        } else {
            throw new IllegalArgumentException("Cannot find expression or predicate in registry with ref: " + expression);
        }
        answer.init(this.getCamelContext());
        return answer;
    }

    protected ExpressionAdapter createDynamic(final String expression) {
        ExpressionAdapter answer = new ExpressionAdapter(){
            private Expression exp;
            private Registry registry;

            @Override
            public void init(CamelContext context) {
                this.registry = context.getRegistry();
                this.exp = ExpressionBuilder.simpleExpression(expression);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                Object lookup;
                Expression target = null;
                String ref = this.exp.evaluate(exchange, String.class);
                Object object = lookup = ref != null ? this.registry.lookupByName(ref) : null;
                if (lookup instanceof Expression) {
                    Expression exp;
                    target = exp = (Expression)lookup;
                } else if (lookup instanceof Predicate) {
                    Predicate predicate = (Predicate)lookup;
                    target = PredicateToExpressionAdapter.toExpression(predicate);
                }
                if (target != null) {
                    return target.evaluate(exchange, Object.class);
                }
                throw new IllegalArgumentException("Cannot find expression or predicate in registry with ref: " + ref);
            }

            public String toString() {
                return "ref:" + this.exp.toString();
            }
        };
        answer.init(this.getCamelContext());
        return answer;
    }
}

