/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.simple.BaseSimpleParser;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.ast.BinaryExpression;
import org.apache.camel.language.simple.ast.BooleanExpression;
import org.apache.camel.language.simple.ast.DoubleQuoteEnd;
import org.apache.camel.language.simple.ast.DoubleQuoteStart;
import org.apache.camel.language.simple.ast.LiteralExpression;
import org.apache.camel.language.simple.ast.LiteralNode;
import org.apache.camel.language.simple.ast.LogicalExpression;
import org.apache.camel.language.simple.ast.NullExpression;
import org.apache.camel.language.simple.ast.NumericExpression;
import org.apache.camel.language.simple.ast.SimpleFunctionEnd;
import org.apache.camel.language.simple.ast.SimpleFunctionStart;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.ast.SingleQuoteEnd;
import org.apache.camel.language.simple.ast.SingleQuoteStart;
import org.apache.camel.language.simple.ast.UnaryExpression;
import org.apache.camel.language.simple.types.BinaryOperatorType;
import org.apache.camel.language.simple.types.LogicalOperatorType;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.language.simple.types.TokenType;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.builder.PredicateBuilder;

public class SimplePredicateParser
extends BaseSimpleParser {
    private final Map<String, Expression> cacheExpression;

    public SimplePredicateParser(CamelContext camelContext, String expression, boolean allowEscape, Map<String, Expression> cacheExpression) {
        super(camelContext, expression, allowEscape);
        this.cacheExpression = cacheExpression;
    }

    public Predicate parsePredicate() {
        try {
            this.parseTokens();
            return this.doParsePredicate();
        }
        catch (SimpleParserException e) {
            throw new SimpleIllegalSyntaxException(this.expression, e.getIndex(), e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SimpleIllegalSyntaxException(this.expression, -1, e.getMessage(), e);
        }
    }

    public String parseCode() {
        try {
            this.parseTokens();
            return this.doParseCode();
        }
        catch (SimpleParserException e) {
            throw new SimpleIllegalSyntaxException(this.expression, e.getIndex(), e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SimpleIllegalSyntaxException(this.expression, -1, e.getMessage(), e);
        }
    }

    public List<SimpleNode> parseTokens() {
        this.clear();
        this.nextToken();
        while (!this.token.getType().isEol()) {
            if (!(this.singleQuotedLiteralWithFunctionsText() || this.doubleQuotedLiteralWithFunctionsText() || this.functionText() || this.unaryOperator() || this.binaryOperator() || this.logicalOperator() || this.isBooleanValue() || this.token.getType().isWhitespace() || this.token.getType().isEol())) {
                throw new SimpleParserException("Unexpected token " + String.valueOf(this.token), this.previousIndex);
            }
            this.nextToken();
        }
        this.removeIgnorableWhiteSpaceTokens();
        this.parseTokensAndCreateNodes();
        this.prepareBlocks();
        this.prepareUnaryExpressions();
        this.prepareBinaryExpressions();
        this.prepareLogicalExpressions();
        return this.nodes;
    }

    protected Predicate doParsePredicate() {
        List<Predicate> predicates = this.createPredicates();
        if (predicates.isEmpty()) {
            return PredicateBuilder.constant(false);
        }
        if (predicates.size() == 1) {
            return predicates.get(0);
        }
        return PredicateBuilder.and(predicates);
    }

    protected String doParseCode() {
        StringBuilder sb = new StringBuilder(256);
        for (SimpleNode node : this.nodes) {
            String exp = node.createCode(this.expression);
            SimpleExpressionParser.parseLiteralNode(sb, node, exp);
        }
        String code = sb.toString();
        code = code.replace("\"@@code[[", "");
        code = code.replace("]]code@@\"", "");
        return code;
    }

    protected void parseTokensAndCreateNodes() {
        SimpleToken token;
        SimpleNode lastSingle = null;
        SimpleNode lastDouble = null;
        SimpleNode lastFunction = null;
        AtomicBoolean startSingle = new AtomicBoolean();
        AtomicBoolean startDouble = new AtomicBoolean();
        AtomicBoolean startFunction = new AtomicBoolean();
        LiteralNode imageToken = null;
        Iterator iterator = this.tokens.iterator();
        while (iterator.hasNext() && !(token = (SimpleToken)iterator.next()).getType().isEol()) {
            SimpleNode node = this.createNode(token, startSingle, startDouble, startFunction);
            if (node != null) {
                if (node instanceof SingleQuoteStart) {
                    lastSingle = node;
                } else if (node instanceof DoubleQuoteStart) {
                    lastDouble = node;
                } else if (node instanceof SimpleFunctionStart) {
                    lastFunction = node;
                }
                if (imageToken != null) {
                    this.addImageToken(imageToken);
                    imageToken = null;
                }
                this.nodes.add(node);
                continue;
            }
            if (imageToken == null) {
                imageToken = new LiteralExpression(token);
            }
            imageToken.addText(token.getText());
        }
        if (imageToken != null) {
            this.addImageToken(imageToken);
        }
        if (startSingle.get()) {
            int index = SimplePredicateParser.evalIndex(lastSingle);
            throw new SimpleParserException("single quote has no ending quote", index);
        }
        if (startDouble.get()) {
            int index = SimplePredicateParser.evalIndex(lastDouble);
            throw new SimpleParserException("double quote has no ending quote", index);
        }
        if (startFunction.get()) {
            int index = SimplePredicateParser.evalIndex(lastFunction);
            throw new SimpleParserException("function has no ending token", index);
        }
    }

    private static int evalIndex(SimpleNode node) {
        return node != null ? node.getToken().getIndex() : 0;
    }

    private void addImageToken(LiteralNode imageToken) {
        String text = imageToken.getText();
        boolean quoted = false;
        if (!this.nodes.isEmpty()) {
            SimpleNode last = (SimpleNode)this.nodes.get(this.nodes.size() - 1);
            quoted = last instanceof SingleQuoteStart || last instanceof DoubleQuoteStart;
        }
        boolean numeric = false;
        if (!quoted) {
            boolean bl = numeric = ObjectHelper.isNumber(text) || ObjectHelper.isFloatingNumber(text);
        }
        if (numeric) {
            this.nodes.add(new NumericExpression(imageToken.getToken(), text));
        } else {
            this.nodes.add(imageToken);
        }
    }

    private SimpleNode createNode(SimpleToken token, AtomicBoolean startSingle, AtomicBoolean startDouble, AtomicBoolean startFunction) {
        if (token.getType().isFunctionStart()) {
            startFunction.set(true);
            return new SimpleFunctionStart(token, this.cacheExpression);
        }
        if (token.getType().isFunctionEnd()) {
            startFunction.set(false);
            return new SimpleFunctionEnd(token);
        }
        if (startFunction.get()) {
            return null;
        }
        if (token.getType().isSingleQuote()) {
            return SimplePredicateParser.createSingleQuoted(token, startSingle);
        }
        if (token.getType().isDoubleQuote()) {
            return SimplePredicateParser.createDoubleQuoted(token, startDouble);
        }
        if (startSingle.get() || startDouble.get()) {
            return null;
        }
        if (token.getType().isUnary()) {
            return new UnaryExpression(token);
        }
        if (token.getType().isBinary()) {
            return new BinaryExpression(token);
        }
        if (token.getType().isLogical()) {
            return new LogicalExpression(token);
        }
        if (token.getType().isNullValue()) {
            return new NullExpression(token);
        }
        if (token.getType().isBooleanValue()) {
            return new BooleanExpression(token);
        }
        return null;
    }

    private static SimpleNode createDoubleQuoted(SimpleToken token, AtomicBoolean startDouble) {
        boolean start = startDouble.get();
        BaseSimpleNode answer = !start ? new DoubleQuoteStart(token) : new DoubleQuoteEnd(token);
        startDouble.set(!start);
        return answer;
    }

    private static SimpleNode createSingleQuoted(SimpleToken token, AtomicBoolean startSingle) {
        boolean start = startSingle.get();
        BaseSimpleNode answer = !start ? new SingleQuoteStart(token) : new SingleQuoteEnd(token);
        startSingle.set(!start);
        return answer;
    }

    private void removeIgnorableWhiteSpaceTokens() {
        boolean quote = false;
        int functionCount = 0;
        Iterator it = this.tokens.iterator();
        while (it.hasNext()) {
            SimpleToken token = (SimpleToken)it.next();
            if (token.getType().isSingleQuote()) {
                quote = !quote;
                continue;
            }
            if (quote) continue;
            if (token.getType().isFunctionStart()) {
                ++functionCount;
                continue;
            }
            if (token.getType().isFunctionEnd()) {
                --functionCount;
                continue;
            }
            if (!token.getType().isWhitespace() || functionCount != 0) continue;
            it.remove();
        }
    }

    private void prepareBinaryExpressions() {
        ArrayDeque<SimpleNode> stack = new ArrayDeque<SimpleNode>();
        SimpleNode left = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            SimpleNode right;
            if (left == null) {
                left = i > 0 ? (SimpleNode)this.nodes.get(i - 1) : null;
            }
            SimpleNode token = (SimpleNode)this.nodes.get(i);
            SimpleNode simpleNode = right = i < this.nodes.size() - 1 ? (SimpleNode)this.nodes.get(i + 1) : null;
            if (token instanceof BinaryExpression) {
                BinaryExpression binary = (BinaryExpression)token;
                String operator = binary.getOperator().toString();
                if (left == null) {
                    throw new SimpleParserException("Binary operator " + operator + " has no left hand side token", token.getToken().getIndex());
                }
                if (!binary.acceptLeftNode(left)) {
                    throw new SimpleParserException("Binary operator " + operator + " does not support left hand side token " + String.valueOf(left.getToken()), token.getToken().getIndex());
                }
                if (right == null) {
                    throw new SimpleParserException("Binary operator " + operator + " has no right hand side token", token.getToken().getIndex());
                }
                if (!binary.acceptRightNode(right)) {
                    throw new SimpleParserException("Binary operator " + operator + " does not support right hand side token " + String.valueOf(right.getToken()), token.getToken().getIndex());
                }
                stack.pop();
                stack.push(token);
                ++i;
                left = token;
                continue;
            }
            left = null;
            stack.push(token);
        }
        this.nodes.clear();
        this.nodes.addAll(stack);
        Collections.reverse(this.nodes);
    }

    private void prepareLogicalExpressions() {
        ArrayDeque<SimpleNode> stack = new ArrayDeque<SimpleNode>();
        SimpleNode left = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            SimpleNode right;
            if (left == null) {
                left = i > 0 ? (SimpleNode)this.nodes.get(i - 1) : null;
            }
            SimpleNode token = (SimpleNode)this.nodes.get(i);
            SimpleNode simpleNode = right = i < this.nodes.size() - 1 ? (SimpleNode)this.nodes.get(i + 1) : null;
            if (token instanceof LogicalExpression) {
                LogicalExpression logical = (LogicalExpression)token;
                String operator = logical.getOperator().toString();
                if (left == null) {
                    throw new SimpleParserException("Logical operator " + operator + " has no left hand side token", token.getToken().getIndex());
                }
                if (!logical.acceptLeftNode(left)) {
                    throw new SimpleParserException("Logical operator " + operator + " does not support left hand side token " + String.valueOf(left.getToken()), token.getToken().getIndex());
                }
                if (right == null) {
                    throw new SimpleParserException("Logical operator " + operator + " has no right hand side token", token.getToken().getIndex());
                }
                if (!logical.acceptRightNode(right)) {
                    throw new SimpleParserException("Logical operator " + operator + " does not support right hand side token " + String.valueOf(left.getToken()), token.getToken().getIndex());
                }
                stack.pop();
                stack.push(token);
                ++i;
                left = token;
                continue;
            }
            left = null;
            stack.push(token);
        }
        this.nodes.clear();
        this.nodes.addAll(stack);
        Collections.reverse(this.nodes);
    }

    private List<Predicate> createPredicates() {
        ArrayList<Predicate> answer = new ArrayList<Predicate>();
        for (SimpleNode node : this.nodes) {
            Expression exp = node.createExpression(this.camelContext, this.expression);
            if (exp == null) continue;
            Predicate predicate = ExpressionToPredicateAdapter.toPredicate(exp);
            answer.add(predicate);
        }
        return answer;
    }

    protected boolean isBooleanValue() {
        return this.accept(TokenType.booleanValue);
    }

    protected boolean singleQuotedLiteralWithFunctionsText() {
        if (this.accept(TokenType.singleQuote)) {
            this.nextToken(TokenType.singleQuote, TokenType.eol, TokenType.functionStart, TokenType.functionEnd);
            while (!this.token.getType().isSingleQuote() && !this.token.getType().isEol()) {
                this.nextToken(TokenType.singleQuote, TokenType.eol, TokenType.functionStart, TokenType.functionEnd);
            }
            this.expect(TokenType.singleQuote);
            return true;
        }
        return false;
    }

    protected boolean singleQuotedLiteralText() {
        if (this.accept(TokenType.singleQuote)) {
            this.nextToken(TokenType.singleQuote, TokenType.eol);
            while (!this.token.getType().isSingleQuote() && !this.token.getType().isEol()) {
                this.nextToken(TokenType.singleQuote, TokenType.eol);
            }
            this.expect(TokenType.singleQuote);
            return true;
        }
        return false;
    }

    protected boolean doubleQuotedLiteralWithFunctionsText() {
        if (this.accept(TokenType.doubleQuote)) {
            this.nextToken(TokenType.doubleQuote, TokenType.eol, TokenType.functionStart, TokenType.functionEnd);
            while (!this.token.getType().isDoubleQuote() && !this.token.getType().isEol()) {
                this.nextToken(TokenType.doubleQuote, TokenType.eol, TokenType.functionStart, TokenType.functionEnd);
            }
            this.expect(TokenType.doubleQuote);
            return true;
        }
        return false;
    }

    protected boolean doubleQuotedLiteralText() {
        if (this.accept(TokenType.doubleQuote)) {
            this.nextToken(TokenType.doubleQuote, TokenType.eol);
            while (!this.token.getType().isDoubleQuote() && !this.token.getType().isEol()) {
                this.nextToken(TokenType.doubleQuote, TokenType.eol);
            }
            this.expect(TokenType.doubleQuote);
            return true;
        }
        return false;
    }

    protected boolean functionText() {
        if (this.accept(TokenType.functionStart)) {
            this.nextToken();
            while (!this.token.getType().isFunctionEnd() && !this.token.getType().isEol()) {
                if (this.token.getType().isFunctionStart()) {
                    this.functionText();
                }
                this.nextToken();
            }
            if (!this.token.getType().isFunctionStart()) {
                this.expect(TokenType.functionEnd);
            }
            return true;
        }
        return false;
    }

    protected boolean unaryOperator() {
        if (this.accept(TokenType.unaryOperator)) {
            this.nextToken();
            this.expect(TokenType.whiteSpace);
            return true;
        }
        return false;
    }

    protected boolean binaryOperator() {
        if (this.accept(TokenType.binaryOperator)) {
            boolean minusSupported;
            boolean nullSupported;
            boolean booleanSupported;
            boolean numericSupported;
            boolean functionSupported;
            boolean literalSupported;
            boolean literalWithFunctionsSupported;
            BinaryOperatorType operatorType = BinaryOperatorType.asOperator(this.token.getText());
            this.nextToken();
            this.expectAndAcceptMore(TokenType.whiteSpace);
            BinaryOperatorType.ParameterType[] types = BinaryOperatorType.supportedParameterTypes(operatorType);
            if (types == null || types.length == 0) {
                literalWithFunctionsSupported = true;
                literalSupported = false;
                functionSupported = true;
                numericSupported = true;
                booleanSupported = true;
                nullSupported = true;
                minusSupported = true;
            } else {
                literalWithFunctionsSupported = false;
                literalSupported = false;
                functionSupported = false;
                numericSupported = false;
                booleanSupported = false;
                nullSupported = false;
                minusSupported = false;
                for (BinaryOperatorType.ParameterType parameterType : types) {
                    literalSupported |= parameterType.isLiteralSupported();
                    literalWithFunctionsSupported |= parameterType.isLiteralWithFunctionSupport();
                    functionSupported |= parameterType.isFunctionSupport();
                    nullSupported |= parameterType.isNumericValueSupported();
                    booleanSupported |= parameterType.isBooleanValueSupported();
                    nullSupported |= parameterType.isNullValueSupported();
                    minusSupported |= parameterType.isMinusValueSupported();
                }
            }
            if (literalWithFunctionsSupported && this.singleQuotedLiteralWithFunctionsText() || literalWithFunctionsSupported && this.doubleQuotedLiteralWithFunctionsText() || literalSupported && this.singleQuotedLiteralText() || literalSupported && this.doubleQuotedLiteralText() || functionSupported && this.functionText() || numericSupported && this.numericValue() || booleanSupported && this.booleanValue() || nullSupported && this.nullValue() || minusSupported && this.minusValue()) {
                this.nextToken();
                if (!this.token.getType().isEol()) {
                    this.expect(TokenType.whiteSpace);
                }
            } else {
                throw new SimpleParserException("Binary operator " + String.valueOf((Object)operatorType) + " does not support token " + String.valueOf(this.token), this.token.getIndex());
            }
            return true;
        }
        return false;
    }

    protected boolean logicalOperator() {
        if (this.accept(TokenType.logicalOperator)) {
            LogicalOperatorType operatorType = LogicalOperatorType.asOperator(this.token.getText());
            this.nextToken();
            this.expectAndAcceptMore(TokenType.whiteSpace);
            if (this.singleQuotedLiteralWithFunctionsText() || this.doubleQuotedLiteralWithFunctionsText() || this.functionText() || this.numericValue() || this.booleanValue() || this.nullValue()) {
                this.nextToken();
                if (!this.token.getType().isEol()) {
                    this.expect(TokenType.whiteSpace);
                }
            } else {
                throw new SimpleParserException("Logical operator " + String.valueOf((Object)operatorType) + " does not support token " + String.valueOf(this.token), this.token.getIndex());
            }
            return true;
        }
        return false;
    }

    protected boolean numericValue() {
        return this.accept(TokenType.numericValue);
    }

    protected boolean booleanValue() {
        return this.accept(TokenType.booleanValue);
    }

    protected boolean nullValue() {
        return this.accept(TokenType.nullValue);
    }

    protected boolean minusValue() {
        this.nextToken();
        return this.accept(TokenType.numericValue);
    }
}

