/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.types;

import org.apache.camel.ExpressionIllegalSyntaxException;

public class SimpleIllegalSyntaxException
extends ExpressionIllegalSyntaxException {
    private static final long serialVersionUID = 1L;
    private static final String FORMATTED_NULL = "[null]";
    private final int index;
    private final String message;

    public SimpleIllegalSyntaxException(String expression, int index, String message) {
        super(expression);
        this.index = index;
        this.message = message;
    }

    public SimpleIllegalSyntaxException(String expression, int index, String message, Throwable cause) {
        super(expression, cause);
        this.index = index;
        this.message = message;
    }

    public int getIndex() {
        return this.index;
    }

    public String getShortMessage() {
        if (this.message == null) {
            return FORMATTED_NULL;
        }
        return this.message;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            return FORMATTED_NULL;
        }
        StringBuilder sb = new StringBuilder(this.message);
        if (this.index > -1) {
            sb.append(" at location ").append(this.index);
            sb.append("\n").append(this.getExpression()).append("\n");
            sb.append(" ".repeat(this.index));
            sb.append("*\n");
        }
        return sb.toString();
    }
}

