/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate5.support;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.lang.Nullable;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class OpenSessionInterceptor
implements MethodInterceptor,
InitializingBean {
    @Nullable
    private SessionFactory sessionFactory;

    public void setSessionFactory(@Nullable SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Nullable
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("Property 'sessionFactory' is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        SessionFactory sf = this.getSessionFactory();
        Assert.state(sf != null, "No SessionFactory set");
        if (!TransactionSynchronizationManager.hasResource(sf)) {
            Session session = this.openSession(sf);
            try {
                TransactionSynchronizationManager.bindResource(sf, new SessionHolder(session));
                Object object = invocation.proceed();
                return object;
            }
            finally {
                SessionFactoryUtils.closeSession(session);
                TransactionSynchronizationManager.unbindResource(sf);
            }
        }
        return invocation.proceed();
    }

    protected Session openSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        try {
            Session session = sessionFactory.openSession();
            session.setHibernateFlushMode(FlushMode.MANUAL);
            return session;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", ex);
        }
    }
}

