/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.LockModeType;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockException;
import jakarta.persistence.Query;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.component.jpa.Consumed;
import org.apache.camel.component.jpa.DeleteHandler;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.PreConsumed;
import org.apache.camel.component.jpa.QueryBuilder;
import org.apache.camel.component.jpa.QueryFactory;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.SharedEntityManagerCreator;

public class JpaConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(JpaConsumer.class);
    private static final Map<String, Object> NOWAIT = new HashMap<String, Object>();
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionStrategy transactionStrategy;
    private EntityManager entityManager;
    private QueryFactory queryFactory;
    private DeleteHandler<Object> deleteHandler;
    private DeleteHandler<Object> preDeleteHandler;
    private String query;
    private String namedQuery;
    private String nativeQuery;
    private LockModeType lockModeType = LockModeType.PESSIMISTIC_WRITE;
    private Map<String, Object> parameters;
    private Class<?> resultClass;
    private boolean transacted;
    private boolean skipLockedEntity;

    public JpaConsumer(JpaEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.entityManagerFactory = endpoint.getEntityManagerFactory();
        this.transactionStrategy = endpoint.getTransactionStrategy();
    }

    private void recreateEntityManagerIfNeeded() {
        if (this.entityManager == null) {
            this.entityManager = this.getEndpoint().isSharedEntityManager() ? SharedEntityManagerCreator.createSharedEntityManager(this.entityManagerFactory) : this.entityManagerFactory.createEntityManager();
            LOG.trace("Recreated EntityManager {} on {}", (Object)this.entityManager, (Object)this);
        }
    }

    @Override
    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        this.recreateEntityManagerIfNeeded();
        int[] messagePolled = new int[]{0};
        try {
            this.transactionStrategy.executeInTransaction(() -> {
                if (this.getEndpoint().isJoinTransaction()) {
                    this.entityManager.joinTransaction();
                }
                LinkedList<DataHolder> answer = new LinkedList<DataHolder>();
                Query toExecute = this.getQueryFactory().createQuery(this.entityManager);
                this.configureParameters(toExecute);
                LOG.trace("Created query {}", (Object)toExecute);
                List results = toExecute.getResultList();
                LOG.trace("Got result list from query {}", (Object)results);
                this.forceConsumerAsReady();
                for (Object result : results) {
                    DataHolder holder = new DataHolder();
                    holder.manager = this.entityManager;
                    holder.result = result;
                    holder.exchange = this.createExchange(result, this.entityManager);
                    answer.add(holder);
                }
                PersistenceException cause = null;
                try {
                    messagePolled[0] = this.processBatch(CastUtils.cast(answer));
                }
                catch (PersistenceException e) {
                    cause = e;
                }
                catch (Exception e) {
                    cause = new PersistenceException(e);
                }
                if (cause != null) {
                    if (!this.isTransacted()) {
                        LOG.warn("Error processing last message due: {}. Will commit all previous successful processed message, and ignore this last failure.", (Object)cause.getMessage(), (Object)cause);
                    } else {
                        throw cause;
                    }
                }
                LOG.debug("Flushing EntityManager");
                this.entityManager.flush();
                this.entityManager.clear();
            });
        }
        catch (Exception e) {
            LOG.debug("Disposing EntityManager {} on {} due to coming transaction rollback", (Object)this.entityManager, (Object)this);
            this.entityManager.close();
            this.entityManager = null;
            throw new PersistenceException(e);
        }
        return this.getEndpoint().getCamelContext().getTypeConverter().convertTo(Integer.TYPE, messagePolled[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            LOG.debug("Limiting to maximum messages to poll {} as there were {} messages in this poll.", (Object)this.maxMessagesPerPoll, (Object)total);
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            DataHolder holder = ObjectHelper.cast(DataHolder.class, exchanges.poll());
            EntityManager batchEntityManager = holder.manager;
            Exchange exchange = holder.exchange;
            Object result = holder.result;
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            if (!this.lockEntity(result, batchEntityManager)) continue;
            this.createPreDeleteHandler().deleteObject(batchEntityManager, result, exchange);
            LOG.debug("Processing exchange: {}", (Object)exchange);
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            try {
                if (exchange.getException() != null) {
                    throw exchange.getException();
                }
                this.getDeleteHandler().deleteObject(batchEntityManager, result, exchange);
                continue;
            }
            finally {
                this.releaseExchange(exchange, false);
            }
        }
        return total;
    }

    @Override
    public JpaEndpoint getEndpoint() {
        return (JpaEndpoint)super.getEndpoint();
    }

    public QueryFactory getQueryFactory() {
        if (this.queryFactory == null) {
            this.queryFactory = this.createQueryFactory();
            if (this.queryFactory == null) {
                throw new IllegalArgumentException("No queryType property configured on this consumer, nor an entityType configured on the endpoint so cannot consume");
            }
        }
        return this.queryFactory;
    }

    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public DeleteHandler<Object> getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = this.createDeleteHandler();
        }
        return this.deleteHandler;
    }

    public void setDeleteHandler(DeleteHandler<Object> deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    public DeleteHandler<Object> getPreDeleteHandler() {
        if (this.preDeleteHandler == null) {
            this.preDeleteHandler = this.createPreDeleteHandler();
        }
        return this.preDeleteHandler;
    }

    public void setPreDeleteHandler(DeleteHandler<Object> preDeleteHandler) {
        this.preDeleteHandler = preDeleteHandler;
    }

    public void setParameters(Map<String, Object> params) {
        this.parameters = params;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public LockModeType getLockModeType() {
        return this.lockModeType;
    }

    public void setLockModeType(LockModeType lockModeType) {
        this.lockModeType = lockModeType;
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query2) {
        this.query = query2;
    }

    public Class<?> getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void setSkipLockedEntity(boolean skipLockedEntity) {
        this.skipLockedEntity = skipLockedEntity;
    }

    public boolean isSkipLockedEntity() {
        return this.skipLockedEntity;
    }

    protected boolean lockEntity(Object entity, EntityManager entityManager) {
        if (!this.getEndpoint().isConsumeLockEntity()) {
            return true;
        }
        try {
            LOG.debug("Acquiring exclusive lock on entity: {}", entity);
            if (this.isSkipLockedEntity()) {
                entityManager.lock(entity, this.lockModeType, NOWAIT);
            } else {
                entityManager.lock(entity, this.lockModeType);
            }
            return true;
        }
        catch (Exception e) {
            LOG.debug("Failed to achieve lock on entity: {}. Reason: {}", new Object[]{entity, e.getMessage(), e});
            if (e instanceof PessimisticLockException || e instanceof OptimisticLockException) {
                throw (PersistenceException)e;
            }
            return entity.getClass().isArray();
        }
    }

    protected QueryFactory createQueryFactory() {
        if (this.query != null) {
            return QueryBuilder.query(this.query);
        }
        if (this.namedQuery != null) {
            return QueryBuilder.namedQuery(this.namedQuery);
        }
        if (this.nativeQuery != null) {
            if (this.resultClass != null) {
                return QueryBuilder.nativeQuery(this.nativeQuery, this.resultClass);
            }
            return QueryBuilder.nativeQuery(this.nativeQuery);
        }
        Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType == null) {
            return null;
        }
        String name = this.getEntityName(entityType);
        if (name != null) {
            return QueryBuilder.query("select x from " + name + " x");
        }
        return QueryBuilder.query("select x from " + entityType.getSimpleName() + " x");
    }

    protected String getEntityName(Class<?> clazz) {
        Entity entity = clazz.getAnnotation(Entity.class);
        if (entity != null && !entity.name().isEmpty()) {
            return entity.name();
        }
        return null;
    }

    protected DeleteHandler<Object> createPreDeleteHandler() {
        Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType != null) {
            List<Method> methods = ObjectHelper.findMethodsWithAnnotation(entityType, PreConsumed.class);
            if (methods.size() > 1) {
                throw new IllegalStateException("Only one method can be annotated with the @PreConsumed annotation but found: " + String.valueOf(methods));
            }
            if (methods.size() == 1) {
                Method method = methods.get(0);
                boolean useExchangeParameter = this.checkParameters(method);
                return (em, entityBean, exchange) -> {
                    if (entityType.isInstance(entityBean)) {
                        if (useExchangeParameter) {
                            org.apache.camel.support.ObjectHelper.invokeMethod(method, entityBean, exchange);
                        } else {
                            org.apache.camel.support.ObjectHelper.invokeMethod(method, entityBean, new Object[0]);
                        }
                    }
                };
            }
        }
        return (em, entityBean, exchange) -> {};
    }

    protected DeleteHandler<Object> createDeleteHandler() {
        Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType != null) {
            List<Method> methods = ObjectHelper.findMethodsWithAnnotation(entityType, Consumed.class);
            if (methods.size() > 1) {
                throw new IllegalArgumentException("Only one method can be annotated with the @Consumed annotation but found: " + String.valueOf(methods));
            }
            if (methods.size() == 1) {
                Method method = methods.get(0);
                boolean useExchangeParameter = this.checkParameters(method);
                return (em, entityBean, exchange) -> {
                    if (entityType.isInstance(entityBean)) {
                        if (useExchangeParameter) {
                            org.apache.camel.support.ObjectHelper.invokeMethod(method, entityBean, exchange);
                        } else {
                            org.apache.camel.support.ObjectHelper.invokeMethod(method, entityBean, new Object[0]);
                        }
                    }
                };
            }
        }
        if (this.getEndpoint().isConsumeDelete()) {
            return (em, entityBean, exchange) -> em.remove(entityBean);
        }
        return (em, entityBean, exchange) -> {};
    }

    protected boolean checkParameters(Method method) {
        boolean result = false;
        Class<?>[] receivedParameters = method.getParameterTypes();
        if (receivedParameters.length == 1 && receivedParameters[0].isAssignableFrom(Exchange.class)) {
            result = true;
        }
        if (receivedParameters.length > 0 && !result) {
            throw new IllegalStateException("@PreConsumed annotated method cannot have parameter other than Exchange");
        }
        return result;
    }

    protected void configureParameters(Query query2) {
        int maxResults = this.getEndpoint().getMaximumResults();
        if (maxResults > 0) {
            query2.setMaxResults(maxResults);
        }
        if (this.parameters != null) {
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                query2.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    protected Exchange createExchange(Object result, EntityManager entityManager) {
        Exchange exchange = this.createExchange(false);
        exchange.getIn().setBody(result);
        exchange.getIn().setHeader("CamelEntityManager", entityManager);
        return exchange;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.entityManager = this.getEndpoint().isSharedEntityManager() ? SharedEntityManagerCreator.createSharedEntityManager(this.entityManagerFactory) : this.entityManagerFactory.createEntityManager();
        LOG.trace("Created EntityManager {} on {}", (Object)this.entityManager, (Object)this);
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        if (this.entityManager != null) {
            this.entityManager.close();
            LOG.trace("Closed EntityManager {} on {}", (Object)this.entityManager, (Object)this);
        }
        super.doShutdown();
    }

    static {
        NOWAIT.put("jakarta.persistence.lock.timeout", 0L);
    }

    private static final class DataHolder {
        private Exchange exchange;
        private Object result;
        private EntityManager manager;

        private DataHolder() {
        }
    }
}

