/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.csimple;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.language.csimple.CSimpleCompiler;
import org.apache.camel.language.csimple.CSimpleException;
import org.apache.camel.language.csimple.CSimpleExpression;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.TypedLanguageSupport;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Language(value="csimple")
public class CSimpleLanguage
extends TypedLanguageSupport
implements StaticService {
    public static final String PRE_COMPILED_FILE = "META-INF/services/org/apache/camel/csimple.properties";
    public static final String CONFIG_FILE = "camel-csimple.properties";
    private static final Logger LOG = LoggerFactory.getLogger(CSimpleLanguage.class);
    private final Map<String, CSimpleExpression> compiledPredicates;
    private final Map<String, CSimpleExpression> compiledExpressions;
    private final CompilationSupport compilationSupport;

    public CSimpleLanguage() {
        this.compiledPredicates = new ConcurrentHashMap<String, CSimpleExpression>();
        this.compiledExpressions = new ConcurrentHashMap<String, CSimpleExpression>();
        this.compilationSupport = new CompilationSupport();
    }

    private CSimpleLanguage(Map<String, CSimpleExpression> compiledPredicates, Map<String, CSimpleExpression> compiledExpressions) {
        this.compiledPredicates = compiledPredicates;
        this.compiledExpressions = compiledExpressions;
        this.compilationSupport = null;
    }

    public String getConfigResource() {
        return this.compilationSupport().configResource;
    }

    public void setConfigResource(String configResource) {
        this.compilationSupport().configResource = configResource;
    }

    public void addImport(String imports) {
        this.compilationSupport().addImport(imports);
    }

    public void addAliases(String key, String value) {
        this.compilationSupport().addAliases(key, value);
    }

    @Override
    public void init() {
        if (this.compilationSupport != null) {
            this.compilationSupport.init();
        }
    }

    @Override
    public void start() {
        if (this.compilationSupport != null) {
            ServiceHelper.startService((Object)this.compilationSupport.compiler);
        }
    }

    @Override
    public void stop() {
        if (this.compilationSupport != null) {
            ServiceHelper.stopService((Object)this.compilationSupport.compiler);
        }
    }

    @Override
    public Predicate createPredicate(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression must be specified");
        }
        String text = expression.replace("\n", "");
        text = text.trim();
        return this.compiledPredicates.computeIfAbsent(text, key -> {
            CSimpleExpression exp;
            if (this.compilationSupport != null && (exp = this.compilationSupport.compilePredicate(this.getCamelContext(), expression)) != null) {
                exp.init(this.getCamelContext());
                return exp;
            }
            throw new CSimpleException("Cannot find compiled csimple language for predicate: " + expression, expression);
        });
    }

    @Override
    public Expression createExpression(String expression, Object[] properties) {
        Class resultType = this.property(Class.class, properties, 0, null);
        if (Boolean.class == resultType || Boolean.TYPE == resultType) {
            return (Expression)((Object)this.createPredicate(expression));
        }
        if (resultType == null || resultType == Object.class) {
            return this.createExpression(expression);
        }
        return ExpressionBuilder.convertToExpression(this.createExpression(expression), resultType);
    }

    @Override
    public Expression createExpression(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression must be specified");
        }
        String text = expression.replace("\n", "");
        text = text.trim();
        return this.compiledExpressions.computeIfAbsent(text, key -> {
            CSimpleExpression exp;
            if (this.compilationSupport != null && (exp = this.compilationSupport.compileExpression(this.getCamelContext(), expression)) != null) {
                exp.init(this.getCamelContext());
                return exp;
            }
            throw new CSimpleException("Cannot find compiled csimple language for expression: " + expression, expression);
        });
    }

    private CompilationSupport compilationSupport() {
        if (this.compilationSupport == null) {
            throw new IllegalStateException("Runtime Compilation is not supported with this " + CSimpleLanguage.class.getSimpleName());
        }
        return this.compilationSupport;
    }

    public static Builder builder() {
        return new Builder();
    }

    private String load(String configResource) {
        String loaded;
        InputStream is = this.getCamelContext().getClassResolver().loadResourceAsStream(CONFIG_FILE);
        try {
            File file;
            if (is == null && (file = new File(configResource)).exists()) {
                is = new FileInputStream(file);
            }
            if (is == null) {
                return null;
            }
            loaded = IOHelper.loadText(is);
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Cannot load camel-csimple.properties from classpath");
        }
        IOHelper.close((Closeable)is);
        return loaded;
    }

    class CompilationSupport {
        private CSimpleCompiler compiler;
        private String configResource = "camel-csimple.properties";
        private final Set<String> imports = new TreeSet<String>();
        private final Map<String, String> aliases = new HashMap<String, String>();

        CompilationSupport() {
        }

        public void addImport(String imports) {
            if (!((String)imports).startsWith("import ")) {
                imports = "import " + (String)imports;
            }
            if (this.compiler != null) {
                this.compiler.addImport((String)imports);
            } else {
                this.imports.add((String)imports);
            }
        }

        public void init() {
            this.loadPreCompiled();
            this.loadConfiguration();
            CamelContext ecc = CSimpleLanguage.this.getCamelContext();
            Optional<Class<?>> clazz = ecc.getCamelContextExtension().getBootstrapFactoryFinder().findClass("csimple-compiler");
            if (clazz.isPresent()) {
                this.compiler = (CSimpleCompiler)ecc.getInjector().newInstance(clazz.get(), false);
                if (this.compiler != null) {
                    LOG.info("Detected camel-csimple-joor compiler");
                    this.imports.forEach(this.compiler::addImport);
                    this.aliases.forEach(this.compiler::addAliases);
                }
                ServiceHelper.initService((Object)this.compiler);
            }
        }

        public CSimpleExpression compilePredicate(CamelContext camelContext, String expression) {
            if (this.compiler != null) {
                return this.compiler.compilePredicate(camelContext, expression);
            }
            return null;
        }

        public CSimpleExpression compileExpression(CamelContext camelContext, String expression) {
            if (this.compiler != null) {
                return this.compiler.compileExpression(camelContext, expression);
            }
            return null;
        }

        public void addAliases(String key, String value) {
            if (this.compiler != null) {
                this.compiler.addAliases(key, value);
            } else {
                this.aliases.put(key, value);
            }
        }

        private void loadPreCompiled() {
            CamelContext ecc = CSimpleLanguage.this.getCamelContext();
            InputStream is = ecc.getClassResolver().loadResourceAsStream(CSimpleLanguage.PRE_COMPILED_FILE);
            if (is != null) {
                try {
                    String[] lines;
                    String text = IOHelper.loadText(is);
                    for (String fqn : lines = text.split("\n")) {
                        if ((fqn = fqn.trim()).startsWith("#") || fqn.isEmpty()) continue;
                        Class<CSimpleExpression> clazz = ecc.getClassResolver().resolveMandatoryClass(fqn, CSimpleExpression.class);
                        CSimpleExpression ce = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        ce.init(CSimpleLanguage.this.getCamelContext());
                        if (ce.isPredicate()) {
                            CSimpleLanguage.this.compiledPredicates.put(ce.getText(), ce);
                            continue;
                        }
                        CSimpleLanguage.this.compiledExpressions.put(ce.getText(), ce);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error initializing csimple language", e);
                }
                finally {
                    IOHelper.close((Closeable)is);
                }
                int size = CSimpleLanguage.this.compiledPredicates.size() + CSimpleLanguage.this.compiledExpressions.size();
                if (size > 0) {
                    LOG.info("Loaded and initialized {} csimple expressions from classpath", (Object)size);
                }
            }
        }

        private void loadConfiguration() {
            String[] lines;
            String loaded = CSimpleLanguage.this.load(this.configResource);
            if (loaded == null) {
                return;
            }
            int counter1 = 0;
            int counter2 = 0;
            for (String line : lines = loaded.split("\n")) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.startsWith("import ")) {
                    this.imports.add(line);
                    ++counter1;
                    continue;
                }
                String key = StringHelper.before(line, "=");
                String value = StringHelper.after(line, "=");
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                this.aliases.put(key, value);
                ++counter2;
            }
            if (counter1 > 0 || counter2 > 0) {
                LOG.info("Loaded csimple language imports: {} and aliases: {} from configuration: {}", new Object[]{counter1, counter2, this.configResource});
            }
        }
    }

    public static class Builder {
        private Map<String, CSimpleExpression> compiledPredicates = new LinkedHashMap<String, CSimpleExpression>();
        private Map<String, CSimpleExpression> compiledExpressions = new LinkedHashMap<String, CSimpleExpression>();

        public CSimpleLanguage build() {
            ConcurrentHashMap<String, CSimpleExpression> predicates = this.compiledPredicates.isEmpty() ? Collections.emptyMap() : new ConcurrentHashMap<String, CSimpleExpression>(this.compiledPredicates);
            this.compiledPredicates = null;
            ConcurrentHashMap<String, CSimpleExpression> expressions = this.compiledExpressions.isEmpty() ? Collections.emptyMap() : new ConcurrentHashMap<String, CSimpleExpression>(this.compiledExpressions);
            this.compiledExpressions = null;
            return new CSimpleLanguage(predicates, expressions);
        }

        public Builder expression(CSimpleExpression expression) {
            (expression.isPredicate() ? this.compiledPredicates : this.compiledExpressions).put(expression.getText(), expression);
            return this;
        }
    }
}

