/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.ast.LiteralNode;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.support.builder.ExpressionBuilder;

public class LiteralExpression
extends BaseSimpleNode
implements LiteralNode {
    protected final StringBuilder text = new StringBuilder(256);

    public LiteralExpression(SimpleToken token) {
        super(token);
    }

    @Override
    public String toString() {
        return this.getText();
    }

    @Override
    public void addText(String text) {
        this.text.append(text);
    }

    @Override
    public String getText() {
        return this.text.toString();
    }

    @Override
    public boolean quoteEmbeddedNodes() {
        return this.text.toString().startsWith("bean:");
    }

    @Override
    public Expression createExpression(CamelContext camelContext, String expression) {
        return ExpressionBuilder.constantExpression(this.getText());
    }

    @Override
    public String createCode(String expression) throws SimpleParserException {
        return this.getText();
    }
}

