/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.BeanRepository;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.NamedBeanHolder;
import org.springframework.context.ApplicationContext;

public class ApplicationContextBeanRepository
implements BeanRepository {
    private ApplicationContext applicationContext;

    public ApplicationContextBeanRepository(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        T answer;
        try {
            if (!this.applicationContext.containsBean(name)) {
                return null;
            }
            answer = this.applicationContext.getBean(name, type);
        }
        catch (BeanNotOfRequiredTypeException | NoSuchBeanDefinitionException e) {
            return null;
        }
        try {
            return type.cast(answer);
        }
        catch (Exception e) {
            String msg = "Found bean: " + name + " in ApplicationContext: " + String.valueOf(this.applicationContext) + " of type: " + answer.getClass().getName() + " expected type was: " + String.valueOf(type);
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    @Override
    public Object lookupByName(String name) {
        try {
            if (this.applicationContext.containsBean(name)) {
                return this.applicationContext.getBean(name);
            }
            return null;
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        Map<String, T> map = this.findByTypeWithName(type);
        return new HashSet<T>(map.values());
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, type);
    }

    @Override
    public <T> T findSingleByType(Class<T> type) {
        try {
            NamedBeanHolder<T> holder = this.applicationContext.getAutowireCapableBeanFactory().resolveNamedBean(type);
            return holder.getBeanInstance();
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }
}

