/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractFallbackSQLExceptionTranslator
implements SQLExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private SQLExceptionTranslator fallbackTranslator;
    @Nullable
    private SQLExceptionTranslator customTranslator;

    public void setFallbackTranslator(@Nullable SQLExceptionTranslator fallback) {
        this.fallbackTranslator = fallback;
    }

    @Nullable
    public SQLExceptionTranslator getFallbackTranslator() {
        return this.fallbackTranslator;
    }

    public void setCustomTranslator(@Nullable SQLExceptionTranslator customTranslator) {
        this.customTranslator = customTranslator;
    }

    @Nullable
    public SQLExceptionTranslator getCustomTranslator() {
        return this.customTranslator;
    }

    @Override
    @Nullable
    public DataAccessException translate(String task, @Nullable String sql, SQLException ex) {
        DataAccessException dae;
        Assert.notNull((Object)ex, "Cannot translate a null SQLException");
        SQLExceptionTranslator custom = this.getCustomTranslator();
        if (custom != null && (dae = custom.translate(task, sql, ex)) != null) {
            return dae;
        }
        dae = this.doTranslate(task, sql, ex);
        if (dae != null) {
            return dae;
        }
        SQLExceptionTranslator fallback = this.getFallbackTranslator();
        if (fallback != null) {
            return fallback.translate(task, sql, ex);
        }
        return null;
    }

    @Nullable
    protected abstract DataAccessException doTranslate(String var1, @Nullable String var2, SQLException var3);

    protected String buildMessage(String task, @Nullable String sql, SQLException ex) {
        return task + "; " + (String)(sql != null ? "SQL [" + sql + "]; " : "") + ex.getMessage();
    }
}

