/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate5;

import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.springframework.lang.Nullable;
import org.springframework.transaction.jta.UserTransactionAdapter;
import org.springframework.util.Assert;

class ConfigurableJtaPlatform
implements JtaPlatform {
    private final TransactionManager transactionManager;
    private final UserTransaction userTransaction;
    @Nullable
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    public ConfigurableJtaPlatform(TransactionManager tm, @Nullable UserTransaction ut, @Nullable TransactionSynchronizationRegistry tsr) {
        Assert.notNull((Object)tm, "TransactionManager reference must not be null");
        this.transactionManager = tm;
        this.userTransaction = ut != null ? ut : new UserTransactionAdapter(tm);
        this.transactionSynchronizationRegistry = tsr;
    }

    public TransactionManager retrieveTransactionManager() {
        return this.transactionManager;
    }

    public UserTransaction retrieveUserTransaction() {
        return this.userTransaction;
    }

    public Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }

    public boolean canRegisterSynchronization() {
        try {
            return this.transactionManager.getStatus() == 0;
        }
        catch (SystemException ex) {
            throw new TransactionException("Could not determine JTA transaction status", (Throwable)ex);
        }
    }

    public void registerSynchronization(Synchronization synchronization) {
        if (this.transactionSynchronizationRegistry != null) {
            this.transactionSynchronizationRegistry.registerInterposedSynchronization(synchronization);
        } else {
            try {
                this.transactionManager.getTransaction().registerSynchronization(synchronization);
            }
            catch (Exception ex) {
                throw new TransactionException("Could not access JTA Transaction to register synchronization", (Throwable)ex);
            }
        }
    }

    public int getCurrentStatus() throws SystemException {
        return this.transactionManager.getStatus();
    }
}

