/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.RollbackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.SavepointManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.DelegatingTransactionDefinition;
import org.springframework.transaction.support.ResourceTransactionDefinition;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class JpaTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
BeanFactoryAware,
InitializingBean {
    @Nullable
    private EntityManagerFactory entityManagerFactory;
    @Nullable
    private String persistenceUnitName;
    private final Map<String, Object> jpaPropertyMap = new HashMap<String, Object>();
    @Nullable
    private DataSource dataSource;
    private JpaDialect jpaDialect = new DefaultJpaDialect();
    @Nullable
    private Consumer<EntityManager> entityManagerInitializer;

    public JpaTransactionManager() {
        this.setNestedTransactionAllowed(true);
    }

    public JpaTransactionManager(EntityManagerFactory emf) {
        this();
        this.entityManagerFactory = emf;
        this.afterPropertiesSet();
    }

    public void setEntityManagerFactory(@Nullable EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    @Nullable
    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    protected final EntityManagerFactory obtainEntityManagerFactory() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        Assert.state(emf != null, "No EntityManagerFactory set");
        return emf;
    }

    public void setPersistenceUnitName(@Nullable String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    @Nullable
    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setJpaProperties(@Nullable Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap(jpaProperties, this.jpaPropertyMap);
    }

    public void setJpaPropertyMap(@Nullable Map<String, ?> jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }

    public Map<String, Object> getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    public void setDataSource(@Nullable DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            TransactionAwareDataSourceProxy proxy = (TransactionAwareDataSourceProxy)dataSource;
            this.dataSource = proxy.getTargetDataSource();
        } else {
            this.dataSource = dataSource;
        }
    }

    @Nullable
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setJpaDialect(@Nullable JpaDialect jpaDialect) {
        this.jpaDialect = jpaDialect != null ? jpaDialect : new DefaultJpaDialect();
    }

    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    public void setEntityManagerInitializer(Consumer<EntityManager> entityManagerInitializer) {
        this.entityManagerInitializer = entityManagerInitializer;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.getEntityManagerFactory() == null) {
            if (!(beanFactory instanceof ListableBeanFactory)) {
                throw new IllegalStateException("Cannot retrieve EntityManagerFactory by persistence unit name in a non-listable BeanFactory: " + String.valueOf(beanFactory));
            }
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            this.setEntityManagerFactory(EntityManagerFactoryUtils.findEntityManagerFactory(lbf, this.getPersistenceUnitName()));
        }
    }

    @Override
    public void afterPropertiesSet() {
        if (this.getEntityManagerFactory() == null) {
            throw new IllegalArgumentException("'entityManagerFactory' or 'persistenceUnitName' is required");
        }
        EntityManagerFactory entityManagerFactory = this.getEntityManagerFactory();
        if (entityManagerFactory instanceof EntityManagerFactoryInfo) {
            JpaDialect jpaDialect;
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)((Object)entityManagerFactory);
            DataSource dataSource = emfInfo.getDataSource();
            if (dataSource != null) {
                this.setDataSource(dataSource);
            }
            if ((jpaDialect = emfInfo.getJpaDialect()) != null) {
                this.setJpaDialect(jpaDialect);
            }
        }
    }

    @Override
    public Object getResourceFactory() {
        return this.obtainEntityManagerFactory();
    }

    @Override
    protected Object doGetTransaction() {
        JpaTransactionObject txObject = new JpaTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource(this.obtainEntityManagerFactory());
        if (emHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found thread-bound EntityManager [" + String.valueOf(emHolder.getEntityManager()) + "] for JPA transaction");
            }
            txObject.setEntityManagerHolder(emHolder, false);
        }
        if (this.getDataSource() != null) {
            ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(this.getDataSource());
            txObject.setConnectionHolder(conHolder);
        }
        return txObject;
    }

    @Override
    protected boolean isExistingTransaction(Object transaction) {
        return ((JpaTransactionObject)transaction).hasTransaction();
    }

    @Override
    protected void doBegin(Object transaction, TransactionDefinition definition) {
        JpaTransactionObject txObject = (JpaTransactionObject)transaction;
        if (txObject.hasConnectionHolder() && !txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! JpaTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single JpaTransactionManager for all transactions on a single DataSource, no matter whether JPA or JDBC access.");
        }
        try {
            if (!txObject.hasEntityManagerHolder() || txObject.getEntityManagerHolder().isSynchronizedWithTransaction()) {
                EntityManager newEm = this.createEntityManagerForTransaction();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Opened new EntityManager [" + String.valueOf(newEm) + "] for JPA transaction");
                }
                txObject.setEntityManagerHolder(new EntityManagerHolder(newEm), true);
            }
            EntityManager em = txObject.getEntityManagerHolder().getEntityManager();
            int timeoutToUse = this.determineTimeout(definition);
            Object transactionData = this.getJpaDialect().beginTransaction(em, new JpaTransactionDefinition(definition, timeoutToUse, txObject.isNewEntityManagerHolder()));
            txObject.setTransactionData(transactionData);
            txObject.setReadOnly(definition.isReadOnly());
            if (timeoutToUse != -1) {
                txObject.getEntityManagerHolder().setTimeoutInSeconds(timeoutToUse);
            }
            if (this.getDataSource() != null) {
                ConnectionHandle conHandle = this.getJpaDialect().getJdbcConnection(em, definition.isReadOnly());
                if (conHandle != null) {
                    ConnectionHolder conHolder = new ConnectionHolder(conHandle);
                    if (timeoutToUse != -1) {
                        conHolder.setTimeoutInSeconds(timeoutToUse);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Exposing JPA transaction as JDBC [" + String.valueOf(conHandle) + "]");
                    }
                    TransactionSynchronizationManager.bindResource(this.getDataSource(), conHolder);
                    txObject.setConnectionHolder(conHolder);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Not exposing JPA transaction [" + String.valueOf(em) + "] as JDBC transaction because JpaDialect [" + String.valueOf(this.getJpaDialect()) + "] does not support JDBC Connection retrieval");
                }
            }
            if (txObject.isNewEntityManagerHolder()) {
                TransactionSynchronizationManager.bindResource(this.obtainEntityManagerFactory(), txObject.getEntityManagerHolder());
            }
            txObject.getEntityManagerHolder().setSynchronizedWithTransaction(true);
        }
        catch (TransactionException ex) {
            this.closeEntityManagerAfterFailedBegin(txObject);
            throw ex;
        }
        catch (Throwable ex) {
            this.closeEntityManagerAfterFailedBegin(txObject);
            throw new CannotCreateTransactionException("Could not open JPA EntityManager for transaction", ex);
        }
    }

    protected EntityManager createEntityManagerForTransaction() {
        EntityManager em;
        EntityManagerFactory emf = this.obtainEntityManagerFactory();
        Map<String, Object> properties = this.getJpaPropertyMap();
        if (emf instanceof EntityManagerFactoryInfo) {
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)((Object)emf);
            em = emfInfo.createNativeEntityManager(properties);
        } else {
            EntityManager entityManager = em = !CollectionUtils.isEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
        }
        if (this.entityManagerInitializer != null) {
            this.entityManagerInitializer.accept(em);
        }
        return em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeEntityManagerAfterFailedBegin(JpaTransactionObject txObject) {
        if (txObject.isNewEntityManagerHolder()) {
            EntityManager em = txObject.getEntityManagerHolder().getEntityManager();
            try {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
            }
            catch (Throwable ex) {
                this.logger.debug("Could not rollback EntityManager after failed transaction begin", ex);
            }
            finally {
                EntityManagerFactoryUtils.closeEntityManager(em);
            }
            txObject.setEntityManagerHolder(null, false);
        }
    }

    @Override
    protected Object doSuspend(Object transaction) {
        JpaTransactionObject txObject = (JpaTransactionObject)transaction;
        txObject.setEntityManagerHolder(null, false);
        EntityManagerHolder entityManagerHolder = (EntityManagerHolder)TransactionSynchronizationManager.unbindResource(this.obtainEntityManagerFactory());
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null && TransactionSynchronizationManager.hasResource(this.getDataSource())) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        return new SuspendedResourcesHolder(entityManagerHolder, connectionHolder);
    }

    @Override
    protected void doResume(@Nullable Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource(this.obtainEntityManagerFactory(), resourcesHolder.getEntityManagerHolder());
        ConnectionHolder connectionHolder = resourcesHolder.getConnectionHolder();
        if (connectionHolder != null && this.getDataSource() != null) {
            TransactionSynchronizationManager.bindResource(this.getDataSource(), connectionHolder);
        }
    }

    @Override
    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return true;
    }

    @Override
    protected void doCommit(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Committing JPA transaction on EntityManager [" + String.valueOf(txObject.getEntityManagerHolder().getEntityManager()) + "]");
        }
        try {
            EntityTransaction tx = txObject.getEntityManagerHolder().getEntityManager().getTransaction();
            tx.commit();
        }
        catch (RollbackException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                DataAccessException dae = this.getJpaDialect().translateExceptionIfPossible(runtimeException);
                if (dae != null) {
                    throw dae;
                }
            }
            throw new TransactionSystemException("Could not commit JPA transaction", ex);
        }
        catch (RuntimeException ex) {
            throw DataAccessUtils.translateIfNecessary(ex, this.getJpaDialect());
        }
    }

    @Override
    protected void doRollback(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Rolling back JPA transaction on EntityManager [" + String.valueOf(txObject.getEntityManagerHolder().getEntityManager()) + "]");
        }
        try {
            EntityTransaction tx = txObject.getEntityManagerHolder().getEntityManager().getTransaction();
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        catch (PersistenceException ex) {
            DataAccessException dae = this.getJpaDialect().translateExceptionIfPossible(ex);
            if (dae != null) {
                throw dae;
            }
            throw new TransactionSystemException("Could not roll back JPA transaction", ex);
        }
        finally {
            if (!txObject.isNewEntityManagerHolder()) {
                txObject.getEntityManagerHolder().getEntityManager().clear();
            }
        }
    }

    @Override
    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Setting JPA transaction on EntityManager [" + String.valueOf(txObject.getEntityManagerHolder().getEntityManager()) + "] rollback-only");
        }
        txObject.setRollbackOnly();
    }

    @Override
    protected void doCleanupAfterCompletion(Object transaction) {
        JpaTransactionObject txObject = (JpaTransactionObject)transaction;
        if (txObject.isNewEntityManagerHolder()) {
            TransactionSynchronizationManager.unbindResourceIfPossible(this.obtainEntityManagerFactory());
        }
        txObject.getEntityManagerHolder().clear();
        if (this.getDataSource() != null && txObject.hasConnectionHolder()) {
            TransactionSynchronizationManager.unbindResource(this.getDataSource());
            ConnectionHandle conHandle = txObject.getConnectionHolder().getConnectionHandle();
            if (conHandle != null) {
                try {
                    this.getJpaDialect().releaseJdbcConnection(conHandle, txObject.getEntityManagerHolder().getEntityManager());
                }
                catch (Throwable ex) {
                    this.logger.error("Failed to release JDBC connection after transaction", ex);
                }
            }
        }
        this.getJpaDialect().cleanupTransaction(txObject.getTransactionData());
        if (txObject.isNewEntityManagerHolder()) {
            EntityManager em = txObject.getEntityManagerHolder().getEntityManager();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Closing JPA EntityManager [" + String.valueOf(em) + "] after transaction");
            }
            EntityManagerFactoryUtils.closeEntityManager(em);
        } else {
            this.logger.debug("Not closing pre-bound JPA EntityManager after transaction");
        }
    }

    private class JpaTransactionObject
    extends JdbcTransactionObjectSupport {
        @Nullable
        private EntityManagerHolder entityManagerHolder;
        private boolean newEntityManagerHolder;
        @Nullable
        private Object transactionData;

        private JpaTransactionObject() {
        }

        public void setEntityManagerHolder(@Nullable EntityManagerHolder entityManagerHolder, boolean newEntityManagerHolder) {
            this.entityManagerHolder = entityManagerHolder;
            this.newEntityManagerHolder = newEntityManagerHolder;
        }

        public EntityManagerHolder getEntityManagerHolder() {
            Assert.state(this.entityManagerHolder != null, "No EntityManagerHolder available");
            return this.entityManagerHolder;
        }

        public boolean hasEntityManagerHolder() {
            return this.entityManagerHolder != null;
        }

        public boolean isNewEntityManagerHolder() {
            return this.newEntityManagerHolder;
        }

        public boolean hasTransaction() {
            return this.entityManagerHolder != null && this.entityManagerHolder.isTransactionActive();
        }

        public void setTransactionData(@Nullable Object transactionData) {
            this.transactionData = transactionData;
            this.getEntityManagerHolder().setTransactionActive(true);
            if (transactionData instanceof SavepointManager) {
                SavepointManager savepointManager = (SavepointManager)transactionData;
                this.getEntityManagerHolder().setSavepointManager(savepointManager);
            }
        }

        @Nullable
        public Object getTransactionData() {
            return this.transactionData;
        }

        public void setRollbackOnly() {
            EntityTransaction tx = this.getEntityManagerHolder().getEntityManager().getTransaction();
            if (tx.isActive()) {
                tx.setRollbackOnly();
            }
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        @Override
        public boolean isRollbackOnly() {
            EntityTransaction tx = this.getEntityManagerHolder().getEntityManager().getTransaction();
            return tx.getRollbackOnly();
        }

        @Override
        public void flush() {
            try {
                this.getEntityManagerHolder().getEntityManager().flush();
            }
            catch (RuntimeException ex) {
                throw DataAccessUtils.translateIfNecessary(ex, JpaTransactionManager.this.getJpaDialect());
            }
        }

        @Override
        public Object createSavepoint() throws TransactionException {
            if (this.getEntityManagerHolder().isRollbackOnly()) {
                throw new CannotCreateTransactionException("Cannot create savepoint for transaction which is already marked as rollback-only");
            }
            return this.getSavepointManager().createSavepoint();
        }

        @Override
        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            this.getSavepointManager().rollbackToSavepoint(savepoint);
            this.getEntityManagerHolder().resetRollbackOnly();
        }

        @Override
        public void releaseSavepoint(Object savepoint) throws TransactionException {
            this.getSavepointManager().releaseSavepoint(savepoint);
        }

        private SavepointManager getSavepointManager() {
            if (!this.isSavepointAllowed()) {
                throw new NestedTransactionNotSupportedException("Transaction manager does not allow nested transactions");
            }
            SavepointManager savepointManager = this.getEntityManagerHolder().getSavepointManager();
            if (savepointManager == null) {
                throw new NestedTransactionNotSupportedException("JpaDialect does not support savepoints - check your JPA provider's capabilities");
            }
            return savepointManager;
        }
    }

    private static class JpaTransactionDefinition
    extends DelegatingTransactionDefinition
    implements ResourceTransactionDefinition {
        private final int timeout;
        private final boolean localResource;

        public JpaTransactionDefinition(TransactionDefinition targetDefinition, int timeout, boolean localResource) {
            super(targetDefinition);
            this.timeout = timeout;
            this.localResource = localResource;
        }

        @Override
        public int getTimeout() {
            return this.timeout;
        }

        @Override
        public boolean isLocalResource() {
            return this.localResource;
        }
    }

    private static final class SuspendedResourcesHolder {
        private final EntityManagerHolder entityManagerHolder;
        @Nullable
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(EntityManagerHolder emHolder, @Nullable ConnectionHolder conHolder) {
            this.entityManagerHolder = emHolder;
            this.connectionHolder = conHolder;
        }

        private EntityManagerHolder getEntityManagerHolder() {
            return this.entityManagerHolder;
        }

        @Nullable
        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

