/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scp;

import org.apache.camel.CamelContext;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.component.scp.ScpEndpoint;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class ScpEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ScpEndpoint target = (ScpEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allownullbody": 
            case "allowNullBody": {
                target.setAllowNullBody(ScpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "checksumfilealgorithm": 
            case "checksumFileAlgorithm": {
                target.setChecksumFileAlgorithm(ScpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "chmod": {
                target.getConfiguration().setChmod(ScpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "ciphers": {
                target.getConfiguration().setCiphers(ScpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                target.getConfiguration().setConnectTimeout(ScpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "disconnect": {
                target.setDisconnect(ScpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "disconnectonbatchcomplete": 
            case "disconnectOnBatchComplete": {
                target.setDisconnectOnBatchComplete(ScpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "filename": 
            case "fileName": {
                target.setFileName(ScpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "flatten": {
                target.setFlatten(ScpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "jailstartingdirectory": 
            case "jailStartingDirectory": {
                target.setJailStartingDirectory(ScpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "knownhostsfile": 
            case "knownHostsFile": {
                target.getConfiguration().setKnownHostsFile(ScpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(ScpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "moveexistingfilestrategy": 
            case "moveExistingFileStrategy": {
                target.setMoveExistingFileStrategy(ScpEndpointConfigurer.property(camelContext, FileMoveExistingStrategy.class, value));
                return true;
            }
            case "password": {
                target.getConfiguration().setPassword(ScpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "preferredauthentications": 
            case "preferredAuthentications": {
                target.getConfiguration().setPreferredAuthentications(ScpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "privatekeybytes": 
            case "privateKeyBytes": {
                target.getConfiguration().setPrivateKeyBytes(ScpEndpointConfigurer.property(camelContext, byte[].class, value));
                return true;
            }
            case "privatekeyfile": 
            case "privateKeyFile": {
                target.getConfiguration().setPrivateKeyFile(ScpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "privatekeyfilepassphrase": 
            case "privateKeyFilePassphrase": {
                target.getConfiguration().setPrivateKeyFilePassphrase(ScpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sotimeout": 
            case "soTimeout": {
                target.getConfiguration().setSoTimeout(ScpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "stricthostkeychecking": 
            case "strictHostKeyChecking": {
                target.getConfiguration().setStrictHostKeyChecking(ScpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "timeout": {
                target.getConfiguration().setTimeout(ScpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "useuserknownhostsfile": 
            case "useUserKnownHostsFile": {
                target.getConfiguration().setUseUserKnownHostsFile(ScpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "username": {
                target.getConfiguration().setUsername(ScpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allownullbody": 
            case "allowNullBody": {
                return Boolean.TYPE;
            }
            case "checksumfilealgorithm": 
            case "checksumFileAlgorithm": {
                return String.class;
            }
            case "chmod": {
                return String.class;
            }
            case "ciphers": {
                return String.class;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return Integer.TYPE;
            }
            case "disconnect": {
                return Boolean.TYPE;
            }
            case "disconnectonbatchcomplete": 
            case "disconnectOnBatchComplete": {
                return Boolean.TYPE;
            }
            case "filename": 
            case "fileName": {
                return String.class;
            }
            case "flatten": {
                return Boolean.TYPE;
            }
            case "jailstartingdirectory": 
            case "jailStartingDirectory": {
                return Boolean.TYPE;
            }
            case "knownhostsfile": 
            case "knownHostsFile": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "moveexistingfilestrategy": 
            case "moveExistingFileStrategy": {
                return FileMoveExistingStrategy.class;
            }
            case "password": {
                return String.class;
            }
            case "preferredauthentications": 
            case "preferredAuthentications": {
                return String.class;
            }
            case "privatekeybytes": 
            case "privateKeyBytes": {
                return byte[].class;
            }
            case "privatekeyfile": 
            case "privateKeyFile": {
                return String.class;
            }
            case "privatekeyfilepassphrase": 
            case "privateKeyFilePassphrase": {
                return String.class;
            }
            case "sotimeout": 
            case "soTimeout": {
                return Integer.TYPE;
            }
            case "stricthostkeychecking": 
            case "strictHostKeyChecking": {
                return String.class;
            }
            case "timeout": {
                return Integer.TYPE;
            }
            case "useuserknownhostsfile": 
            case "useUserKnownHostsFile": {
                return Boolean.TYPE;
            }
            case "username": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ScpEndpoint target = (ScpEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allownullbody": 
            case "allowNullBody": {
                return target.isAllowNullBody();
            }
            case "checksumfilealgorithm": 
            case "checksumFileAlgorithm": {
                return target.getChecksumFileAlgorithm();
            }
            case "chmod": {
                return target.getConfiguration().getChmod();
            }
            case "ciphers": {
                return target.getConfiguration().getCiphers();
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return target.getConfiguration().getConnectTimeout();
            }
            case "disconnect": {
                return target.isDisconnect();
            }
            case "disconnectonbatchcomplete": 
            case "disconnectOnBatchComplete": {
                return target.isDisconnectOnBatchComplete();
            }
            case "filename": 
            case "fileName": {
                return target.getFileName();
            }
            case "flatten": {
                return target.isFlatten();
            }
            case "jailstartingdirectory": 
            case "jailStartingDirectory": {
                return target.isJailStartingDirectory();
            }
            case "knownhostsfile": 
            case "knownHostsFile": {
                return target.getConfiguration().getKnownHostsFile();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "moveexistingfilestrategy": 
            case "moveExistingFileStrategy": {
                return target.getMoveExistingFileStrategy();
            }
            case "password": {
                return target.getConfiguration().getPassword();
            }
            case "preferredauthentications": 
            case "preferredAuthentications": {
                return target.getConfiguration().getPreferredAuthentications();
            }
            case "privatekeybytes": 
            case "privateKeyBytes": {
                return target.getConfiguration().getPrivateKeyBytes();
            }
            case "privatekeyfile": 
            case "privateKeyFile": {
                return target.getConfiguration().getPrivateKeyFile();
            }
            case "privatekeyfilepassphrase": 
            case "privateKeyFilePassphrase": {
                return target.getConfiguration().getPrivateKeyFilePassphrase();
            }
            case "sotimeout": 
            case "soTimeout": {
                return target.getConfiguration().getSoTimeout();
            }
            case "stricthostkeychecking": 
            case "strictHostKeyChecking": {
                return target.getConfiguration().getStrictHostKeyChecking();
            }
            case "timeout": {
                return target.getConfiguration().getTimeout();
            }
            case "useuserknownhostsfile": 
            case "useUserKnownHostsFile": {
                return target.getConfiguration().isUseUserKnownHostsFile();
            }
            case "username": {
                return target.getConfiguration().getUsername();
            }
        }
        return null;
    }
}

