/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.support.SimpleRegistry;

public class SupplierRegistry
extends SimpleRegistry {
    @Override
    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Supplier supplier;
        Object value;
        Map map = (Map)this.get(name);
        if (map == null) {
            return null;
        }
        Object answer = map.get(type);
        if (answer instanceof Supplier) {
            Iterator supplier2 = (Supplier)answer;
            answer = supplier2.get();
        }
        if (answer == null) {
            for (Map.Entry entry : map.entrySet()) {
                if (!type.isAssignableFrom((Class)entry.getKey())) continue;
                value = entry.getValue();
                if (value instanceof Supplier) {
                    supplier = (Supplier)value;
                    value = supplier.get();
                }
                answer = value;
                break;
            }
        }
        if (answer == null) {
            for (Map.Entry entry : map.entrySet()) {
                if (Object.class != entry.getKey()) continue;
                value = entry.getValue();
                if (value instanceof Supplier) {
                    supplier = (Supplier)value;
                    value = supplier.get();
                }
                if (!type.isInstance(value)) continue;
                answer = value;
                break;
            }
        }
        if (answer == null) {
            return null;
        }
        try {
            answer = this.unwrap(answer);
            return type.cast(answer);
        }
        catch (Exception e) {
            String msg = "Found bean: " + name + " in SupplierRegistry: " + this + " of type: " + answer.getClass().getName() + " expected type was: " + type;
            throw new NoSuchBeanException(name, msg, e);
        }
    }

    @Override
    public <T> Set<T> findByType(Class<T> type) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (Map.Entry entry : this.entrySet()) {
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                if (!type.isAssignableFrom((Class)subEntry.getKey())) continue;
                Object value = subEntry.getValue();
                if (value instanceof Supplier) {
                    Supplier supplier = (Supplier)value;
                    value = supplier.get();
                }
                result.add(type.cast(value));
            }
        }
        return result;
    }

    @Override
    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>();
        for (Map.Entry entry : this.entrySet()) {
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                if (!type.isAssignableFrom((Class)subEntry.getKey())) continue;
                Object value = subEntry.getValue();
                if (value instanceof Supplier) {
                    Supplier supplier = (Supplier)value;
                    value = supplier.get();
                }
                result.put((String)entry.getKey(), type.cast(value));
            }
        }
        return result;
    }

    @Override
    public void bind(String id, Class<?> type, Supplier<Object> bean) {
        if (bean != null) {
            this.computeIfAbsent(id, k -> new LinkedHashMap()).put(type, this.wrap(bean));
        }
    }
}

