/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.remote.FtpOperations;
import org.apache.camel.component.file.remote.FtpsConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPSClient;

public class FtpsOperations
extends FtpOperations {
    public FtpsOperations(FTPSClient client, FTPClientConfig clientConfig) {
        super(client, clientConfig);
    }

    @Override
    public boolean connect(RemoteFileConfiguration configuration, Exchange exchange) throws GenericFileOperationFailedException {
        boolean answer = super.connect(configuration, exchange);
        FtpsConfiguration config = (FtpsConfiguration)configuration;
        if (answer) {
            try {
                String execProt = config.getExecProt();
                Long execPbsz = config.getExecPbsz();
                if (!config.isDisableSecureDataChannelDefaults()) {
                    if (ObjectHelper.isEmpty(execProt)) {
                        execProt = "P";
                    }
                    if (ObjectHelper.isEmpty(execPbsz)) {
                        execPbsz = 0L;
                    }
                }
                if (execPbsz != null) {
                    this.log.debug("FTPClient initializing with execPbsz={}", (Object)execPbsz);
                    this.getFtpClient().execPBSZ(execPbsz);
                }
                if (execProt != null) {
                    this.log.debug("FTPClient initializing with execProt={}", (Object)execProt);
                    this.getFtpClient().execPROT(execProt);
                }
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), e);
            }
            finally {
                if (exchange != null) {
                    exchange.getIn().setHeader("CamelFtpReplyCode", this.client.getReplyCode());
                    exchange.getIn().setHeader("CamelFtpReplyString", this.client.getReplyString());
                }
            }
        }
        return answer;
    }

    @Override
    protected FTPSClient getFtpClient() {
        return (FTPSClient)super.getFtpClient();
    }
}

