/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.FtpUtils;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.SftpConfiguration;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.camel.component.file.remote.SftpRemoteFile;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.util.StringHelper;

@Component(value="sftp")
public class SftpComponent
extends RemoteFileComponent<SftpRemoteFile> {
    public SftpComponent() {
    }

    public SftpComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected GenericFileEndpoint<SftpRemoteFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String baseUri = StringHelper.before(uri, "?", uri);
        SftpConfiguration config = new SftpConfiguration(new URI(baseUri));
        FtpUtils.ensureRelativeFtpDirectory(this, config);
        return new SftpEndpoint(uri, this, config);
    }

    @Override
    protected void afterPropertiesSet(GenericFileEndpoint<SftpRemoteFile> endpoint) throws Exception {
    }
}

