/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.schibsted.spt.data.jslt.Function;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.AbstractCallable;
import com.schibsted.spt.data.jslt.impl.AbstractFunction;
import com.schibsted.spt.data.jslt.impl.BoundedCache;
import com.schibsted.spt.data.jslt.impl.ComparisonOperator;
import com.schibsted.spt.data.jslt.impl.EqualsComparison;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Macro;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.RegexpFunction;
import com.schibsted.spt.data.jslt.impl.Scope;
import com.schibsted.spt.data.jslt.impl.Utils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class BuiltinFunctions {
    public static Map<String, Function> functions = new HashMap<String, Function>();
    public static Map<String, Macro> macros;
    static Map<String, Pattern> cache;

    static synchronized Pattern getRegexp(String regexp) {
        Pattern p = cache.get(regexp);
        if (p == null) {
            try {
                p = Pattern.compile(regexp);
            }
            catch (PatternSyntaxException e) {
                throw new JsltException("Syntax error in regular expression '" + regexp + "'", e);
            }
            cache.put(regexp, p);
        }
        return p;
    }

    private static int copy(String input, char[] buf, int bufix, int from, int to) {
        for (int ix = from; ix < to; ++ix) {
            buf[bufix++] = input.charAt(ix);
        }
        return bufix;
    }

    static {
        functions.put("contains", new Contains());
        functions.put("size", new Size());
        functions.put("error", new Error());
        functions.put("min", new Min());
        functions.put("max", new Max());
        functions.put("is-number", new IsNumber());
        functions.put("is-integer", new IsInteger());
        functions.put("is-decimal", new IsDecimal());
        functions.put("number", new Number());
        functions.put("round", new Round());
        functions.put("floor", new Floor());
        functions.put("ceiling", new Ceiling());
        functions.put("random", new Random());
        functions.put("sum", new Sum());
        functions.put("mod", new Modulo());
        functions.put("hash-int", new HashInt());
        functions.put("is-string", new IsString());
        functions.put("string", new ToString());
        functions.put("test", new Test());
        functions.put("capture", new Capture());
        functions.put("split", new Split());
        functions.put("join", new Join());
        functions.put("lowercase", new Lowercase());
        functions.put("uppercase", new Uppercase());
        functions.put("sha256-hex", new Sha256());
        functions.put("starts-with", new StartsWith());
        functions.put("ends-with", new EndsWith());
        functions.put("from-json", new FromJson());
        functions.put("to-json", new ToJson());
        functions.put("replace", new Replace());
        functions.put("trim", new Trim());
        functions.put("uuid", new Uuid());
        functions.put("not", new Not());
        functions.put("boolean", new Boolean());
        functions.put("is-boolean", new IsBoolean());
        functions.put("is-object", new IsObject());
        functions.put("get-key", new GetKey());
        functions.put("array", new Array());
        functions.put("is-array", new IsArray());
        functions.put("flatten", new Flatten());
        functions.put("all", new All());
        functions.put("any", new Any());
        functions.put("zip", new Zip());
        functions.put("zip-with-index", new ZipWithIndex());
        functions.put("index-of", new IndexOf());
        functions.put("now", new Now());
        functions.put("parse-time", new ParseTime());
        functions.put("format-time", new FormatTime());
        functions.put("parse-url", new ParseUrl());
        macros = new HashMap<String, Macro>();
        macros.put("fallback", new Fallback());
        cache = new BoundedCache<String, Pattern>(1000);
    }

    public static class ParseUrl
    extends AbstractFunction {
        public ParseUrl() {
            super("parse-url", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (arguments[0].isNull()) {
                return NullNode.instance;
            }
            String urlString = arguments[0].asText();
            try {
                URL aURL = new URL(arguments[0].asText());
                ObjectNode objectNode = NodeUtils.mapper.createObjectNode();
                if (aURL.getHost() != null && !aURL.getHost().isEmpty()) {
                    objectNode.put("host", aURL.getHost());
                }
                if (aURL.getPort() != -1) {
                    objectNode.put("port", aURL.getPort());
                }
                if (!aURL.getPath().isEmpty()) {
                    objectNode.put("path", aURL.getPath());
                }
                if (aURL.getProtocol() != null && !aURL.getProtocol().isEmpty()) {
                    objectNode.put("scheme", aURL.getProtocol());
                }
                if (aURL.getQuery() != null && !aURL.getQuery().isEmpty()) {
                    String[] pairs;
                    objectNode.put("query", aURL.getQuery());
                    ObjectNode queryParamsNode = NodeUtils.mapper.createObjectNode();
                    objectNode.set("parameters", queryParamsNode);
                    for (String pair : pairs = aURL.getQuery().split("&")) {
                        String key;
                        int idx = pair.indexOf("=");
                        String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                        if (!queryParamsNode.has(key)) {
                            queryParamsNode.set(key, NodeUtils.mapper.createArrayNode());
                        }
                        String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                        ArrayNode valuesNode = (ArrayNode)queryParamsNode.get(key);
                        valuesNode.add(value);
                    }
                }
                if (aURL.getRef() != null) {
                    objectNode.put("fragment", aURL.getRef());
                }
                if (aURL.getUserInfo() != null && !aURL.getUserInfo().isEmpty()) {
                    objectNode.put("userinfo", aURL.getUserInfo());
                }
                return objectNode;
            }
            catch (UnsupportedEncodingException | MalformedURLException e) {
                throw new JsltException("Can't parse " + urlString, e);
            }
        }
    }

    public static class Max
    extends AbstractFunction {
        public Max() {
            super("max", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (arguments[0].isNull() || arguments[1].isNull()) {
                return NullNode.instance;
            }
            if (ComparisonOperator.compare(arguments[0], arguments[1], null) > 0.0) {
                return arguments[0];
            }
            return arguments[1];
        }
    }

    public static class Min
    extends AbstractFunction {
        public Min() {
            super("min", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (ComparisonOperator.compare(arguments[0], arguments[1], null) < 0.0) {
                return arguments[0];
            }
            return arguments[1];
        }
    }

    public static class FormatTime
    extends AbstractFunction {
        static Set<String> zonenames = new HashSet<String>();

        public FormatTime() {
            super("format-time", 2, 3);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode number = NodeUtils.number(arguments[0], null);
            if (number == null || number.isNull()) {
                return NullNode.instance;
            }
            double timestamp = number.asDouble();
            String formatstr = NodeUtils.toString(arguments[1], false);
            TimeZone zone = new SimpleTimeZone(0, "UTC");
            if (arguments.length == 3) {
                String zonename = NodeUtils.toString(arguments[2], false);
                if (!zonenames.contains(zonename)) {
                    throw new JsltException("format-time: Unknown timezone " + zonename);
                }
                zone = TimeZone.getTimeZone(zonename);
            }
            try {
                SimpleDateFormat format = new SimpleDateFormat(formatstr);
                format.setTimeZone(zone);
                String formatted = format.format(Math.round(timestamp * 1000.0));
                return new TextNode(formatted);
            }
            catch (IllegalArgumentException e) {
                throw new JsltException("format-time: Couldn't parse format '" + formatstr + "': " + e.getMessage());
            }
        }

        static {
            zonenames.addAll(Arrays.asList(TimeZone.getAvailableIDs()));
        }
    }

    public static class ParseTime
    extends AbstractFunction {
        public ParseTime() {
            super("parse-time", 2, 3);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            String text = NodeUtils.toString(arguments[0], true);
            if (text == null) {
                return NullNode.instance;
            }
            String formatstr = NodeUtils.toString(arguments[1], false);
            JsonNode fallback = null;
            if (arguments.length > 2) {
                fallback = arguments[2];
            }
            try {
                SimpleDateFormat format = new SimpleDateFormat(formatstr);
                format.setTimeZone(new SimpleTimeZone(0, "UTC"));
                Date time = format.parse(text);
                return NodeUtils.toJson((double)time.getTime() / 1000.0);
            }
            catch (IllegalArgumentException e) {
                throw new JsltException("parse-time: Couldn't parse format '" + formatstr + "': " + e.getMessage());
            }
            catch (ParseException e) {
                if (fallback == null) {
                    throw new JsltException("parse-time: " + e.getMessage());
                }
                return fallback;
            }
        }
    }

    public static class Now
    extends AbstractFunction {
        public Now() {
            super("now", 0, 0);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            long ms = System.currentTimeMillis();
            return NodeUtils.toJson((double)ms / 1000.0);
        }
    }

    public static class IsDecimal
    extends AbstractFunction {
        public IsDecimal() {
            super("is-decimal", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            return NodeUtils.toJson(arguments[0].isFloatingPointNumber());
        }
    }

    public static class IsInteger
    extends AbstractFunction {
        public IsInteger() {
            super("is-integer", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            return NodeUtils.toJson(arguments[0].isIntegralNumber());
        }
    }

    public static class IsNumber
    extends AbstractFunction {
        public IsNumber() {
            super("is-number", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            return NodeUtils.toJson(arguments[0].isNumber());
        }
    }

    public static class IsString
    extends AbstractFunction {
        public IsString() {
            super("is-string", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            return NodeUtils.toJson(arguments[0].isTextual());
        }
    }

    public static class ToString
    extends AbstractFunction {
        public ToString() {
            super("string", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (arguments[0].isTextual()) {
                return arguments[0];
            }
            return new TextNode(arguments[0].toString());
        }
    }

    public static class Error
    extends AbstractFunction {
        public Error() {
            super("error", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            String msg = NodeUtils.toString(arguments[0], false);
            throw new JsltException("error: " + msg);
        }
    }

    public static class Size
    extends AbstractFunction {
        public Size() {
            super("size", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (arguments[0].isArray() || arguments[0].isObject()) {
                return new IntNode(arguments[0].size());
            }
            if (arguments[0].isTextual()) {
                return new IntNode(arguments[0].asText().length());
            }
            if (arguments[0].isNull()) {
                return arguments[0];
            }
            throw new JsltException("Function size() cannot work on " + arguments[0]);
        }
    }

    public static class Contains
    extends AbstractFunction {
        public Contains() {
            super("contains", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (arguments[1].isNull()) {
                return BooleanNode.FALSE;
            }
            if (arguments[1].isArray()) {
                for (int ix = 0; ix < arguments[1].size(); ++ix) {
                    if (!arguments[1].get(ix).equals(arguments[0])) continue;
                    return BooleanNode.TRUE;
                }
            } else {
                if (arguments[1].isObject()) {
                    String key = NodeUtils.toString(arguments[0], true);
                    if (key == null) {
                        return BooleanNode.FALSE;
                    }
                    return NodeUtils.toJson(arguments[1].has(key));
                }
                if (arguments[1].isTextual()) {
                    String sub = NodeUtils.toString(arguments[0], true);
                    if (sub == null) {
                        return BooleanNode.FALSE;
                    }
                    String str = arguments[1].asText();
                    return NodeUtils.toJson(str.indexOf(sub) != -1);
                }
                throw new JsltException("Contains cannot operate on " + arguments[1]);
            }
            return BooleanNode.FALSE;
        }
    }

    public static class Join
    extends AbstractFunction {
        public Join() {
            super("join", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            ArrayNode array = NodeUtils.toArray(arguments[0], true);
            if (array == null) {
                return NullNode.instance;
            }
            String sep = NodeUtils.toString(arguments[1], false);
            StringBuilder buf = new StringBuilder();
            for (int ix = 0; ix < array.size(); ++ix) {
                if (ix > 0) {
                    buf.append(sep);
                }
                buf.append(NodeUtils.toString(array.get(ix), false));
            }
            return new TextNode(buf.toString());
        }
    }

    public static class Uuid
    extends AbstractFunction {
        public Uuid() {
            super("uuid", 0, 2);
        }

        private long maskMSB(long number) {
            long version = 4096L;
            long least12SignificantBit = (number & 0xFFFFL) >> 4;
            return (number & 0xFFFFFFFFFFFF0000L) + 4096L + least12SignificantBit;
        }

        private long maskLSB(long number) {
            long LSB_MASK = 0x3FFFFFFFFFFFFFFFL;
            long LSB_VARIANT3_BITFLAG = Long.MIN_VALUE;
            return (number & 0x3FFFFFFFFFFFFFFFL) + Long.MIN_VALUE;
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            String uuid;
            if (arguments.length == 0) {
                uuid = UUID.randomUUID().toString();
            } else if (arguments.length == 2) {
                if (arguments[0].isNull() && arguments[1].isNull()) {
                    uuid = "00000000-0000-0000-0000-000000000000";
                } else {
                    long msb = NodeUtils.number(arguments[0], null).asLong();
                    long lsb = NodeUtils.number(arguments[1], null).asLong();
                    uuid = new UUID(this.maskMSB(msb), this.maskLSB(lsb)).toString();
                }
            } else {
                throw new JsltException("Build-in UUID function must be called with either none or two parameters.");
            }
            return new TextNode(uuid);
        }
    }

    public static class Trim
    extends AbstractFunction {
        public Trim() {
            super("trim", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            String string = NodeUtils.toString(arguments[0], true);
            if (string == null) {
                return NullNode.instance;
            }
            return new TextNode(string.trim());
        }
    }

    public static class Replace
    extends AbstractRegexpFunction {
        public Replace() {
            super("replace", 3, 3);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            String string = NodeUtils.toString(arguments[0], true);
            if (string == null) {
                return NullNode.instance;
            }
            String regexp = NodeUtils.toString(arguments[1], false);
            String sep = NodeUtils.toString(arguments[2], false);
            Pattern p = BuiltinFunctions.getRegexp(regexp);
            Matcher m = p.matcher(string);
            char[] buf = new char[string.length() * Math.max(sep.length(), 1)];
            int pos = 0;
            int bufix = 0;
            while (m.find(pos)) {
                if (m.start() == m.end()) {
                    throw new JsltException("Regexp " + regexp + " in replace() matched empty string in '" + arguments[0] + "'");
                }
                if (pos < m.start()) {
                    bufix = BuiltinFunctions.copy(string, buf, bufix, pos, m.start());
                }
                bufix = BuiltinFunctions.copy(sep, buf, bufix, 0, sep.length());
                pos = m.end();
            }
            if (pos == 0 && arguments[0].isTextual()) {
                return arguments[0];
            }
            if (pos < string.length()) {
                bufix = BuiltinFunctions.copy(string, buf, bufix, pos, string.length());
            }
            return new TextNode(new String(buf, 0, bufix));
        }
    }

    public static class ToJson
    extends AbstractFunction {
        public ToJson() {
            super("to-json", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            try {
                String json = NodeUtils.mapper.writeValueAsString(arguments[0]);
                return new TextNode(json);
            }
            catch (Exception e) {
                throw new JsltException("to-json can't serialize " + arguments[0] + ": " + e);
            }
        }
    }

    public static class FromJson
    extends AbstractFunction {
        public FromJson() {
            super("from-json", 1, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            String json = NodeUtils.toString(arguments[0], true);
            if (json == null) {
                return NullNode.instance;
            }
            try {
                JsonNode parsed = NodeUtils.mapper.readTree(json);
                if (parsed == null) {
                    return NullNode.instance;
                }
                return parsed;
            }
            catch (Exception e) {
                if (arguments.length == 2) {
                    return arguments[1];
                }
                throw new JsltException("from-json can't parse " + json + ": " + e);
            }
        }
    }

    public static class EndsWith
    extends AbstractFunction {
        public EndsWith() {
            super("ends-with", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            String string = NodeUtils.toString(arguments[0], false);
            String suffix = NodeUtils.toString(arguments[1], false);
            return NodeUtils.toJson(string.endsWith(suffix));
        }
    }

    public static class StartsWith
    extends AbstractFunction {
        public StartsWith() {
            super("starts-with", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            String string = NodeUtils.toString(arguments[0], false);
            String prefix = NodeUtils.toString(arguments[1], false);
            return NodeUtils.toJson(string.startsWith(prefix));
        }
    }

    public static class IndexOf
    extends AbstractFunction {
        public IndexOf() {
            super("index-of", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode array = arguments[0];
            if (array.isNull()) {
                return NullNode.instance;
            }
            if (!array.isArray()) {
                throw new JsltException("index-of() first argument must be an array");
            }
            JsonNode value = arguments[1];
            for (int ix = 0; ix < array.size(); ++ix) {
                if (!EqualsComparison.equals(array.get(ix), value)) continue;
                return new IntNode(ix);
            }
            return new IntNode(-1);
        }
    }

    public static class ZipWithIndex
    extends AbstractFunction {
        public ZipWithIndex() {
            super("zip-with-index", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode arrayIn = arguments[0];
            if (arrayIn.isNull()) {
                return NullNode.instance;
            }
            if (!arrayIn.isArray()) {
                throw new JsltException("zip-with-index() argument must be an array");
            }
            ArrayNode arrayOut = NodeUtils.mapper.createArrayNode();
            for (int ix = 0; ix < arrayIn.size(); ++ix) {
                ObjectNode pair = NodeUtils.mapper.createObjectNode();
                pair.set("index", new IntNode(ix));
                pair.set("value", arrayIn.get(ix));
                arrayOut.add(pair);
            }
            return arrayOut;
        }
    }

    public static class Zip
    extends AbstractFunction {
        public Zip() {
            super("zip", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode array1 = arguments[0];
            JsonNode array2 = arguments[1];
            if (array1.isNull() || array2.isNull()) {
                return NullNode.instance;
            }
            if (!array1.isArray() || !array2.isArray()) {
                throw new JsltException("zip() requires arrays");
            }
            if (array1.size() != array2.size()) {
                throw new JsltException("zip() arrays were of unequal size");
            }
            ArrayNode array = NodeUtils.mapper.createArrayNode();
            for (int ix = 0; ix < array1.size(); ++ix) {
                ArrayNode pair = NodeUtils.mapper.createArrayNode();
                pair.add(array1.get(ix));
                pair.add(array2.get(ix));
                array.add(pair);
            }
            return array;
        }
    }

    public static class Any
    extends AbstractFunction {
        public Any() {
            super("any", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode value = arguments[0];
            if (value.isNull()) {
                return value;
            }
            if (!value.isArray()) {
                throw new JsltException("any() requires an array, not " + value);
            }
            for (int ix = 0; ix < value.size(); ++ix) {
                JsonNode node = value.get(ix);
                if (!NodeUtils.isTrue(node)) continue;
                return BooleanNode.TRUE;
            }
            return BooleanNode.FALSE;
        }
    }

    public static class All
    extends AbstractFunction {
        public All() {
            super("all", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode value = arguments[0];
            if (value.isNull()) {
                return value;
            }
            if (!value.isArray()) {
                throw new JsltException("all() requires an array, not " + value);
            }
            for (int ix = 0; ix < value.size(); ++ix) {
                JsonNode node = value.get(ix);
                if (NodeUtils.isTrue(node)) continue;
                return BooleanNode.FALSE;
            }
            return BooleanNode.TRUE;
        }
    }

    public static class Flatten
    extends AbstractFunction {
        public Flatten() {
            super("flatten", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode value = arguments[0];
            if (value.isNull()) {
                return value;
            }
            if (!value.isArray()) {
                throw new JsltException("flatten() cannot operate on " + value);
            }
            ArrayNode array = NodeUtils.mapper.createArrayNode();
            this.flatten(array, value);
            return array;
        }

        private void flatten(ArrayNode array, JsonNode current) {
            for (int ix = 0; ix < current.size(); ++ix) {
                JsonNode node = current.get(ix);
                if (node.isArray()) {
                    this.flatten(array, node);
                    continue;
                }
                array.add(node);
            }
        }
    }

    public static class Array
    extends AbstractFunction {
        public Array() {
            super("array", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode value = arguments[0];
            if (value.isNull() || value.isArray()) {
                return value;
            }
            if (value.isObject()) {
                return NodeUtils.convertObjectToArray(value);
            }
            throw new JsltException("array() cannot convert " + value);
        }
    }

    public static class IsArray
    extends AbstractFunction {
        public IsArray() {
            super("is-array", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            return NodeUtils.toJson(arguments[0].isArray());
        }
    }

    public static class GetKey
    extends AbstractFunction {
        public GetKey() {
            super("get-key", 2, 3);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            String key = NodeUtils.toString(arguments[1], true);
            if (key == null) {
                return NullNode.instance;
            }
            JsonNode obj = arguments[0];
            if (obj.isObject()) {
                JsonNode value = obj.get(key);
                if (value == null) {
                    if (arguments.length == 2) {
                        return NullNode.instance;
                    }
                    return arguments[2];
                }
                return value;
            }
            if (obj.isNull()) {
                return NullNode.instance;
            }
            throw new JsltException("get-key: can't look up keys in " + obj);
        }
    }

    public static class IsObject
    extends AbstractFunction {
        public IsObject() {
            super("is-object", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            return NodeUtils.toJson(arguments[0].isObject());
        }
    }

    public static class Fallback
    extends AbstractMacro {
        public Fallback() {
            super("fallback", 2, 1024);
        }

        @Override
        public JsonNode call(Scope scope, JsonNode input, ExpressionNode[] parameters) {
            for (int ix = 0; ix < parameters.length; ++ix) {
                JsonNode value = parameters[ix].apply(scope, input);
                if (!NodeUtils.isValue(value)) continue;
                return value;
            }
            return NullNode.instance;
        }
    }

    public static class IsBoolean
    extends AbstractFunction {
        public IsBoolean() {
            super("is-boolean", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            return NodeUtils.toJson(arguments[0].isBoolean());
        }
    }

    public static class Boolean
    extends AbstractFunction {
        public Boolean() {
            super("boolean", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            return NodeUtils.toJson(NodeUtils.isTrue(arguments[0]));
        }
    }

    public static class Not
    extends AbstractFunction {
        public Not() {
            super("not", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            return NodeUtils.toJson(!NodeUtils.isTrue(arguments[0]));
        }
    }

    public static class Sha256
    extends AbstractFunction {
        public Sha256() {
            super("sha256-hex", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            MessageDigest messageDigest;
            if (arguments[0].isNull()) {
                return arguments[0];
            }
            String message = NodeUtils.toString(arguments[0], false);
            try {
                messageDigest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new JsltException("sha256-hex: could not find sha256 algorithm " + e);
            }
            byte[] bytes = messageDigest.digest(message.getBytes(StandardCharsets.UTF_8));
            String string = Utils.printHexBinary(bytes);
            return new TextNode(string);
        }
    }

    public static class Uppercase
    extends AbstractFunction {
        public Uppercase() {
            super("uppercase", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (arguments[0].isNull()) {
                return arguments[0];
            }
            String string = NodeUtils.toString(arguments[0], false);
            return new TextNode(string.toUpperCase());
        }
    }

    public static class Lowercase
    extends AbstractFunction {
        public Lowercase() {
            super("lowercase", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (arguments[0].isNull()) {
                return arguments[0];
            }
            String string = NodeUtils.toString(arguments[0], false);
            return new TextNode(string.toLowerCase());
        }
    }

    public static class Split
    extends AbstractRegexpFunction {
        public Split() {
            super("split", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (arguments[0].isNull()) {
                return arguments[0];
            }
            String string = NodeUtils.toString(arguments[0], false);
            String split = NodeUtils.toString(arguments[1], true);
            if (split == null) {
                throw new JsltException("split() can't split on null");
            }
            return NodeUtils.toJson(string.split(split));
        }
    }

    private static abstract class AbstractRegexpFunction
    extends AbstractFunction
    implements RegexpFunction {
        AbstractRegexpFunction(String name, int min, int max) {
            super(name, min, max);
        }

        @Override
        public int regexpArgumentNumber() {
            return 1;
        }
    }

    private static class JstlPattern {
        private Pattern pattern;
        private Set<String> groups;
        private static Pattern extractor = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");

        public JstlPattern(String regexp) {
            this.pattern = Pattern.compile(regexp);
            this.groups = JstlPattern.getNamedGroups(regexp);
        }

        public Matcher matcher(String input) {
            return this.pattern.matcher(input);
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        private static Set<String> getNamedGroups(String regex) {
            TreeSet<String> groups = new TreeSet<String>();
            Matcher m = extractor.matcher(regex);
            while (m.find()) {
                groups.add(m.group(1));
            }
            return groups;
        }
    }

    public static class Capture
    extends AbstractRegexpFunction {
        static Map<String, JstlPattern> cache = new BoundedCache<String, JstlPattern>(1000);

        public Capture() {
            super("capture", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (arguments[0].isNull()) {
                return arguments[0];
            }
            String string = NodeUtils.toString(arguments[0], false);
            String regexps = NodeUtils.toString(arguments[1], true);
            if (regexps == null) {
                throw new JsltException("capture() can't match against null regexp");
            }
            JstlPattern regex = cache.get(regexps);
            if (regex == null) {
                regex = new JstlPattern(regexps);
                cache.put(regexps, regex);
            }
            ObjectNode node = NodeUtils.mapper.createObjectNode();
            Matcher m = regex.matcher(string);
            if (m.find()) {
                for (String group : regex.getGroups()) {
                    try {
                        node.put(group, m.group(group));
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            return node;
        }
    }

    public static class Test
    extends AbstractRegexpFunction {
        public Test() {
            super("test", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (arguments[0].isNull()) {
                return BooleanNode.FALSE;
            }
            String string = NodeUtils.toString(arguments[0], false);
            String regexp = NodeUtils.toString(arguments[1], true);
            if (regexp == null) {
                throw new JsltException("test() can't test null regexp");
            }
            Pattern p = BuiltinFunctions.getRegexp(regexp);
            Matcher m = p.matcher(string);
            return NodeUtils.toJson(m.find(0));
        }
    }

    public static class HashInt
    extends AbstractFunction {
        private static ObjectMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true)).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true)).build();
        private static ObjectWriter writer = mapper.writer();

        public HashInt() {
            super("hash-int", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode node = arguments[0];
            if (node.isNull()) {
                return NullNode.instance;
            }
            try {
                Object obj = mapper.treeToValue((TreeNode)node, Object.class);
                String jsonString = writer.writeValueAsString(obj);
                return new IntNode(jsonString.hashCode());
            }
            catch (JsonProcessingException e) {
                throw new JsltException("hash-int: can't process json" + e);
            }
        }
    }

    public static class Modulo
    extends AbstractFunction {
        public Modulo() {
            super("modulo", 2, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode dividend = arguments[0];
            if (dividend.isNull()) {
                return NullNode.instance;
            }
            if (!dividend.isNumber()) {
                throw new JsltException("mod(): dividend cannot be a non-number: " + dividend);
            }
            JsonNode divisor = arguments[1];
            if (divisor.isNull()) {
                return NullNode.instance;
            }
            if (!divisor.isNumber()) {
                throw new JsltException("mod(): divisor cannot be a non-number: " + divisor);
            }
            if (!dividend.isIntegralNumber() || !divisor.isIntegralNumber()) {
                throw new JsltException("mod(): operands must be integral types");
            }
            long D = dividend.longValue();
            long d = divisor.longValue();
            if (d == 0L) {
                throw new JsltException("mod(): cannot divide by zero");
            }
            long r = D % d;
            if (r < 0L) {
                r = d > 0L ? (r += d) : (r -= d);
            }
            return new LongNode(r);
        }
    }

    public static class Sum
    extends AbstractFunction {
        public Sum() {
            super("sum", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode array = arguments[0];
            if (array.isNull()) {
                return NullNode.instance;
            }
            if (!array.isArray()) {
                throw new JsltException("sum(): argument must be array, was " + array);
            }
            double sum = 0.0;
            boolean integral = true;
            for (int ix = 0; ix < array.size(); ++ix) {
                JsonNode value = array.get(ix);
                if (!value.isNumber()) {
                    throw new JsltException("sum(): array must contain numbers, found " + value);
                }
                integral &= value.isIntegralNumber();
                sum += value.doubleValue();
            }
            if (integral) {
                return new LongNode((long)sum);
            }
            return new DoubleNode(sum);
        }
    }

    public static class Random
    extends AbstractFunction {
        private static java.util.Random random = new java.util.Random();

        public Random() {
            super("random", 0, 0);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            return new DoubleNode(random.nextDouble());
        }
    }

    public static class Ceiling
    extends AbstractFunction {
        public Ceiling() {
            super("ceiling", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode number = arguments[0];
            if (number.isNull()) {
                return NullNode.instance;
            }
            if (!number.isNumber()) {
                throw new JsltException("ceiling() cannot round a non-number: " + number);
            }
            return new LongNode((long)Math.ceil(number.doubleValue()));
        }
    }

    public static class Floor
    extends AbstractFunction {
        public Floor() {
            super("floor", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode number = arguments[0];
            if (number.isNull()) {
                return NullNode.instance;
            }
            if (!number.isNumber()) {
                throw new JsltException("floor() cannot round a non-number: " + number);
            }
            return new LongNode((long)Math.floor(number.doubleValue()));
        }
    }

    public static class Round
    extends AbstractFunction {
        public Round() {
            super("round", 1, 1);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            JsonNode number = arguments[0];
            if (number.isNull()) {
                return NullNode.instance;
            }
            if (!number.isNumber()) {
                throw new JsltException("round() cannot round a non-number: " + number);
            }
            return new LongNode(Math.round(number.doubleValue()));
        }
    }

    public static class Number
    extends AbstractFunction {
        public Number() {
            super("number", 1, 2);
        }

        @Override
        public JsonNode call(JsonNode input, JsonNode[] arguments) {
            if (arguments.length == 1) {
                return NodeUtils.number(arguments[0], true, null);
            }
            return NodeUtils.number(arguments[0], false, null, arguments[1]);
        }
    }

    private static abstract class AbstractMacro
    extends AbstractCallable
    implements Macro {
        public AbstractMacro(String name, int min, int max) {
            super(name, min, max);
        }
    }
}

