/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.jasminb.jsonapi.ConverterConfiguration;
import com.github.jasminb.jsonapi.DeserializationFeature;
import com.github.jasminb.jsonapi.JSONAPIDocument;
import com.github.jasminb.jsonapi.JsonApi;
import com.github.jasminb.jsonapi.Link;
import com.github.jasminb.jsonapi.Links;
import com.github.jasminb.jsonapi.ReflectionUtils;
import com.github.jasminb.jsonapi.RelationshipResolver;
import com.github.jasminb.jsonapi.ResourceCache;
import com.github.jasminb.jsonapi.ResourceIdHandler;
import com.github.jasminb.jsonapi.SerializationFeature;
import com.github.jasminb.jsonapi.SerializationSettings;
import com.github.jasminb.jsonapi.ValidationUtils;
import com.github.jasminb.jsonapi.annotations.Relationship;
import com.github.jasminb.jsonapi.annotations.Type;
import com.github.jasminb.jsonapi.exceptions.DocumentSerializationException;
import com.github.jasminb.jsonapi.exceptions.UnregisteredTypeException;
import com.github.jasminb.jsonapi.models.errors.Error;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourceConverter {
    private final ConverterConfiguration configuration;
    private final ObjectMapper objectMapper;
    private final PropertyNamingStrategy namingStrategy;
    private final Map<Class<?>, RelationshipResolver> typedResolvers = new HashMap();
    private final ResourceCache resourceCache;
    private final Set<DeserializationFeature> deserializationFeatures = DeserializationFeature.getDefaultFeatures();
    private final Set<SerializationFeature> serializationFeatures = SerializationFeature.getDefaultFeatures();
    private RelationshipResolver globalResolver;
    private String baseURL;

    public ResourceConverter(Class<?> ... classes) {
        this((ObjectMapper)null, (String)null, classes);
    }

    public ResourceConverter(String baseURL, Class<?> ... classes) {
        this(null, baseURL, classes);
    }

    public ResourceConverter(ObjectMapper mapper, Class<?> ... classes) {
        this(mapper, (String)null, classes);
    }

    public ResourceConverter(ObjectMapper mapper, String baseURL, Class<?> ... classes) {
        this.configuration = new ConverterConfiguration(classes);
        String string = this.baseURL = baseURL != null ? baseURL : "";
        if (mapper != null) {
            this.objectMapper = mapper;
        } else {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        this.namingStrategy = this.objectMapper.getPropertyNamingStrategy() != null ? this.objectMapper.getPropertyNamingStrategy() : new PropertyNamingStrategy();
        this.resourceCache = new ResourceCache();
    }

    public void setGlobalResolver(RelationshipResolver resolver) {
        this.globalResolver = resolver;
    }

    public void setTypeResolver(RelationshipResolver resolver, Class<?> type) {
        String typeName;
        if (resolver != null && (typeName = ReflectionUtils.getTypeName(type)) != null) {
            this.typedResolvers.put(type, resolver);
        }
    }

    @Deprecated
    public <T> T readObject(byte[] data, Class<T> clazz) {
        return this.readDocument(data, clazz).get();
    }

    @Deprecated
    public <T> List<T> readObjectCollection(byte[] data, Class<T> clazz) {
        return this.readDocumentCollection(data, clazz).get();
    }

    public <T> JSONAPIDocument<T> readDocument(byte[] data, Class<T> clazz) {
        return this.readDocument(new ByteArrayInputStream(data), clazz);
    }

    public <T> JSONAPIDocument<T> readDocument(InputStream dataStream, Class<T> clazz) {
        try {
            this.resourceCache.init();
            JsonNode rootNode = this.objectMapper.readTree(dataStream);
            ValidationUtils.ensureValidDocument(this.objectMapper, rootNode);
            JsonNode dataNode = rootNode.get("data");
            ValidationUtils.ensurePrimaryDataValidObjectOrNull(dataNode);
            Object resourceObject = null;
            boolean cached = false;
            if (ValidationUtils.isNotNullNode(dataNode)) {
                String identifier = this.createIdentifier(dataNode);
                cached = this.resourceCache.contains(identifier);
                resourceObject = cached ? this.resourceCache.get(identifier) : this.readObject(dataNode, clazz, false);
            }
            this.resourceCache.cache(this.parseIncluded(rootNode));
            if (resourceObject != null && !cached) {
                this.handleRelationships(dataNode, resourceObject);
            }
            JSONAPIDocument<Object> result = new JSONAPIDocument<Object>(resourceObject, rootNode, this.objectMapper);
            if (rootNode.has("meta")) {
                result.setMeta(this.mapMeta(rootNode.get("meta")));
            }
            if (rootNode.has("links")) {
                result.setLinks(new Links(this.mapLinks(rootNode.get("links"))));
            }
            if (rootNode.has("jsonapi")) {
                result.setJsonApi(this.objectMapper.treeToValue((TreeNode)rootNode.get("jsonapi"), JsonApi.class));
            }
            JSONAPIDocument<Object> jSONAPIDocument = result;
            return jSONAPIDocument;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.resourceCache.clear();
        }
    }

    public <T> JSONAPIDocument<List<T>> readDocumentCollection(byte[] data, Class<T> clazz) {
        return this.readDocumentCollection(new ByteArrayInputStream(data), clazz);
    }

    public <T> JSONAPIDocument<List<T>> readDocumentCollection(InputStream dataStream, Class<T> clazz) {
        try {
            this.resourceCache.init();
            JsonNode rootNode = this.objectMapper.readTree(dataStream);
            ValidationUtils.ensureValidDocument(this.objectMapper, rootNode);
            JsonNode dataNode = rootNode.get("data");
            ValidationUtils.ensurePrimaryDataValidArray(dataNode);
            ArrayList<T> resourceList = new ArrayList<T>();
            for (JsonNode element : dataNode) {
                T pojo = this.readObject(element, clazz, false);
                resourceList.add(pojo);
            }
            this.resourceCache.cache(this.parseIncluded(rootNode));
            for (int i = 0; i < resourceList.size(); ++i) {
                JsonNode source = dataNode.get(i);
                Object resourceObject = resourceList.get(i);
                this.handleRelationships(source, resourceObject);
            }
            JSONAPIDocument<List<T>> result = new JSONAPIDocument<List<T>>(resourceList, rootNode, this.objectMapper);
            if (rootNode.has("meta")) {
                result.setMeta(this.mapMeta(rootNode.get("meta")));
            }
            if (rootNode.has("links")) {
                result.setLinks(new Links(this.mapLinks(rootNode.get("links"))));
            }
            if (rootNode.has("jsonapi")) {
                result.setJsonApi(this.objectMapper.treeToValue((TreeNode)rootNode.get("jsonapi"), JsonApi.class));
            }
            JSONAPIDocument<List<T>> jSONAPIDocument = result;
            return jSONAPIDocument;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.resourceCache.clear();
        }
    }

    private <T> T readObject(JsonNode source, Class<T> clazz, boolean handleRelationships) throws IOException, IllegalAccessException, InstantiationException {
        String identifier = this.createIdentifier(source);
        Object result = this.resourceCache.get(identifier);
        if (result == null) {
            Field linkField;
            Field field;
            Class<?> type = this.getActualType(source, clazz);
            result = source.has("attributes") ? this.objectMapper.treeToValue((TreeNode)source.get("attributes"), type) : (type.isInterface() ? null : this.objectMapper.treeToValue((TreeNode)this.objectMapper.createObjectNode(), type));
            if (source.has("meta") && (field = this.configuration.getMetaField(type)) != null) {
                Class<?> metaType = this.configuration.getMetaType(type);
                Object metaObject = this.objectMapper.treeToValue((TreeNode)source.get("meta"), metaType);
                field.set(result, metaObject);
            }
            if (source.has("links") && (linkField = this.configuration.getLinksField(type)) != null) {
                linkField.set(result, new Links(this.mapLinks(source.get("links"))));
            }
            if (result != null) {
                this.resourceCache.cache(identifier, result);
                this.setIdValue(result, source.get("id"));
                this.setLocalIdValue(result, source.get("lid"));
                if (handleRelationships) {
                    this.handleRelationships(source, result);
                }
            }
        }
        return (T)result;
    }

    private Map<String, Object> parseIncluded(JsonNode parent) throws IOException, IllegalAccessException, InstantiationException {
        Map<String, Object> includedResources;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (parent.has("included") && !(includedResources = this.getIncludedResources(parent)).isEmpty()) {
            for (String identifier : includedResources.keySet()) {
                result.put(identifier, includedResources.get(identifier));
            }
            ArrayNode includedArray = (ArrayNode)parent.get("included");
            for (int i = 0; i < includedArray.size(); ++i) {
                JsonNode node = includedArray.get(i);
                Object resourceObject = includedResources.get(this.createIdentifier(node));
                if (resourceObject == null) continue;
                this.handleRelationships(node, resourceObject);
            }
        }
        return result;
    }

    private Map<String, Object> getIncludedResources(JsonNode parent) throws IOException, IllegalAccessException, InstantiationException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JsonNode included = parent.get("included");
        ValidationUtils.ensureValidResourceObjectArray(included);
        for (JsonNode jsonNode : included) {
            String type = jsonNode.get("type").asText();
            Class<?> clazz = this.configuration.getTypeClass(type);
            if (clazz != null) {
                Object object = this.readObject(jsonNode, clazz, false);
                if (object == null) continue;
                result.put(this.createIdentifier(jsonNode), object);
                continue;
            }
            if (this.deserializationFeatures.contains((Object)DeserializationFeature.ALLOW_UNKNOWN_INCLUSIONS)) continue;
            throw new IllegalArgumentException("Included section contains unknown resource type: " + type);
        }
        return result;
    }

    private void handleRelationships(JsonNode source, Object object) throws IllegalAccessException, IOException, InstantiationException {
        JsonNode relationships = source.get("relationships");
        if (relationships != null) {
            Iterator<String> fields = relationships.fieldNames();
            while (fields.hasNext()) {
                Field relationshipLinksField;
                Field relationshipMetaField;
                Class<?> type;
                String field = fields.next();
                JsonNode relationship = relationships.get(field);
                Field relationshipField = this.configuration.getRelationshipField(object.getClass(), field);
                if (relationshipField == null || (type = this.configuration.getRelationshipType(object.getClass(), field)) == null) continue;
                if (relationship.has("meta") && (relationshipMetaField = this.configuration.getRelationshipMetaField(object.getClass(), field)) != null) {
                    relationshipMetaField.set(object, this.objectMapper.treeToValue((TreeNode)relationship.get("meta"), this.configuration.getRelationshipMetaType(object.getClass(), field)));
                }
                if (relationship.has("links") && (relationshipLinksField = this.configuration.getRelationshipLinksField(object.getClass(), field)) != null) {
                    Links links = new Links(this.mapLinks(relationship.get("links")));
                    relationshipLinksField.set(object, links);
                }
                boolean resolveRelationship = this.configuration.getFieldRelationship(relationshipField).resolve();
                RelationshipResolver resolver = this.getResolver(type);
                if (resolveRelationship && resolver != null && relationship.has("links")) {
                    String link;
                    String relType = this.configuration.getFieldRelationship(relationshipField).relType().getRelName();
                    JsonNode linkNode = relationship.get("links").get(relType);
                    if (linkNode == null || (link = this.getLink(linkNode)) == null) continue;
                    if (this.isCollection(relationship)) {
                        relationshipField.set(object, this.readDocumentCollection(new ByteArrayInputStream(resolver.resolve(link)), type).get());
                        continue;
                    }
                    relationshipField.set(object, this.readDocument(new ByteArrayInputStream(resolver.resolve(link)), type).get());
                    continue;
                }
                if (this.isCollection(relationship)) {
                    Collection<?> elements = this.createCollectionInstance(relationshipField.getType());
                    for (JsonNode element : relationship.get("data")) {
                        try {
                            Object relationshipObject = this.parseRelationship(element, type);
                            if (relationshipObject == null) continue;
                            elements.add(relationshipObject);
                        }
                        catch (UnregisteredTypeException ex) {
                            if (!relationshipField.getType().isInterface() || this.deserializationFeatures.contains((Object)DeserializationFeature.ALLOW_UNKNOWN_TYPE_IN_RELATIONSHIP)) continue;
                            throw ex;
                        }
                    }
                    relationshipField.set(object, elements);
                    continue;
                }
                try {
                    Object relationshipObject = this.parseRelationship(relationship.get("data"), type);
                    if (relationshipObject == null) continue;
                    relationshipField.set(object, relationshipObject);
                }
                catch (UnregisteredTypeException ex) {
                    if (!relationshipField.getType().isInterface() || this.deserializationFeatures.contains((Object)DeserializationFeature.ALLOW_UNKNOWN_TYPE_IN_RELATIONSHIP)) continue;
                    throw ex;
                }
            }
        }
    }

    String getLink(JsonNode linkNode) {
        if (linkNode.has("href")) {
            return linkNode.get("href").asText();
        }
        return linkNode.asText(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseRelationship(JsonNode relationshipDataNode, Class<?> type) throws IOException, IllegalAccessException, InstantiationException {
        if (ValidationUtils.isResourceIdentifierObject(relationshipDataNode)) {
            String identifier = this.createIdentifier(relationshipDataNode);
            if (this.resourceCache.contains(identifier)) {
                return this.resourceCache.get(identifier);
            }
            this.resourceCache.lock();
            try {
                Object obj = this.readObject(relationshipDataNode, type, true);
                return obj;
            }
            finally {
                this.resourceCache.unlock();
            }
        }
        return null;
    }

    private String createIdentifier(JsonNode object) throws IllegalArgumentException {
        String type;
        String lid;
        JsonNode idNode = object.get("id");
        JsonNode lidNode = object.get("lid");
        String id = idNode != null ? idNode.asText().trim() : "";
        String string = lid = lidNode != null ? lidNode.asText().trim() : "";
        if (id.isEmpty() && this.deserializationFeatures.contains((Object)DeserializationFeature.REQUIRE_RESOURCE_ID)) {
            throw new IllegalArgumentException(String.format("Resource must have a non null and non-empty 'id' attribute! %s", object));
        }
        if (lid.isEmpty() && this.deserializationFeatures.contains((Object)DeserializationFeature.REQUIRE_LOCAL_RESOURCE_ID)) {
            throw new IllegalArgumentException(String.format("Resource must have a non null and non-empty 'lid' attribute! %s", object));
        }
        if (!id.isEmpty() && !lid.isEmpty()) {
            throw new IllegalArgumentException(String.format("Resource must not have both 'id' and 'lid' attributes! %s", object));
        }
        JsonNode typeNode = object.get("type");
        String string2 = type = typeNode != null ? typeNode.asText().trim() : "";
        if (type.isEmpty()) {
            throw new IllegalArgumentException(String.format("Resource must have a non null and non-empty 'type' attribute! %s", object));
        }
        if (id.isEmpty()) {
            return type.concat(lid);
        }
        return type.concat(id);
    }

    private void setIdValue(Object target, JsonNode idValue) throws IllegalAccessException {
        Field idField = this.configuration.getIdField(target.getClass());
        ResourceIdHandler idHandler = this.configuration.getIdHandler(target.getClass());
        if (idValue != null) {
            idField.set(target, idHandler.fromString(idValue.asText()));
        }
    }

    private void setLocalIdValue(Object target, JsonNode localIdNode) throws IllegalAccessException {
        Field idField = this.configuration.getLocalIdField(target.getClass());
        ResourceIdHandler idHandler = this.configuration.getLocalIdHandler(target.getClass());
        if (localIdNode != null) {
            idField.set(target, idHandler.fromString(localIdNode.asText()));
        }
    }

    private String getIdValue(Object source) throws IllegalAccessException {
        Field idField = this.configuration.getIdField(source.getClass());
        ResourceIdHandler handler = this.configuration.getIdHandler(source.getClass());
        return handler.asString(idField.get(source));
    }

    private String getLocalIdValue(Object source) throws IllegalAccessException {
        Field localIdField = this.configuration.getLocalIdField(source.getClass());
        if (localIdField != null) {
            ResourceIdHandler handler = this.configuration.getLocalIdHandler(source.getClass());
            return handler.asString(localIdField.get(source));
        }
        return null;
    }

    private boolean isCollection(JsonNode source) {
        JsonNode data = source.get("data");
        return data != null && data.isArray();
    }

    @Deprecated
    public byte[] writeObject(Object object) throws JsonProcessingException, IllegalAccessException {
        try {
            return this.writeDocument(new JSONAPIDocument<Object>(object));
        }
        catch (DocumentSerializationException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] writeDocument(JSONAPIDocument<?> document) throws DocumentSerializationException {
        return this.writeDocument(document, null);
    }

    public byte[] writeDocument(JSONAPIDocument<?> document, SerializationSettings settings) throws DocumentSerializationException {
        try {
            this.resourceCache.init();
            HashMap<String, ObjectNode> includedDataMap = new HashMap<String, ObjectNode>();
            ObjectNode result = this.objectMapper.createObjectNode();
            if (document.get() != null) {
                ObjectNode dataNode = this.getDataNode(document.get(), includedDataMap, settings);
                result.set("data", dataNode);
                String identifier = String.valueOf(this.getIdValue(document.get())).concat(this.configuration.getTypeName(document.get().getClass()));
                includedDataMap.remove(identifier);
                result = this.addIncludedSection(result, includedDataMap, settings);
            }
            if (document.getErrors() != null) {
                ArrayNode errorsNode = this.objectMapper.createArrayNode();
                for (Error error : document.getErrors()) {
                    errorsNode.add((JsonNode)this.objectMapper.valueToTree(error));
                }
                result.set("errors", errorsNode);
            }
            this.serializeMeta(document, result, settings);
            this.serializeLinks(document, result, settings);
            this.serializeJSONAPIObject(document, result, settings);
            byte[] byArray = this.objectMapper.writeValueAsBytes(result);
            return byArray;
        }
        catch (Exception e) {
            throw new DocumentSerializationException(e);
        }
        finally {
            this.resourceCache.clear();
        }
    }

    private void serializeMeta(JSONAPIDocument<?> document, ObjectNode resultNode, SerializationSettings settings) {
        if (document.getMeta() != null && !document.getMeta().isEmpty() && this.shouldSerializeMeta(settings)) {
            resultNode.set("meta", (JsonNode)this.objectMapper.valueToTree(document.getMeta()));
        }
    }

    private void serializeLinks(JSONAPIDocument<?> document, ObjectNode resultNode, SerializationSettings settings) {
        if (document.getLinks() != null && !document.getLinks().getLinks().isEmpty() && this.shouldSerializeLinks(settings)) {
            resultNode.set("links", ((JsonNode)this.objectMapper.valueToTree(document.getLinks())).get("links"));
        }
    }

    private void serializeJSONAPIObject(JSONAPIDocument<?> document, ObjectNode resultNode, SerializationSettings settings) {
        if (document.getJsonApi() != null && this.shouldSerializeJSONAPIObject(settings)) {
            resultNode.set("jsonapi", (JsonNode)this.objectMapper.valueToTree(document.getJsonApi()));
        }
    }

    public byte[] writeDocumentCollection(JSONAPIDocument<? extends Iterable<?>> documentCollection) throws DocumentSerializationException {
        return this.writeDocumentCollection(documentCollection, null);
    }

    public byte[] writeDocumentCollection(JSONAPIDocument<? extends Iterable<?>> documentCollection, SerializationSettings serializationSettings) throws DocumentSerializationException {
        try {
            this.resourceCache.init();
            ArrayNode results = this.objectMapper.createArrayNode();
            LinkedHashMap<String, ObjectNode> includedDataMap = new LinkedHashMap<String, ObjectNode>();
            for (Object object : documentCollection.get()) {
                results.add(this.getDataNode(object, includedDataMap, serializationSettings));
            }
            ObjectNode result = this.objectMapper.createObjectNode();
            result.set("data", results);
            this.serializeMeta(documentCollection, result, serializationSettings);
            this.serializeLinks(documentCollection, result, serializationSettings);
            this.serializeJSONAPIObject(documentCollection, result, serializationSettings);
            result = this.addIncludedSection(result, includedDataMap, serializationSettings);
            byte[] byArray = this.objectMapper.writeValueAsBytes(result);
            return byArray;
        }
        catch (Exception e) {
            throw new DocumentSerializationException(e);
        }
        finally {
            this.resourceCache.clear();
        }
    }

    private ObjectNode getDataNode(Object object, Map<String, ObjectNode> includedContainer, SerializationSettings settings) throws IllegalAccessException {
        ObjectNode dataNode = this.objectMapper.createObjectNode();
        ObjectNode attributesNode = (ObjectNode)this.objectMapper.valueToTree(object);
        String resourceId = this.getIdValue(object);
        String localId = this.getLocalIdValue(object);
        this.removeField(attributesNode, this.configuration.getIdField(object.getClass()));
        this.removeField(attributesNode, this.configuration.getLocalIdField(object.getClass()));
        Field metaField = this.configuration.getMetaField(object.getClass());
        JsonNode meta = null;
        if (metaField != null) {
            meta = this.removeField(attributesNode, metaField);
        }
        String selfHref = null;
        JsonNode jsonLinks = this.getResourceLinks(object, attributesNode, resourceId, settings);
        if (jsonLinks != null && jsonLinks.has("self")) {
            JsonNode selfLink = jsonLinks.get("self");
            selfHref = selfLink instanceof TextNode ? selfLink.textValue() : selfLink.get("href").asText();
        }
        dataNode.put("type", this.configuration.getTypeName(object.getClass()));
        if (resourceId != null) {
            if (this.shouldSerializeId(settings)) {
                dataNode.put("id", resourceId);
            }
            this.resourceCache.cache(resourceId.concat(this.configuration.getTypeName(object.getClass())), null);
        }
        if (localId != null) {
            if (this.shouldSerializeLocalId(settings)) {
                dataNode.put("lid", localId);
            }
            if (resourceId == null) {
                this.resourceCache.cache(localId.concat(this.configuration.getTypeName(object.getClass())), null);
            }
        }
        dataNode.set("attributes", attributesNode);
        List<Field> relationshipFields = this.configuration.getRelationshipFields(object.getClass());
        if (relationshipFields != null) {
            ObjectNode relationshipsNode = this.objectMapper.createObjectNode();
            for (Field relationshipField : relationshipFields) {
                String identifier;
                boolean shouldSerializeData;
                JsonNode relationshipLinks;
                Relationship relationship;
                Object relationshipObject = relationshipField.get(object);
                this.removeField(attributesNode, relationshipField);
                if (relationshipObject == null || !(relationship = this.configuration.getFieldRelationship(relationshipField)).serialise()) continue;
                String relationshipName = relationship.value();
                ObjectNode relationshipDataNode = this.objectMapper.createObjectNode();
                relationshipsNode.set(relationshipName, relationshipDataNode);
                JsonNode relationshipMeta = this.getRelationshipMeta(object, relationshipName, settings);
                if (relationshipMeta != null) {
                    relationshipDataNode.set("meta", relationshipMeta);
                    Field refField = this.configuration.getRelationshipMetaField(object.getClass(), relationshipName);
                    this.removeField(attributesNode, refField);
                }
                if ((relationshipLinks = this.getRelationshipLinks(object, relationship, selfHref, settings)) != null) {
                    relationshipDataNode.set("links", relationshipLinks);
                    Field refField = this.configuration.getRelationshipLinksField(object.getClass(), relationshipName);
                    this.removeField(attributesNode, refField);
                }
                if (!(shouldSerializeData = this.configuration.getFieldRelationship(relationshipField).serialiseData())) continue;
                if (relationshipObject instanceof Collection) {
                    ArrayNode dataArrayNode = this.objectMapper.createArrayNode();
                    for (Object element : (Collection)relationshipObject) {
                        String identifier2;
                        String relationshipType = this.configuration.getTypeName(element.getClass());
                        String idValue = this.getIdValue(element);
                        String localIdValue = this.getLocalIdValue(element);
                        ObjectNode identifierNode = this.objectMapper.createObjectNode();
                        identifierNode.put("type", relationshipType);
                        if (idValue != null) {
                            identifierNode.put("id", idValue);
                        } else if (localIdValue != null) {
                            identifierNode.put("lid", localIdValue);
                        }
                        dataArrayNode.add(identifierNode);
                        if (!this.shouldSerializeRelationship(relationshipName, settings) || idValue == null && localIdValue == null || includedContainer.containsKey(identifier2 = this.createIdentifier(idValue, localIdValue, relationshipType)) || this.resourceCache.contains(identifier2)) continue;
                        includedContainer.put(identifier2, this.getDataNode(element, includedContainer, settings));
                    }
                    relationshipDataNode.set("data", dataArrayNode);
                    continue;
                }
                String relationshipType = this.configuration.getTypeName(relationshipObject.getClass());
                String idValue = this.getIdValue(relationshipObject);
                String localIdValue = this.getLocalIdValue(relationshipObject);
                ObjectNode identifierNode = this.objectMapper.createObjectNode();
                identifierNode.put("type", relationshipType);
                if (idValue != null) {
                    identifierNode.put("id", idValue);
                } else if (localIdValue != null) {
                    identifierNode.put("lid", localIdValue);
                }
                relationshipDataNode.set("data", identifierNode);
                if (!this.shouldSerializeRelationship(relationshipName, settings) || idValue == null && localIdValue == null || includedContainer.containsKey(identifier = this.createIdentifier(idValue, localIdValue, relationshipType))) continue;
                includedContainer.put(identifier, this.getDataNode(relationshipObject, includedContainer, settings));
            }
            if (!relationshipsNode.isEmpty()) {
                dataNode.set("relationships", relationshipsNode);
            }
        }
        if (jsonLinks != null) {
            dataNode.set("links", jsonLinks);
        }
        if (meta != null && this.shouldSerializeMeta(settings)) {
            dataNode.set("meta", meta);
        }
        return dataNode;
    }

    @Deprecated
    public <T> byte[] writeObjectCollection(Iterable<T> objects) throws JsonProcessingException, IllegalAccessException {
        try {
            return this.writeDocumentCollection(new JSONAPIDocument<Iterable<T>>(objects));
        }
        catch (DocumentSerializationException e) {
            if (e.getCause() instanceof JsonProcessingException) {
                throw (JsonProcessingException)e.getCause();
            }
            if (e.getCause() instanceof IllegalAccessException) {
                throw (IllegalAccessException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public boolean isRegisteredType(Class<?> type) {
        return this.configuration.isRegisteredType(type);
    }

    private String createIdentifier(String id, String localId, String type) {
        if (id != null) {
            return id.concat(type);
        }
        if (localId != null) {
            return localId.concat(type);
        }
        throw new IllegalArgumentException("Relationship object must have either an id or lid!");
    }

    private RelationshipResolver getResolver(Class<?> type) {
        RelationshipResolver resolver = this.typedResolvers.get(type);
        return resolver != null ? resolver : this.globalResolver;
    }

    private Map<String, Link> mapLinks(JsonNode linksObject) {
        HashMap<String, Link> result = new HashMap<String, Link>();
        Iterator<Map.Entry<String, JsonNode>> linkItr = linksObject.fields();
        while (linkItr.hasNext()) {
            Map.Entry<String, JsonNode> linkNode = linkItr.next();
            Link linkObj = new Link();
            linkObj.setHref(this.getLink(linkNode.getValue()));
            if (linkNode.getValue().has("meta")) {
                linkObj.setMeta(this.mapMeta(linkNode.getValue().get("meta")));
            }
            result.put(linkNode.getKey(), linkObj);
        }
        return result;
    }

    private Map<String, Object> mapMeta(JsonNode metaNode) {
        JsonParser p = this.objectMapper.treeAsTokens(metaNode);
        MapType mapType = TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, Object.class);
        try {
            return (Map)this.objectMapper.readValue(p, (JavaType)mapType);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private ObjectNode addIncludedSection(ObjectNode rootNode, Map<String, ObjectNode> includedDataMap, SerializationSettings serializationSettings) {
        boolean inclusionsEnabled = this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_RELATIONSHIP_ATTRIBUTES);
        if (serializationSettings != null) {
            inclusionsEnabled = serializationSettings.hasIncludedRelationships();
        }
        if (!includedDataMap.isEmpty() || inclusionsEnabled) {
            ArrayNode includedArray = this.objectMapper.createArrayNode();
            includedArray.addAll(includedDataMap.values());
            rootNode.set("included", includedArray);
        }
        return rootNode;
    }

    private Class<?> getActualType(JsonNode object, Class<?> userType) {
        String type = object.get("type").asText();
        String definedTypeName = this.configuration.getTypeName(userType);
        if (definedTypeName != null && definedTypeName.equals(type)) {
            return userType;
        }
        Class<?> actualType = this.configuration.getTypeClass(type);
        if (actualType != null && userType.isAssignableFrom(actualType)) {
            return actualType;
        }
        throw new UnregisteredTypeException(type);
    }

    private Collection<?> createCollectionInstance(Class<?> type) throws InstantiationException, IllegalAccessException {
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            return (Collection)type.newInstance();
        }
        if (List.class.equals(type) || Collection.class.equals(type)) {
            return new ArrayList();
        }
        if (Set.class.equals(type)) {
            return new HashSet();
        }
        throw new RuntimeException("Unable to create appropriate instance for type: " + type.getSimpleName());
    }

    private JsonNode getRelationshipMeta(Object source, String relationshipName, SerializationSettings settings) throws IllegalAccessException {
        Field relationshipMetaField;
        if (this.shouldSerializeMeta(settings) && (relationshipMetaField = this.configuration.getRelationshipMetaField(source.getClass(), relationshipName)) != null && relationshipMetaField.get(source) != null) {
            return this.objectMapper.valueToTree(relationshipMetaField.get(source));
        }
        return null;
    }

    private JsonNode getResourceLinks(Object resource, ObjectNode serializedResource, String resourceId, SerializationSettings settings) throws IllegalAccessException {
        Type type = this.configuration.getType(resource.getClass());
        Links links = null;
        Field linksField = this.configuration.getLinksField(resource.getClass());
        if (linksField != null && (links = (Links)linksField.get(resource)) != null) {
            this.removeField(serializedResource, linksField);
        }
        if (this.shouldSerializeLinks(settings)) {
            HashMap<String, Link> linkMap = new HashMap<String, Link>();
            if (links != null) {
                linkMap.putAll(links.getLinks());
            }
            if (!type.path().trim().isEmpty() && !linkMap.containsKey("self") && resourceId != null) {
                linkMap.put("self", new Link(this.createURL(this.baseURL, type.path().replace("{id}", resourceId))));
            }
            if (!linkMap.isEmpty()) {
                return ((JsonNode)this.objectMapper.valueToTree(new Links(linkMap))).get("links");
            }
        }
        return null;
    }

    private JsonNode getRelationshipLinks(Object source, Relationship relationship, String ownerLink, SerializationSettings settings) throws IllegalAccessException {
        if (this.shouldSerializeLinks(settings)) {
            Links links = null;
            Field relationshipLinksField = this.configuration.getRelationshipLinksField(source.getClass(), relationship.value());
            if (relationshipLinksField != null) {
                links = (Links)relationshipLinksField.get(source);
            }
            HashMap<String, Link> linkMap = new HashMap<String, Link>();
            if (links != null) {
                linkMap.putAll(links.getLinks());
            }
            if (!relationship.path().trim().isEmpty() && !linkMap.containsKey("self")) {
                linkMap.put("self", new Link(this.createURL(ownerLink, relationship.path())));
            }
            if (!relationship.relatedPath().trim().isEmpty() && !linkMap.containsKey("related")) {
                linkMap.put("related", new Link(this.createURL(ownerLink, relationship.relatedPath())));
            }
            if (!linkMap.isEmpty()) {
                return ((JsonNode)this.objectMapper.valueToTree(new Links(linkMap))).get("links");
            }
        }
        return null;
    }

    private String createURL(String base, String path) {
        String result = base;
        if (!result.endsWith("/")) {
            result = result.concat("/");
        }
        result = path.startsWith("/") ? result.concat(path.substring(1)) : result.concat(path);
        return result;
    }

    private boolean shouldSerializeRelationship(String relationshipName, SerializationSettings settings) {
        if (settings != null) {
            if (settings.isRelationshipIncluded(relationshipName) && !settings.isRelationshipExcluded(relationshipName)) {
                return true;
            }
            if (settings.isRelationshipExcluded(relationshipName)) {
                return false;
            }
        }
        return this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_RELATIONSHIP_ATTRIBUTES);
    }

    private boolean shouldSerializeLinks(SerializationSettings settings) {
        if (settings != null && settings.serializeLinks() != null) {
            return settings.serializeLinks();
        }
        return this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_LINKS);
    }

    private boolean shouldSerializeMeta(SerializationSettings settings) {
        if (settings != null && settings.serializeMeta() != null) {
            return settings.serializeMeta();
        }
        return this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_META);
    }

    private boolean shouldSerializeId(SerializationSettings settings) {
        if (settings != null && settings.serializeId() != null) {
            return settings.serializeId();
        }
        return this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_ID);
    }

    private boolean shouldSerializeLocalId(SerializationSettings settings) {
        if (settings != null && settings.serializeLocalId() != null) {
            return settings.serializeLocalId();
        }
        return this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_LOCAL_ID);
    }

    private boolean shouldSerializeJSONAPIObject(SerializationSettings settings) {
        if (settings != null && settings.serializeJSONAPIObject() != null) {
            return settings.serializeJSONAPIObject();
        }
        return this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_JSONAPI_OBJECT);
    }

    private JsonNode removeField(ObjectNode node, Field field) {
        if (field != null) {
            return node.remove(this.namingStrategy.nameForField(null, null, field.getName()));
        }
        return null;
    }

    public boolean registerType(Class<?> type) {
        if (!this.configuration.isRegisteredType(type) && ConverterConfiguration.isEligibleType(type)) {
            return this.configuration.registerType(type);
        }
        return false;
    }

    public void enableDeserializationOption(DeserializationFeature option) {
        this.deserializationFeatures.add(option);
    }

    public void disableDeserializationOption(DeserializationFeature option) {
        this.deserializationFeatures.remove((Object)option);
    }

    public void enableSerializationOption(SerializationFeature option) {
        this.serializationFeatures.add(option);
    }

    public void disableSerializationOption(SerializationFeature option) {
        this.serializationFeatures.remove((Object)option);
    }
}

