/*
 * Decompiled with CFR 0.152.
 */
package com.dashjoin.jsonata;

import com.dashjoin.jsonata.Jsonata;
import com.dashjoin.jsonata.Tokenizer;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.regex.Matcher;

public class JException
extends RuntimeException {
    private static final long serialVersionUID = -3354943281127831704L;
    String error;
    int location;
    Object current;
    Object expected;
    String type;
    List<Tokenizer.Token> remaining;

    public JException(String error) {
        this(error, -1, null, null);
    }

    public JException(String error, int location) {
        this(error, location, null, null);
    }

    public JException(String error, int location, Object currentToken) {
        this(error, location, currentToken, null);
    }

    public JException(String error, int location, Object currentToken, Object expected) {
        this(null, error, location, currentToken, expected);
    }

    public JException(Throwable cause, String error, int location, Object currentToken, Object expected) {
        super(JException.msg(error, location, currentToken, expected), cause);
        this.error = error;
        this.location = location;
        this.current = currentToken;
        this.expected = expected;
    }

    public String getError() {
        return this.error;
    }

    public int getLocation() {
        return this.location;
    }

    public Object getCurrent() {
        return this.current;
    }

    public Object getExpected() {
        return this.expected;
    }

    public String getDetailedErrorMessage() {
        return JException.msg(this.error, this.location, this.current, this.expected, true);
    }

    public static String msg(String error, int location, Object arg1, Object arg2) {
        return JException.msg(error, location, arg1, arg2, false);
    }

    public static String msg(String error, int location, Object arg1, Object arg2, boolean details) {
        String message = Jsonata.errorCodes.get(error);
        if (message == null) {
            return "JSonataException " + error + (String)(details ? " {code=unknown position=" + location + " arg1=" + String.valueOf(arg1) + " arg2=" + String.valueOf(arg2) + "}" : "");
        }
        Object formatted = message;
        try {
            formatted = ((String)formatted).replaceFirst("\\{\\{\\w+\\}\\}", Matcher.quoteReplacement("\"%1$s\""));
            formatted = ((String)formatted).replaceFirst("\\{\\{\\w+\\}\\}", Matcher.quoteReplacement("\"%2$s\""));
            formatted = String.format((String)formatted, arg1, arg2);
        }
        catch (IllegalFormatException ex) {
            ex.printStackTrace();
        }
        if (details) {
            formatted = (String)formatted + " {code=" + error;
            if (location >= 0) {
                formatted = (String)formatted + " position=" + location;
            }
            formatted = (String)formatted + "}";
        }
        return formatted;
    }
}

