/*
 * Decompiled with CFR 0.152.
 */
package com.dashjoin.jsonata.json;

import com.dashjoin.jsonata.JException;
import com.dashjoin.jsonata.Utils;
import com.dashjoin.jsonata.json.JsonHandler;
import com.dashjoin.jsonata.json.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Json {
    public static Object parseJson(String json) {
        _JsonHandler handler = new _JsonHandler();
        JsonParser jp = new JsonParser(handler);
        jp.parse(json);
        return handler.getValue();
    }

    public static Object parseJson(Reader json) throws IOException {
        _JsonHandler handler = new _JsonHandler();
        JsonParser jp = new JsonParser(handler);
        jp.parse(json, 65536);
        return handler.getValue();
    }

    public static void main(String[] args) throws Throwable {
        _JsonHandler handler = new _JsonHandler();
        JsonParser jp = new JsonParser(handler);
        jp.parse("{\"a\":false}");
        System.out.println(handler.getValue());
    }

    public static class _JsonHandler
    extends JsonHandler<List<?>, Map<?, ?>> {
        protected Object value;

        @Override
        public List<?> startArray() {
            return new ArrayList();
        }

        @Override
        public Map<?, ?> startObject() {
            return new LinkedHashMap();
        }

        @Override
        public void endNull() {
            this.value = null;
        }

        @Override
        public void endBoolean(boolean bool) {
            this.value = bool;
        }

        @Override
        public void endString(String string) {
            this.value = string;
        }

        @Override
        public void endNumber(String string) {
            double d = Double.valueOf(string);
            try {
                this.value = Utils.convertNumber(d);
            }
            catch (JException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void endArray(List array) {
            this.value = array;
        }

        @Override
        public void endObject(Map object) {
            this.value = object;
        }

        @Override
        public void endArrayValue(List array) {
            array.add(this.value);
        }

        @Override
        public void endObjectValue(Map object, String name) {
            object.put(name, this.value);
        }

        public Object getValue() {
            return this.value;
        }
    }
}

