/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.FileChangedExclusiveReadLockStrategy;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIdempotentChangedRepositoryReadLockStrategy
extends ServiceSupport
implements GenericFileExclusiveReadLockStrategy<File>,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(FileIdempotentChangedRepositoryReadLockStrategy.class);
    private final FileChangedExclusiveReadLockStrategy changed;
    private GenericFileEndpoint<File> endpoint;
    private LoggingLevel readLockLoggingLevel = LoggingLevel.DEBUG;
    private CamelContext camelContext;
    private IdempotentRepository idempotentRepository;
    private boolean removeOnRollback = true;
    private boolean removeOnCommit;
    private int readLockIdempotentReleaseDelay;
    private boolean readLockIdempotentReleaseAsync;
    private int readLockIdempotentReleaseAsyncPoolSize;
    private ScheduledExecutorService readLockIdempotentReleaseExecutorService;
    private boolean shutdownExecutorService;

    public FileIdempotentChangedRepositoryReadLockStrategy() {
        this.changed = new FileChangedExclusiveReadLockStrategy();
        this.changed.setMarkerFiler(false);
        this.changed.setDeleteOrphanLockFiles(false);
    }

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) throws Exception {
        this.endpoint = endpoint;
        LOG.info("Using FileIdempotentRepositoryReadLockStrategy: {} on endpoint: {}", (Object)this.idempotentRepository, endpoint);
        this.changed.prepareOnStartup(operations, endpoint);
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        boolean answer;
        String key;
        block5: {
            File path = file.getFile();
            if (!path.exists()) {
                return false;
            }
            key = this.asKey(file);
            answer = false;
            try {
                answer = this.idempotentRepository.add(exchange, key);
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) break block5;
                LOG.trace("Cannot acquire read lock due to {}. Will skip the file: {}", new Object[]{e.getMessage(), file, e});
            }
        }
        if (!answer) {
            CamelLogger.log(LOG, this.readLockLoggingLevel, "Cannot acquire read lock. Will skip the file: " + String.valueOf(file));
        }
        if (answer && !(answer = this.changed.acquireExclusiveReadLock(operations, file, exchange))) {
            this.idempotentRepository.remove(exchange, key);
        }
        return answer;
    }

    @Override
    public void releaseExclusiveReadLockOnAbort(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        this.changed.releaseExclusiveReadLockOnAbort(operations, file, exchange);
    }

    @Override
    public void releaseExclusiveReadLockOnRollback(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        String key = this.asKey(file);
        Runnable r = () -> {
            if (this.removeOnRollback) {
                this.idempotentRepository.remove(exchange, key);
            } else {
                this.idempotentRepository.confirm(exchange, key);
            }
            try {
                this.changed.releaseExclusiveReadLockOnRollback(operations, file, exchange);
            }
            catch (Exception e) {
                LOG.warn("Error during releasing exclusive read lock on rollback. This exception is ignored.", (Throwable)e);
            }
        };
        this.delayOrScheduleLockRelease(r);
    }

    private void delayOrScheduleLockRelease(Runnable r) throws InterruptedException {
        if (this.readLockIdempotentReleaseDelay > 0 && this.readLockIdempotentReleaseExecutorService != null) {
            LOG.debug("Scheduling read lock release task to run asynchronous delayed after {} millis", (Object)this.readLockIdempotentReleaseDelay);
            this.readLockIdempotentReleaseExecutorService.schedule(r, (long)this.readLockIdempotentReleaseDelay, TimeUnit.MILLISECONDS);
        } else if (this.readLockIdempotentReleaseDelay > 0) {
            LOG.debug("Delaying read lock release task {} millis", (Object)this.readLockIdempotentReleaseDelay);
            Thread.sleep(this.readLockIdempotentReleaseDelay);
            r.run();
        } else {
            r.run();
        }
    }

    @Override
    public void releaseExclusiveReadLockOnCommit(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        String key = this.asKey(file);
        Runnable r = () -> {
            if (this.removeOnCommit) {
                this.idempotentRepository.remove(exchange, key);
            } else {
                this.idempotentRepository.confirm(exchange, key);
            }
            try {
                this.changed.releaseExclusiveReadLockOnCommit(operations, file, exchange);
            }
            catch (Exception e) {
                LOG.warn("Error during releasing exclusive read lock on rollback. This exception is ignored.", (Throwable)e);
            }
        };
        this.delayOrScheduleLockRelease(r);
    }

    @Override
    public void setTimeout(long timeout) {
        this.changed.setTimeout(timeout);
    }

    @Override
    public void setCheckInterval(long checkInterval) {
        this.changed.setCheckInterval(checkInterval);
    }

    @Override
    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
        this.changed.setReadLockLoggingLevel(readLockLoggingLevel);
    }

    @Override
    public void setMarkerFiler(boolean markerFile) {
    }

    @Override
    public void setDeleteOrphanLockFiles(boolean deleteOrphanLockFiles) {
    }

    public void setMinLength(long minLength) {
        this.changed.setMinLength(minLength);
    }

    public void setMinAge(long minAge) {
        this.changed.setMinAge(minAge);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public IdempotentRepository getIdempotentRepository() {
        return this.idempotentRepository;
    }

    public void setIdempotentRepository(IdempotentRepository idempotentRepository) {
        this.idempotentRepository = idempotentRepository;
    }

    public boolean isRemoveOnRollback() {
        return this.removeOnRollback;
    }

    public void setRemoveOnRollback(boolean removeOnRollback) {
        this.removeOnRollback = removeOnRollback;
    }

    public boolean isRemoveOnCommit() {
        return this.removeOnCommit;
    }

    public void setRemoveOnCommit(boolean removeOnCommit) {
        this.removeOnCommit = removeOnCommit;
    }

    public void setReadLockIdempotentReleaseDelay(int readLockIdempotentReleaseDelay) {
        this.readLockIdempotentReleaseDelay = readLockIdempotentReleaseDelay;
    }

    public boolean isReadLockIdempotentReleaseAsync() {
        return this.readLockIdempotentReleaseAsync;
    }

    public void setReadLockIdempotentReleaseAsync(boolean readLockIdempotentReleaseAsync) {
        this.readLockIdempotentReleaseAsync = readLockIdempotentReleaseAsync;
    }

    public int getReadLockIdempotentReleaseAsyncPoolSize() {
        return this.readLockIdempotentReleaseAsyncPoolSize;
    }

    public void setReadLockIdempotentReleaseAsyncPoolSize(int readLockIdempotentReleaseAsyncPoolSize) {
        this.readLockIdempotentReleaseAsyncPoolSize = readLockIdempotentReleaseAsyncPoolSize;
    }

    public ScheduledExecutorService getReadLockIdempotentReleaseExecutorService() {
        return this.readLockIdempotentReleaseExecutorService;
    }

    public void setReadLockIdempotentReleaseExecutorService(ScheduledExecutorService readLockIdempotentReleaseExecutorService) {
        this.readLockIdempotentReleaseExecutorService = readLockIdempotentReleaseExecutorService;
    }

    protected String asKey(GenericFile<File> file) {
        String key = file.getAbsoluteFilePath();
        if (this.endpoint.getIdempotentKey() != null) {
            Exchange dummy = this.endpoint.createExchange(file);
            key = this.endpoint.getIdempotentKey().evaluate(dummy, String.class);
        }
        return key;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "camelContext", this);
        ObjectHelper.notNull(this.idempotentRepository, "idempotentRepository", this);
        if (this.readLockIdempotentReleaseAsync && this.readLockIdempotentReleaseExecutorService == null) {
            this.readLockIdempotentReleaseExecutorService = this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, "ReadLockChangedIdempotentReleaseTask", this.readLockIdempotentReleaseAsyncPoolSize);
            this.shutdownExecutorService = true;
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.shutdownExecutorService && this.readLockIdempotentReleaseExecutorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownGraceful(this.readLockIdempotentReleaseExecutorService, 30000L);
            this.readLockIdempotentReleaseExecutorService = null;
        }
    }
}

