/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jta;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.jta.JtaTransactionPolicy;
import org.apache.camel.jta.TransactionErrorHandler;
import org.apache.camel.processor.errorhandler.RedeliveryErrorHandler;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransactionErrorHandler
extends RedeliveryErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JtaTransactionErrorHandler.class);
    private final JtaTransactionPolicy transactionPolicy;
    private final LoggingLevel rollbackLoggingLevel;

    public JtaTransactionErrorHandler(CamelContext camelContext, Processor output, CamelLogger logger, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, JtaTransactionPolicy transactionPolicy, Predicate retryWhile, ScheduledExecutorService executorService, LoggingLevel rollbackLoggingLevel, Processor onExceptionOccurredProcessor) {
        super(camelContext, new TransactionErrorHandler(camelContext, output, transactionPolicy, rollbackLoggingLevel), logger, redeliveryProcessor, redeliveryPolicy, null, null, false, false, false, retryWhile, executorService, null, onExceptionOccurredProcessor);
        this.transactionPolicy = transactionPolicy;
        this.rollbackLoggingLevel = rollbackLoggingLevel;
    }

    @Override
    public ErrorHandler clone(Processor output) {
        JtaTransactionErrorHandler answer = new JtaTransactionErrorHandler(this.camelContext, output, this.logger, this.redeliveryProcessor, this.redeliveryPolicy, this.transactionPolicy, this.retryWhilePolicy, this.executorService, this.rollbackLoggingLevel, this.onExceptionProcessor);
        if (this.exceptionPolicies != null) {
            answer.exceptionPolicies = this.exceptionPolicies;
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!exchange.isTransacted()) {
            try {
                LOG.debug("Mark {} as transacted", (Object)exchange);
                exchange.getUnitOfWork().beginTransactedBy("camel-jta");
                boolean bl = super.process(exchange, callback);
                return bl;
            }
            finally {
                exchange.getUnitOfWork().endTransactedBy("camel-jta");
            }
        }
        return super.process(exchange, callback);
    }
}

