/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.AggregationStrategyAwareDefinition;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.processor.PollEnricher;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.EndpointHelper;

public class PollEnrichReifier
extends ProcessorReifier<PollEnrichDefinition> {
    public PollEnrichReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (PollEnrichDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Integer num;
        String uri;
        Expression exp;
        if (((PollEnrichDefinition)this.definition).getExpression() instanceof ConstantExpression) {
            exp = this.createExpression(((PollEnrichDefinition)this.definition).getExpression());
            DefaultExchange ex = new DefaultExchange(this.camelContext);
            uri = exp.evaluate(ex, String.class);
        } else {
            exp = this.createExpression(((PollEnrichDefinition)this.definition).getExpression());
            uri = ((PollEnrichDefinition)this.definition).getExpression().getExpression();
        }
        RouteDefinition rd = ProcessorDefinitionHelper.getRoute(this.definition);
        if (rd != null && rd.isTemplate() != null && rd.isTemplate().booleanValue()) {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(this.camelContext, uri);
        }
        long timeout = this.parseDuration(((PollEnrichDefinition)this.definition).getTimeout(), -1L);
        PollEnricher enricher = new PollEnricher(exp, uri, timeout);
        AggregationStrategy strategy = this.getConfiguredAggregationStrategy((AggregationStrategyAwareDefinition)((Object)this.definition));
        if (strategy != null) {
            enricher.setAggregationStrategy(strategy);
        }
        if ((num = this.parseInt(((PollEnrichDefinition)this.definition).getCacheSize())) != null) {
            enricher.setCacheSize(num);
        }
        enricher.setVariableReceive(this.parseString(((PollEnrichDefinition)this.definition).getVariableReceive()));
        enricher.setIgnoreInvalidEndpoint(this.parseBoolean(((PollEnrichDefinition)this.definition).getIgnoreInvalidEndpoint(), false));
        enricher.setAggregateOnException(this.parseBoolean(((PollEnrichDefinition)this.definition).getAggregateOnException(), false));
        if (((PollEnrichDefinition)this.definition).getAutoStartComponents() != null) {
            enricher.setAutoStartupComponents(this.parseBoolean(((PollEnrichDefinition)this.definition).getAutoStartComponents(), true));
        }
        return enricher;
    }
}

