/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.errorhandler;

import org.apache.camel.component.kafka.KafkaFetchRecords;
import org.apache.camel.component.kafka.PollExceptionStrategy;
import org.apache.camel.component.kafka.consumer.errorhandler.SeekUtil;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeErrorStrategy
implements PollExceptionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(BridgeErrorStrategy.class);
    private final KafkaFetchRecords recordFetcher;
    private final Consumer<?, ?> consumer;
    private boolean continueFlag = true;

    public BridgeErrorStrategy(KafkaFetchRecords recordFetcher, Consumer<?, ?> consumer) {
        this.recordFetcher = recordFetcher;
        this.consumer = consumer;
    }

    @Override
    public boolean canContinue() {
        return this.continueFlag;
    }

    @Override
    public void handle(long partitionLastOffset, Exception exception) {
        LOG.warn("Deferring processing to the exception handler based on polling exception strategy");
        this.recordFetcher.getBridge().handleException(exception);
        SeekUtil.seekToNextOffset(this.consumer, partitionLastOffset);
        if (exception instanceof AuthenticationException || exception instanceof AuthorizationException) {
            this.continueFlag = false;
        }
    }
}

