/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

public final class ProcessingResult {
    private static final ProcessingResult UNPROCESSED_RESULT = new ProcessingResult(false, false);
    private final boolean breakOnErrorHit;
    private final boolean failed;
    private final String topic;
    private final int partition;
    private final long offset;

    public ProcessingResult(boolean breakOnErrorHit, boolean failed) {
        this(breakOnErrorHit, failed, null, 0, 0L);
    }

    public ProcessingResult(boolean breakOnErrorHit, boolean failed, String topic, int partition, long offset) {
        this.breakOnErrorHit = breakOnErrorHit;
        this.failed = failed;
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
    }

    public boolean isBreakOnErrorHit() {
        return this.breakOnErrorHit;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getOffset() {
        return this.offset;
    }

    public static ProcessingResult newUnprocessed() {
        return UNPROCESSED_RESULT;
    }
}

