/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support.batching;

import java.util.Set;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.CommitManager;
import org.apache.camel.component.kafka.consumer.errorhandler.KafkaConsumerListener;
import org.apache.camel.component.kafka.consumer.support.AbstractKafkaRecordProcessorFacade;
import org.apache.camel.component.kafka.consumer.support.ProcessingResult;
import org.apache.camel.component.kafka.consumer.support.batching.KafkaRecordBatchingProcessor;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRecordBatchingProcessorFacade
extends AbstractKafkaRecordProcessorFacade {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaRecordBatchingProcessorFacade.class);
    private final KafkaRecordBatchingProcessor kafkaRecordProcessor;

    public KafkaRecordBatchingProcessorFacade(KafkaConsumer camelKafkaConsumer, String threadId, CommitManager commitManager, KafkaConsumerListener consumerListener) {
        super(camelKafkaConsumer, threadId, commitManager, consumerListener);
        this.kafkaRecordProcessor = this.buildKafkaRecordProcessor(commitManager);
    }

    private KafkaRecordBatchingProcessor buildKafkaRecordProcessor(CommitManager commitManager) {
        return new KafkaRecordBatchingProcessor(this.camelKafkaConsumer.getEndpoint().getConfiguration(), this.camelKafkaConsumer.getProcessor(), commitManager);
    }

    @Override
    public ProcessingResult processPolledRecords(ConsumerRecords<Object, Object> allRecords) {
        this.logRecords(allRecords);
        Set<TopicPartition> partitions = allRecords.partitions();
        LOG.debug("Poll received records on {} partitions", (Object)partitions.size());
        return this.kafkaRecordProcessor.processExchange(this.camelKafkaConsumer, allRecords);
    }
}

