/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.spi.ReloadStrategy;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="context", displayName="CamelContext", description="Overall information about the CamelContext")
public class ContextDevConsole
extends AbstractDevConsole {
    public ContextDevConsole() {
        super("camel", "context", "CamelContext", "Overall information about the CamelContext");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        ManagedCamelContextMBean mb;
        StringBuilder sb = new StringBuilder();
        Object profile = "";
        if (this.getCamelContext().getCamelContextExtension().getProfile() != null) {
            profile = " (profile: " + this.getCamelContext().getCamelContextExtension().getProfile() + ")";
        }
        sb.append(String.format("Apache Camel %s %s (%s)%s uptime %s", this.getCamelContext().getVersion(), this.getCamelContext().getStatus().name().toLowerCase(Locale.ROOT), this.getCamelContext().getName(), profile, CamelContextHelper.getUptime(this.getCamelContext())));
        if (this.getCamelContext().getDescription() != null) {
            sb.append(String.format("\n    %s", this.getCamelContext().getDescription()));
        }
        sb.append("\n");
        ManagedCamelContext mcc = this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null && (mb = mcc.getManagedCamelContext()) != null) {
            String ago;
            Date last;
            String thp;
            int reloaded = 0;
            Set<ReloadStrategy> rs = this.getCamelContext().hasServices(ReloadStrategy.class);
            for (ReloadStrategy r : rs) {
                reloaded += r.getReloadCounter();
            }
            String load1 = this.getLoad1(mb);
            String load5 = this.getLoad5(mb);
            String load15 = this.getLoad15(mb);
            if (!(load1.isEmpty() && load5.isEmpty() && load15.isEmpty())) {
                sb.append(String.format("\n    Load Average: %s %s %s", load1, load5, load15));
            }
            if (!(thp = this.getThroughput(mb)).isEmpty()) {
                sb.append(String.format("\n    Messages/Sec: %s", thp));
            }
            sb.append(String.format("\n    Total: %s/%s", mb.getRemoteExchangesTotal(), mb.getExchangesTotal()));
            sb.append(String.format("\n    Failed: %s/%s", mb.getRemoteExchangesFailed(), mb.getExchangesFailed()));
            sb.append(String.format("\n    Inflight: %s/%s", mb.getRemoteExchangesInflight(), mb.getExchangesInflight()));
            long idle = mb.getIdleSince();
            if (idle > 0L) {
                sb.append(String.format("\n    Idle Since: %s", TimeUtils.printDuration(idle)));
            } else {
                sb.append(String.format("\n    Idle Since: %s", ""));
            }
            sb.append(String.format("\n    Reloaded: %s", reloaded));
            sb.append(String.format("\n    Mean Time: %s", TimeUtils.printDuration(mb.getMeanProcessingTime(), true)));
            sb.append(String.format("\n    Max Time: %s", TimeUtils.printDuration(mb.getMaxProcessingTime(), true)));
            sb.append(String.format("\n    Min Time: %s", TimeUtils.printDuration(mb.getMinProcessingTime(), true)));
            if (mb.getExchangesTotal() > 0L) {
                sb.append(String.format("\n    Last Time: %s", TimeUtils.printDuration(mb.getLastProcessingTime(), true)));
                sb.append(String.format("\n    Delta Time: %s", TimeUtils.printDuration(mb.getDeltaProcessingTime(), true)));
            }
            if ((last = mb.getLastExchangeCreatedTimestamp()) != null) {
                ago = TimeUtils.printSince(last.getTime());
                sb.append(String.format("\n    Since Last Started: %s", ago));
            }
            if ((last = mb.getLastExchangeCompletedTimestamp()) != null) {
                ago = TimeUtils.printSince(last.getTime());
                sb.append(String.format("\n    Since Last Completed: %s", ago));
            }
            if ((last = mb.getLastExchangeFailureTimestamp()) != null) {
                ago = TimeUtils.printSince(last.getTime());
                sb.append(String.format("\n    Since Last Failed: %s", ago));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        ManagedCamelContextMBean mb;
        JsonObject root = new JsonObject();
        root.put("name", this.getCamelContext().getName());
        if (this.getCamelContext().getDescription() != null) {
            root.put("description", this.getCamelContext().getDescription());
        }
        if (this.getCamelContext().getCamelContextExtension().getProfile() != null) {
            root.put("profile", this.getCamelContext().getCamelContextExtension().getProfile());
        }
        root.put("version", this.getCamelContext().getVersion());
        root.put("state", this.getCamelContext().getStatus().name());
        root.put("phase", this.getCamelContext().getCamelContextExtension().getStatusPhase());
        root.put("uptime", this.getCamelContext().getUptime().toMillis());
        ManagedCamelContext mcc = this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null && (mb = mcc.getManagedCamelContext()) != null) {
            Date last;
            String thp;
            JsonObject stats = new JsonObject();
            int reloaded = 0;
            Set<ReloadStrategy> rs = this.getCamelContext().hasServices(ReloadStrategy.class);
            for (ReloadStrategy r : rs) {
                reloaded += r.getReloadCounter();
            }
            String load1 = this.getLoad1(mb);
            String load5 = this.getLoad5(mb);
            String load15 = this.getLoad15(mb);
            if (!(load1.isEmpty() && load5.isEmpty() && load15.isEmpty())) {
                stats.put("load01", load1);
                stats.put("load05", load5);
                stats.put("load15", load15);
            }
            if (!(thp = this.getThroughput(mb)).isEmpty()) {
                stats.put("exchangesThroughput", thp);
            }
            stats.put("idleSince", mb.getIdleSince());
            stats.put("exchangesTotal", mb.getExchangesTotal());
            stats.put("exchangesFailed", mb.getExchangesFailed());
            stats.put("exchangesInflight", mb.getExchangesInflight());
            stats.put("remoteExchangesTotal", mb.getRemoteExchangesTotal());
            stats.put("remoteExchangesFailed", mb.getRemoteExchangesFailed());
            stats.put("remoteExchangesInflight", mb.getRemoteExchangesInflight());
            stats.put("reloaded", reloaded);
            stats.put("meanProcessingTime", mb.getMeanProcessingTime());
            stats.put("maxProcessingTime", mb.getMaxProcessingTime());
            stats.put("minProcessingTime", mb.getMinProcessingTime());
            if (mb.getExchangesTotal() > 0L) {
                stats.put("lastProcessingTime", mb.getLastProcessingTime());
                stats.put("deltaProcessingTime", mb.getDeltaProcessingTime());
            }
            if ((last = mb.getLastExchangeCreatedTimestamp()) != null) {
                stats.put("lastCreatedExchangeTimestamp", last.getTime());
            }
            if ((last = mb.getLastExchangeCompletedTimestamp()) != null) {
                stats.put("lastCompletedExchangeTimestamp", last.getTime());
            }
            if ((last = mb.getLastExchangeFailureTimestamp()) != null) {
                stats.put("lastFailedExchangeTimestamp", last.getTime());
            }
            root.put("statistics", stats);
        }
        return root;
    }

    private String getLoad1(ManagedCamelContextMBean mb) {
        String s = mb.getLoad01();
        s = s.replace(',', '.');
        return s;
    }

    private String getLoad5(ManagedCamelContextMBean mb) {
        String s = mb.getLoad05();
        s = s.replace(',', '.');
        return s;
    }

    private String getLoad15(ManagedCamelContextMBean mb) {
        String s = mb.getLoad15();
        s = s.replace(',', '.');
        return s;
    }

    private String getThroughput(ManagedCamelContextMBean mb) {
        String s = mb.getThroughput();
        s = s.replace(',', '.');
        return s;
    }
}

