/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.impl.console.ConsoleHelper;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="route-dump", description="Dump route in XML or YAML format")
public class RouteDumpDevConsole
extends AbstractDevConsole {
    public static final String FORMAT = "format";
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";
    public static final String URI_AS_PARAMETERS = "uriAsParameters";

    public RouteDumpDevConsole() {
        super("camel", "route-dump", "Route Dump", "Dump route in XML or YAML format");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        String uriAsParameters = (String)options.getOrDefault(URI_AS_PARAMETERS, "false");
        StringBuilder sb = new StringBuilder();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            String dump = null;
            try {
                String format = (String)options.get(FORMAT);
                if (format == null || "xml".equals(format)) {
                    dump = mrb.dumpRouteAsXml();
                } else if ("yaml".equals(format)) {
                    dump = mrb.dumpRouteAsYaml(true, "true".equals(uriAsParameters));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append(String.format("    Id: %s", mrb.getRouteId()));
            if (mrb.getSourceLocation() != null) {
                sb.append(String.format("\n    Source: %s", mrb.getSourceLocation()));
            }
            if (dump != null && !dump.isEmpty()) {
                sb.append("\n\n");
                for (String line : dump.split("\n")) {
                    sb.append("    ").append(line).append("\n");
                }
                sb.append("\n");
            }
            sb.append("\n");
            return null;
        };
        this.doCall(options, task);
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String uriAsParameters = (String)options.getOrDefault(URI_AS_PARAMETERS, "false");
        JsonObject root = new JsonObject();
        ArrayList list = new ArrayList();
        Function<ManagedRouteMBean, Object> task = mrb -> {
            JsonObject jo = new JsonObject();
            list.add(jo);
            jo.put("routeId", mrb.getRouteId());
            jo.put("from", mrb.getEndpointUri());
            if (mrb.getSourceLocation() != null) {
                jo.put("source", mrb.getSourceLocation());
            }
            try {
                List<JsonObject> code;
                String dump = null;
                String format = (String)options.get(FORMAT);
                if (format == null || "xml".equals(format)) {
                    jo.put(FORMAT, "xml");
                    dump = mrb.dumpRouteAsXml();
                } else if ("yaml".equals(format)) {
                    jo.put(FORMAT, "yaml");
                    dump = mrb.dumpRouteAsYaml(true, "true".equals(uriAsParameters));
                }
                if (dump != null && (code = ConsoleHelper.loadSourceAsJson(new StringReader(dump), null)) != null) {
                    jo.put("code", code);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        };
        this.doCall(options, task);
        root.put("routes", list);
        return root;
    }

    protected void doCall(Map<String, Object> options, Function<ManagedRouteMBean, Object> task) {
        String path = (String)options.get("CamelHttpPath");
        String subPath = path != null ? StringHelper.after(path, "/") : null;
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        ManagedCamelContext mcc = this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
        if (mcc != null) {
            List<Route> routes = this.getCamelContext().getRoutes();
            routes.sort((o1, o2) -> o1.getRouteId().compareToIgnoreCase(o2.getRouteId()));
            routes.stream().map(route -> mcc.getManagedRoute(route.getRouteId())).filter(Objects::nonNull).filter(r -> RouteDumpDevConsole.accept(r, filter)).filter(r -> RouteDumpDevConsole.accept(r, subPath)).sorted(RouteDumpDevConsole::sort).limit(max).forEach(task::apply);
        }
    }

    private static boolean accept(ManagedRouteMBean mrb, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        String onlyName = LoggerHelper.sourceNameOnly(mrb.getSourceLocation());
        return PatternHelper.matchPattern(mrb.getRouteId(), filter) || PatternHelper.matchPattern(mrb.getEndpointUri(), filter) || PatternHelper.matchPattern(mrb.getSourceLocationShort(), filter) || PatternHelper.matchPattern(onlyName, filter);
    }

    private static int sort(ManagedRouteMBean o1, ManagedRouteMBean o2) {
        return o1.getRouteId().compareTo(o2.getRouteId());
    }
}

