/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.kafka;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.util.ObjectHelper;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;

public class KafkaConsumerUtil {
    public static <K, V> boolean isReachedOffsets(Consumer<K, V> consumer, Map<TopicPartition, Long> targetOffsets) {
        if (ObjectHelper.isEmpty(targetOffsets)) {
            throw new IllegalArgumentException("Target offsets must be non-empty");
        }
        Set<TopicPartition> partitions = consumer.assignment();
        HashMap<TopicPartition, Long> extendedTargetOffsets = new HashMap<TopicPartition, Long>(targetOffsets);
        partitions.forEach(partition -> extendedTargetOffsets.putIfAbsent((TopicPartition)partition, Long.MIN_VALUE));
        return partitions.stream().allMatch(partition -> consumer.position((TopicPartition)partition) >= (Long)extendedTargetOffsets.get(partition));
    }
}

