/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DynamicRouter;
import org.apache.camel.reifier.ExpressionReifier;

public class DynamicRouterReifier
extends ExpressionReifier<DynamicRouterDefinition<?>> {
    public DynamicRouterReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (DynamicRouterDefinition)DynamicRouterDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        Integer num;
        Expression expression = this.createExpression(((DynamicRouterDefinition)this.definition).getExpression());
        String delimiter = ((DynamicRouterDefinition)this.definition).getUriDelimiter() != null ? ((DynamicRouterDefinition)this.definition).getUriDelimiter() : ",";
        DynamicRouter dynamicRouter = new DynamicRouter(this.camelContext, expression, delimiter);
        if (((DynamicRouterDefinition)this.definition).getIgnoreInvalidEndpoints() != null) {
            dynamicRouter.setIgnoreInvalidEndpoints(this.parseBoolean(((DynamicRouterDefinition)this.definition).getIgnoreInvalidEndpoints(), false));
        }
        if ((num = this.parseInt(((DynamicRouterDefinition)this.definition).getCacheSize())) != null) {
            dynamicRouter.setCacheSize(num);
        }
        AsyncProcessor errorHandler = (AsyncProcessor)this.wrapInErrorHandler(dynamicRouter.newRoutingSlipProcessorForErrorHandler());
        dynamicRouter.setErrorHandler(errorHandler);
        return dynamicRouter;
    }
}

