/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.List;
import org.apache.camel.component.kafka.KafkaConsumer;
import org.apache.camel.component.kafka.consumer.CommitManager;
import org.apache.camel.component.kafka.consumer.errorhandler.KafkaConsumerListener;
import org.apache.camel.component.kafka.consumer.support.KafkaRecordProcessorFacade;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKafkaRecordProcessorFacade
implements KafkaRecordProcessorFacade {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKafkaRecordProcessorFacade.class);
    protected final KafkaConsumer camelKafkaConsumer;
    protected final String threadId;
    protected final CommitManager commitManager;
    protected final KafkaConsumerListener consumerListener;

    protected AbstractKafkaRecordProcessorFacade(KafkaConsumer camelKafkaConsumer, String threadId, CommitManager commitManager, KafkaConsumerListener consumerListener) {
        this.camelKafkaConsumer = camelKafkaConsumer;
        this.threadId = threadId;
        this.commitManager = commitManager;
        this.consumerListener = consumerListener;
    }

    protected boolean isStopping() {
        return this.camelKafkaConsumer.isStopping();
    }

    protected void logRecordsInPartition(List<ConsumerRecord<Object, Object>> partitionRecords, TopicPartition partition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Records count {} received for partition {}", (Object)partitionRecords.size(), (Object)partition);
        }
    }

    protected void logRecords(ConsumerRecords<Object, Object> allRecords) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Last poll on thread {} resulted on {} records to process", (Object)this.threadId, (Object)allRecords.count());
        }
    }

    protected void logRecord(ConsumerRecord<Object, Object> consumerRecord) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Partition = {}, offset = {}, key = {}, value = {}", new Object[]{consumerRecord.partition(), consumerRecord.offset(), consumerRecord.key(), consumerRecord.value()});
        }
    }
}

