/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.Closeable;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

public final class ConsoleHelper {
    private ConsoleHelper() {
    }

    public static List<JsonObject> loadSourceAsJson(CamelContext camelContext, String location) {
        if (location == null) {
            return null;
        }
        Integer lineNumber = LoggerHelper.extractSourceLocationLineNumber(location);
        try {
            location = LoggerHelper.stripSourceLocationLineNumber(location);
            Resource resource = PluginHelper.getResourceLoader(camelContext).resolveResource(location);
            if (resource != null) {
                return ConsoleHelper.loadSourceAsJson(resource.getReader(), lineNumber);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.EMPTY_LIST;
    }

    public static List<JsonObject> loadSourceAsJson(Reader reader, Integer lineNumber) {
        ArrayList<JsonObject> code = new ArrayList<JsonObject>();
        try {
            String t;
            LineNumberReader lnr = new LineNumberReader(reader);
            int i = 0;
            do {
                if ((t = lnr.readLine()) == null) continue;
                JsonObject c = new JsonObject();
                c.put("line", ++i);
                c.put("code", Jsoner.escape(t));
                if (lineNumber != null && lineNumber == i) {
                    c.put("match", true);
                }
                code.add(c);
            } while (t != null);
            IOHelper.close((Closeable)lnr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code.isEmpty() ? null : code;
    }

    public static String loadSourceLine(CamelContext camelContext, String location, Integer lineNumber) {
        if (location == null || lineNumber == null) {
            return null;
        }
        try {
            location = LoggerHelper.stripSourceLocationLineNumber(location);
            Resource resource = PluginHelper.getResourceLoader(camelContext).resolveResource(location);
            if (resource != null) {
                String t;
                LineNumberReader reader = new LineNumberReader(resource.getReader());
                int i = 0;
                do {
                    if ((t = reader.readLine()) == null || ++i != lineNumber) continue;
                    return t;
                } while (t != null);
                IOHelper.close((Closeable)reader);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

