/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.spi.ReloadStrategy;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="reload", description="Console for reloading running Camel")
public class ReloadDevConsole
extends AbstractDevConsole {
    public static final String RELOAD = "reload";
    public static final String RELOAD_WAIT = "wait";
    private volatile ExecutorService reloadThread;

    public ReloadDevConsole() {
        super("camel", RELOAD, "Reload", "Console for reloading running Camel");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        boolean trigger = "true".equals(options.getOrDefault(RELOAD, "false"));
        boolean wait = "true".equals(options.getOrDefault(RELOAD_WAIT, "false"));
        StringBuilder sb = new StringBuilder();
        Set<ReloadStrategy> rs = this.getCamelContext().hasServices(ReloadStrategy.class);
        boolean failed = false;
        for (ReloadStrategy r : rs) {
            if (trigger) {
                int before = r.getFailedCounter();
                Future<?> f = this.getOrCreateReloadTask().submit(() -> r.onReload("ReloadDevConsole"));
                if (!wait) continue;
                try {
                    f.get(30L, TimeUnit.SECONDS);
                    failed |= r.getFailedCounter() > before;
                }
                catch (Exception exception) {}
                continue;
            }
            sb.append(String.format("\nReloadStrategy: %s", r.getClass().getName()));
            sb.append(String.format("\n    Reloaded: %s", r.getReloadCounter()));
            sb.append(String.format("\n    Failed: %s", r.getFailedCounter()));
        }
        if (trigger) {
            if (wait) {
                if (failed) {
                    sb.append("Status: Reload failed");
                } else {
                    sb.append("Status: Reload success");
                }
            } else {
                sb.append("Status: Reloading in progress");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        boolean trigger = "true".equals(options.getOrDefault(RELOAD, "false"));
        boolean wait = "true".equals(options.getOrDefault(RELOAD_WAIT, "false"));
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        Set<ReloadStrategy> rs = this.getCamelContext().hasServices(ReloadStrategy.class);
        boolean failed = false;
        for (ReloadStrategy r : rs) {
            if (trigger) {
                int before = r.getFailedCounter();
                Future<?> f = this.getOrCreateReloadTask().submit(() -> r.onReload("ReloadDevConsole"));
                if (!wait) continue;
                try {
                    f.get(30L, TimeUnit.SECONDS);
                    failed |= r.getFailedCounter() > before;
                }
                catch (Exception exception) {}
                continue;
            }
            if (root.isEmpty()) {
                root.put("reloadStrategies", arr);
            }
            JsonObject jo = new JsonObject();
            arr.add(jo);
            jo.put("className", r.getClass().getName());
            jo.put("reloaded", r.getReloadCounter());
            jo.put("failed", r.getFailedCounter());
        }
        if (trigger) {
            if (wait) {
                if (failed) {
                    root.put("status", "failed");
                } else {
                    root.put("status", "success");
                }
            } else {
                root.put("status", "reloading");
            }
        }
        return root;
    }

    protected ExecutorService getOrCreateReloadTask() {
        if (this.reloadThread == null) {
            this.reloadThread = this.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor(this, "ReloadOnDemand");
        }
        return this.reloadThread;
    }

    @Override
    protected void doStop() throws Exception {
        if (this.reloadThread != null) {
            this.getCamelContext().getExecutorServiceManager().shutdown(this.reloadThread);
            this.reloadThread = null;
        }
    }
}

