/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.spi.EndpointServiceRegistry;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="service", displayName="Services", description="Services used for network communication with clients")
public class ServiceDevConsole
extends AbstractDevConsole {
    public ServiceDevConsole() {
        super("camel", "service", "Services", "Services used for network communication with clients");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        EndpointServiceRegistry esr = this.getCamelContext().getCamelContextExtension().getEndpointServiceRegistry();
        for (EndpointServiceRegistry.EndpointService es : esr.listAllEndpointServices()) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            sb.append(String.format("\n    Component: %s", es.getComponent()));
            sb.append(String.format("\n    Direction: %s", es.getDirection()));
            sb.append(String.format("\n    Hosted: %b", es.isHostedService()));
            sb.append(String.format("\n    Protocol: %s", es.getServiceProtocol()));
            sb.append(String.format("\n    Service: %s", es.getServiceUrl()));
            sb.append(String.format("\n    Endpoint: %s", URISupport.sanitizeUri(es.getServiceUrl())));
            if (es.getRouteId() != null) {
                sb.append(String.format("\n    Route Id: %s", es.getRouteId()));
            }
            sb.append(String.format("\n    Total Messages: %d", es.getHits()));
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        root.put("services", list);
        EndpointServiceRegistry esr = this.getCamelContext().getCamelContextExtension().getEndpointServiceRegistry();
        for (EndpointServiceRegistry.EndpointService es : esr.listAllEndpointServices()) {
            JsonObject jo = new JsonObject();
            jo.put("component", es.getComponent());
            jo.put("direction", es.getDirection());
            jo.put("hosted", es.isHostedService());
            jo.put("protocol", es.getServiceProtocol());
            jo.put("serviceUrl", es.getServiceUrl());
            jo.put("endpointUri", es.getEndpointUri());
            if (es.getRouteId() != null) {
                jo.put("routeId", es.getRouteId());
            }
            jo.put("hits", es.getHits());
            Map<String, String> map = es.getServiceMetadata();
            if (map != null) {
                jo.put("metadata", map);
            }
            list.add(jo);
        }
        return root;
    }
}

