/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.StartupStep;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="startup-recorder", description="Starting recording information")
public class StartupRecorderDevConsole
extends AbstractDevConsole {
    public StartupRecorderDevConsole() {
        super("camel", "startup-recorder", "Startup Recorder", "Starting recording information");
    }

    @Override
    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        ExtendedCamelContext ecc = this.getCamelContext().getCamelContextExtension();
        StartupStepRecorder recorder = ecc.getStartupStepRecorder();
        if (recorder != null) {
            recorder.steps().forEach(s -> sb.append(this.logStep((StartupStep)s)).append("\n"));
        }
        return sb.toString();
    }

    @Override
    protected Map<String, Object> doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        ExtendedCamelContext ecc = this.getCamelContext().getCamelContextExtension();
        StartupStepRecorder recorder = ecc.getStartupStepRecorder();
        if (recorder != null) {
            recorder.steps().forEach(s -> {
                JsonObject jo = new JsonObject();
                jo.put("id", s.getId());
                jo.put("parentId", s.getParentId());
                jo.put("level", s.getLevel());
                if (s.getName() != null) {
                    jo.put("name", s.getName());
                }
                jo.put("type", s.getType());
                jo.put("description", s.getDescription());
                jo.put("beginTime", s.getBeginTime());
                jo.put("duration", s.getDuration());
                arr.add(jo);
            });
        }
        if (!arr.isEmpty()) {
            root.put("steps", arr);
        }
        return root;
    }

    protected String logStep(StartupStep step) {
        long delta = step.getDuration();
        String pad = StringHelper.padString(step.getLevel());
        String out = String.format("%s", pad + step.getType());
        String out2 = String.format("%6s ms", delta);
        String out3 = step.getName() != null ? String.format("%s (%s)", step.getDescription(), step.getName()) : String.format("%s", step.getDescription());
        return String.format("%s : %s - %s", out2, out, out3);
    }
}

