/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resume.kafka;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.processor.resume.kafka.KafkaResumeStrategy;
import org.apache.camel.processor.resume.kafka.KafkaResumeStrategyConfiguration;
import org.apache.camel.resume.Cacheable;
import org.apache.camel.resume.Deserializable;
import org.apache.camel.resume.Offset;
import org.apache.camel.resume.OffsetKey;
import org.apache.camel.resume.Resumable;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.resume.ResumeStrategyConfiguration;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="kafka-resume-strategy")
public class SingleNodeKafkaResumeStrategy
implements KafkaResumeStrategy,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(SingleNodeKafkaResumeStrategy.class);
    private Consumer<byte[], byte[]> consumer;
    private Producer<byte[], byte[]> producer;
    private Duration pollDuration = Duration.ofSeconds(1L);
    private boolean subscribed;
    private ResumeAdapter adapter;
    private KafkaResumeStrategyConfiguration resumeStrategyConfiguration;
    private ExecutorService executorService;
    private final ReentrantLock writeLock = new ReentrantLock();
    private CountDownLatch initLatch;
    private CamelContext camelContext;

    public SingleNodeKafkaResumeStrategy() {
    }

    public SingleNodeKafkaResumeStrategy(KafkaResumeStrategyConfiguration resumeStrategyConfiguration) {
        this.resumeStrategyConfiguration = resumeStrategyConfiguration;
    }

    public SingleNodeKafkaResumeStrategy(KafkaResumeStrategyConfiguration resumeStrategyConfiguration, ExecutorService executorService) {
        this.resumeStrategyConfiguration = resumeStrategyConfiguration;
        this.executorService = executorService;
    }

    protected void produce(byte[] key, byte[] message, ResumeStrategy.UpdateCallBack updateCallBack) {
        ProducerRecord<byte[], byte[]> producerRecord = new ProducerRecord<byte[], byte[]>(this.resumeStrategyConfiguration.getTopic(), key, message);
        this.producer.send(producerRecord, (recordMetadata, e) -> {
            if (e != null) {
                LOG.error("Failed to send message {}", (Object)e.getMessage(), (Object)e);
            }
            if (updateCallBack != null) {
                updateCallBack.onUpdate(e);
            }
        });
    }

    protected void doAdd(OffsetKey<?> key, Offset<?> offsetValue) {
        ResumeAdapter resumeAdapter = this.adapter;
        if (resumeAdapter instanceof Cacheable) {
            Cacheable cacheable = (Cacheable)((Object)resumeAdapter);
            cacheable.add(key, offsetValue);
        }
    }

    @Override
    public <T extends Resumable> void updateLastOffset(T offset) throws Exception {
        this.updateLastOffset(offset, null);
    }

    @Override
    public <T extends Resumable> void updateLastOffset(T offset, ResumeStrategy.UpdateCallBack updateCallBack) throws Exception {
        OffsetKey<?> key = offset.getOffsetKey();
        Offset<?> offsetValue = offset.getLastOffset();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating offset on Kafka with key {} to {}", key.getValue(), offsetValue.getValue());
        }
        this.updateLastOffset(key, offsetValue);
    }

    @Override
    public void updateLastOffset(OffsetKey<?> offsetKey, Offset<?> offset) throws Exception {
        this.updateLastOffset(offsetKey, offset, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastOffset(OffsetKey<?> offsetKey, Offset<?> offset, ResumeStrategy.UpdateCallBack updateCallBack) throws Exception {
        ByteBuffer keyBuffer = offsetKey.serialize();
        ByteBuffer valueBuffer = offset.serialize();
        try {
            this.writeLock.lock();
            this.produce(keyBuffer.array(), valueBuffer.array(), updateCallBack);
        }
        finally {
            this.writeLock.unlock();
        }
        this.doAdd(offsetKey, offset);
    }

    @Override
    public void loadCache() {
        if (!(this.adapter instanceof Deserializable)) {
            throw new RuntimeCamelException("Cannot load data for an adapter that is not deserializable");
        }
        this.initLatch = new CountDownLatch(this.resumeStrategyConfiguration.getMaxInitializationRetries());
        if (this.executorService == null) {
            this.executorService = this.camelContext.getExecutorServiceManager().newSingleThreadExecutor(this, "SingleNodeKafkaResumeStrategy");
        }
        this.executorService.submit(() -> this.refresh(this.initLatch));
    }

    private void waitForInitialization() {
        try {
            LOG.trace("Waiting for kafka resume strategy async initialization");
            if (!this.initLatch.await(this.resumeStrategyConfiguration.getMaxInitializationDuration().toMillis(), TimeUnit.MILLISECONDS)) {
                LOG.debug("The initialization timed out");
            }
            LOG.trace("Kafka resume strategy initialization complete");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void refresh(CountDownLatch latch) {
        LOG.trace("Creating a offset cache refresher");
        try {
            this.consumer = this.createConsumer();
            this.subscribe(this.consumer);
            LOG.debug("Loading records from topic {}", (Object)this.resumeStrategyConfiguration.getTopic());
            this.consumer.subscribe(Collections.singletonList(this.resumeStrategyConfiguration.getTopic()));
            this.poll(this.consumer, latch);
        }
        catch (WakeupException e) {
            LOG.info("Kafka consumer was interrupted during a blocking call");
        }
        catch (Exception e) {
            LOG.error("Error while refreshing the local cache: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (this.consumer != null) {
                this.consumer.unsubscribe();
                try {
                    this.consumer.close(Duration.ofSeconds(5L));
                }
                catch (Exception e) {
                    LOG.warn("Error closing the consumer: {} (this error will be ignored)", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    protected void poll(Consumer<byte[], byte[]> consumer, CountDownLatch latch) {
        Deserializable deserializable = (Deserializable)((Object)this.adapter);
        boolean initialized = false;
        while (true) {
            ConsumerRecords<byte[], byte[]> records = this.consume(consumer);
            for (ConsumerRecord<byte[], byte[]> consumerRecord : records) {
                byte[] value = consumerRecord.value();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Read from Kafka at {} ({}): {}", new Object[]{Instant.ofEpochMilli(consumerRecord.timestamp()), consumerRecord.timestampType(), value});
                }
                if (deserializable.deserialize(ByteBuffer.wrap(consumerRecord.key()), ByteBuffer.wrap(consumerRecord.value()))) continue;
                LOG.warn("Deserializer indicates that this is the last record to deserialize");
            }
            if (initialized) continue;
            if (latch.getCount() == 1L) {
                initialized = true;
            }
            latch.countDown();
        }
    }

    protected void checkAndSubscribe(Consumer<byte[], byte[]> consumer, String topic) {
        if (!this.subscribed) {
            consumer.subscribe(Collections.singletonList(topic));
            this.subscribed = true;
        }
    }

    public void checkAndSubscribe(Consumer<byte[], byte[]> consumer, String topic, long remaining) {
        if (!this.subscribed) {
            consumer.subscribe(Collections.singletonList(topic), this.getConsumerRebalanceListener(consumer, remaining));
            this.subscribed = true;
        }
    }

    private ConsumerRebalanceListener getConsumerRebalanceListener(final Consumer<byte[], byte[]> consumer, final long remaining) {
        return new ConsumerRebalanceListener(){

            @Override
            public void onPartitionsRevoked(Collection<TopicPartition> collection) {
            }

            @Override
            public void onPartitionsAssigned(Collection<TopicPartition> assignments) {
                for (TopicPartition assignment : assignments) {
                    long endPosition = consumer.position(assignment);
                    long startPosition = endPosition - remaining;
                    if (startPosition >= 0L) {
                        consumer.seek(assignment, startPosition);
                        continue;
                    }
                    LOG.info("Ignoring the seek command because the initial offset is negative (the topic is likely empty)");
                }
            }
        };
    }

    protected ConsumerRecords<byte[], byte[]> consume(Consumer<byte[], byte[]> consumer) {
        ConsumerRecords<byte[], byte[]> records = consumer.poll(this.pollDuration);
        if (!records.isEmpty()) {
            return records;
        }
        return ConsumerRecords.empty();
    }

    protected ConsumerRecords<byte[], byte[]> consume(int retries, Consumer<byte[], byte[]> consumer) {
        while (retries > 0) {
            ConsumerRecords<byte[], byte[]> records = consumer.poll(this.pollDuration);
            if (!records.isEmpty()) {
                return records;
            }
            --retries;
        }
        return ConsumerRecords.empty();
    }

    private void subscribe(Consumer<byte[], byte[]> consumer) {
        ResumeAdapter resumeAdapter = this.adapter;
        if (resumeAdapter instanceof Cacheable) {
            Cacheable cacheable = (Cacheable)((Object)resumeAdapter);
            ResumeCache<?> cache = cacheable.getCache();
            if (cache.capacity() >= 1L) {
                this.checkAndSubscribe(consumer, this.resumeStrategyConfiguration.getTopic(), cache.capacity());
            } else {
                this.checkAndSubscribe(consumer, this.resumeStrategyConfiguration.getTopic());
            }
        } else {
            this.checkAndSubscribe(consumer, this.resumeStrategyConfiguration.getTopic());
        }
    }

    @Override
    public ResumeAdapter getAdapter() {
        if (this.adapter == null) {
            this.waitForInitialization();
        }
        return this.adapter;
    }

    @Override
    public void setAdapter(ResumeAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public void build() {
    }

    @Override
    public void init() {
        LOG.debug("Initializing the Kafka resume strategy");
    }

    private void createProducer() {
        if (this.producer == null) {
            this.producer = new KafkaProducer<byte[], byte[]>(this.resumeStrategyConfiguration.getProducerProperties());
        }
    }

    private Consumer<byte[], byte[]> createConsumer() {
        return new KafkaConsumer<byte[], byte[]>(this.resumeStrategyConfiguration.getConsumerProperties());
    }

    @Override
    public void stop() {
        try {
            LOG.trace("Trying to obtain a lock for closing the producer");
            if (!this.writeLock.tryLock(1L, TimeUnit.SECONDS)) {
                LOG.warn("Failed to obtain a lock for closing the producer. Force closing the producer ...");
            }
            LOG.info("Closing the Kafka producer");
            IOHelper.close(this.producer, "Kafka producer", LOG);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOG.warn("Error closing the Kafka producer: {} (this error will be ignored)", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            LOG.info("Closing the Kafka consumer");
            this.consumer.wakeup();
            if (this.executorService != null) {
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                    LOG.warn("Kafka consumer did not shutdown within 2 seconds");
                    this.executorService.shutdownNow();
                }
            } else {
                LOG.trace("There's no executor service to shutdown");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    @Override
    public void start() {
        LOG.info("Starting the kafka resume strategy");
        this.createProducer();
    }

    public Duration getPollDuration() {
        return this.pollDuration;
    }

    public void setPollDuration(Duration pollDuration) {
        this.pollDuration = Objects.requireNonNull(pollDuration, "The poll duration cannot be null");
    }

    protected Producer<byte[], byte[]> getProducer() {
        return this.producer;
    }

    @Override
    public void setResumeStrategyConfiguration(ResumeStrategyConfiguration resumeStrategyConfiguration) {
        KafkaResumeStrategyConfiguration kafkaResumeStrategyConfiguration;
        if (!(resumeStrategyConfiguration instanceof KafkaResumeStrategyConfiguration)) {
            throw new RuntimeCamelException("Invalid resume strategy configuration of type " + ObjectHelper.className(resumeStrategyConfiguration));
        }
        this.resumeStrategyConfiguration = kafkaResumeStrategyConfiguration = (KafkaResumeStrategyConfiguration)resumeStrategyConfiguration;
    }

    @Override
    public ResumeStrategyConfiguration getResumeStrategyConfiguration() {
        return this.resumeStrategyConfiguration;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

