/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.URISupport;

public class FailedToCreateRouteException
extends RuntimeCamelException {
    private final String routeId;

    public FailedToCreateRouteException(String routeId, String route, Throwable cause) {
        super("Failed to create route " + routeId + ": " + FailedToCreateRouteException.getRouteMessage(route) + " because of " + FailedToCreateRouteException.getExceptionMessage(cause), cause);
        this.routeId = routeId;
    }

    public FailedToCreateRouteException(String routeId, String route, String at, Throwable cause) {
        super("Failed to create route " + routeId + " at: >>> " + at + " <<< in route: " + FailedToCreateRouteException.getRouteMessage(route) + " because of " + FailedToCreateRouteException.getExceptionMessage(cause), cause);
        this.routeId = routeId;
    }

    public String getRouteId() {
        return this.routeId;
    }

    protected static String getExceptionMessage(Throwable cause) {
        return cause.getMessage() != null ? cause.getMessage() : cause.getClass().getSimpleName();
    }

    protected static String getRouteMessage(String route) {
        if (((String)route).length() > 60) {
            route = ((String)route).substring(0, 60) + "...";
        }
        route = URISupport.sanitizeUri((String)route);
        return route;
    }
}

