/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.component.knative.spi.Knative;
import org.apache.camel.component.knative.spi.KnativeResource;
import org.apache.camel.component.knative.spi.KnativeSinkBinding;
import org.apache.camel.util.ObjectHelper;

public class KnativeSupport {
    private KnativeSupport() {
    }

    public static KnativeResource asResource(CamelContext camelContext, KnativeSinkBinding binding) {
        String kSinkUrl = camelContext.resolvePropertyPlaceholders("{{k.sink:}}");
        String kCeOverride = camelContext.resolvePropertyPlaceholders("{{k.ce.overrides:}}");
        KnativeResource resource = new KnativeResource();
        resource.setEndpointKind(Knative.EndpointKind.sink);
        resource.setType(binding.getType());
        resource.setName(binding.getName());
        resource.setObjectApiVersion(binding.getObjectApiVersion());
        resource.setObjectKind(binding.getObjectKind());
        if (ObjectHelper.isNotEmpty(kSinkUrl)) {
            resource.setUrl(kSinkUrl);
        }
        if (binding.getType() == Knative.Type.event) {
            resource.setObjectName(binding.getName());
        }
        if (ObjectHelper.isNotEmpty(kCeOverride)) {
            try (StringReader reader = new StringReader(kCeOverride);){
                Knative.MAPPER.readValue((Reader)reader, new TypeReference<HashMap<String, String>>(){}).forEach(resource::addCeOverride);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return resource;
    }
}

