/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.knative.KnativeEndpoint;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class KnativeProducer
extends DefaultAsyncProducer {
    final AsyncProcessor processor;
    private WritableHealthCheckRepository healthCheckRepository;
    private HealthCheck producerHealthCheck;

    public KnativeProducer(Endpoint endpoint, Processor processor, Processor ... processors) throws Exception {
        super(endpoint);
        ArrayList<Processor> elements = new ArrayList<Processor>(1 + processors.length);
        elements.add(processor);
        Collections.addAll(elements, processors);
        CamelContext camelContext = this.getEndpoint().getCamelContext();
        Processor pipeline = PluginHelper.getProcessorFactory(camelContext).createProcessor(camelContext, "Pipeline", new Object[]{elements});
        this.processor = AsyncProcessorConverterHelper.convert(pipeline);
    }

    @Override
    public KnativeEndpoint getEndpoint() {
        return (KnativeEndpoint)super.getEndpoint();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.processor.process(exchange, callback);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.getEndpoint().getConfiguration().getSinkBinding() != null) {
            this.healthCheckRepository = HealthCheckHelper.getHealthCheckRepository(this.getEndpoint().getCamelContext(), "producers", WritableHealthCheckRepository.class);
            if (this.healthCheckRepository != null) {
                this.producerHealthCheck = new SinkBindingHealthCheck(this.getEndpoint());
                this.producerHealthCheck.setEnabled(this.getEndpoint().getComponent().isHealthCheckProducerEnabled());
                this.healthCheckRepository.addHealthCheck(this.producerHealthCheck);
            }
        }
        ServiceHelper.startService((Object)this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.healthCheckRepository != null && this.producerHealthCheck != null) {
            this.healthCheckRepository.removeHealthCheck(this.producerHealthCheck);
            this.producerHealthCheck = null;
        }
        ServiceHelper.stopService((Object)this.processor);
    }

    @Override
    protected void doSuspend() throws Exception {
        ServiceHelper.suspendService(this.processor);
    }

    @Override
    protected void doResume() throws Exception {
        ServiceHelper.resumeService(this.processor);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.processor);
    }

    public static class SinkBindingHealthCheck
    extends AbstractHealthCheck {
        private final KnativeEndpoint endpoint;

        public SinkBindingHealthCheck(KnativeEndpoint endpoint) {
            super(endpoint.getId());
            this.endpoint = endpoint;
        }

        @Override
        protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
            String kSinkUrl = this.endpoint.getCamelContext().resolvePropertyPlaceholders("{{k.sink:}}");
            if (ObjectHelper.isNotEmpty(kSinkUrl)) {
                builder.detail("K_SINK", kSinkUrl);
                builder.up();
            } else {
                builder.message("K_SINK not defined");
                builder.down();
            }
        }
    }
}

