/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.Watch;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KubernetesHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesHelper.class);

    private KubernetesHelper() {
    }

    public static KubernetesClient getKubernetesClient(KubernetesConfiguration configuration) {
        if (configuration.getKubernetesClient() != null) {
            return configuration.getKubernetesClient();
        }
        String master = configuration.getMasterUrl();
        if (master == null || "local".equals(master) || "client".equals(master)) {
            LOG.info("Creating default local Kubernetes client without applying configuration");
            return new KubernetesClientBuilder().build();
        }
        return KubernetesHelper.createKubernetesClient(configuration);
    }

    private static KubernetesClient createKubernetesClient(KubernetesConfiguration configuration) {
        LOG.debug("Create Kubernetes client with the following Configuration: {}", (Object)configuration);
        ConfigBuilder builder = new ConfigBuilder();
        builder.withMasterUrl(configuration.getMasterUrl());
        if (ObjectHelper.isNotEmpty(configuration.getUsername()) && ObjectHelper.isNotEmpty(configuration.getPassword()) && ObjectHelper.isEmpty(configuration.getOauthToken())) {
            builder.withUsername(configuration.getUsername());
            builder.withPassword(configuration.getPassword());
        }
        ObjectHelper.ifNotEmpty(configuration.getOauthToken(), builder::withOauthToken);
        ObjectHelper.ifNotEmpty(configuration.getCaCertData(), builder::withCaCertData);
        ObjectHelper.ifNotEmpty(configuration.getCaCertFile(), builder::withCaCertFile);
        ObjectHelper.ifNotEmpty(configuration.getClientCertData(), builder::withClientCertData);
        ObjectHelper.ifNotEmpty(configuration.getClientCertFile(), builder::withClientCertFile);
        ObjectHelper.ifNotEmpty(configuration.getApiVersion(), builder::withApiVersion);
        ObjectHelper.ifNotEmpty(configuration.getClientKeyAlgo(), builder::withClientKeyAlgo);
        ObjectHelper.ifNotEmpty(configuration.getClientKeyData(), builder::withClientKeyData);
        ObjectHelper.ifNotEmpty(configuration.getClientKeyFile(), builder::withClientKeyFile);
        ObjectHelper.ifNotEmpty(configuration.getClientKeyPassphrase(), builder::withClientKeyPassphrase);
        ObjectHelper.ifNotEmpty(configuration.getTrustCerts(), builder::withTrustCerts);
        ObjectHelper.ifNotEmpty(configuration.getConnectionTimeout(), builder::withConnectionTimeout);
        ObjectHelper.ifNotEmpty(configuration.getNamespace(), builder::withNamespace);
        Config conf = builder.build();
        return new KubernetesClientBuilder().withConfig(conf).build();
    }

    public static void close(Runnable runnable, Supplier<Watch> watchGetter) {
        Watch watch;
        if (runnable != null && (watch = watchGetter.get()) != null) {
            watch.close();
        }
    }

    public static String extractOperation(AbstractKubernetesEndpoint endpoint, Exchange exchange) {
        String operation = ObjectHelper.isEmpty(endpoint.getKubernetesConfiguration().getOperation()) ? exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : endpoint.getKubernetesConfiguration().getOperation();
        if (ObjectHelper.isEmpty(operation)) {
            throw new IllegalArgumentException("The kubernetes producer for this component requires a operation to proceed");
        }
        return operation;
    }

    public static void prepareOutboundMessage(Exchange exchange, Object body) {
        MessageHelper.copyHeaders(exchange.getIn(), exchange.getMessage(), true);
        exchange.getMessage().setBody(body);
    }
}

