/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.config_maps;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesConfigMapsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesConfigMapsProducer.class);

    public KubernetesConfigMapsProducer(AbstractKubernetesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = KubernetesHelper.extractOperation(this.getEndpoint(), exchange)) {
            case "listConfigMaps": {
                this.doList(exchange);
                break;
            }
            case "listConfigMapsByLabels": {
                this.doListConfigMapsByLabels(exchange);
                break;
            }
            case "getConfigMap": {
                this.doGetConfigMap(exchange);
                break;
            }
            case "createConfigMap": {
                this.doCreateConfigMap(exchange);
                break;
            }
            case "updateConfigMap": {
                this.doUpdateConfigMap(exchange);
                break;
            }
            case "deleteConfigMap": {
                this.doDeleteConfigMap(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange) {
        ConfigMapList configMapsList = (ConfigMapList)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inAnyNamespace()).list();
        KubernetesHelper.prepareOutboundMessage(exchange, configMapsList.getItems());
    }

    protected void doListConfigMapsByLabels(Exchange exchange) {
        Map labels = exchange.getIn().getHeader("CamelKubernetesConfigMapsLabels", Map.class);
        ConfigMapList configMapsList = (ConfigMapList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inAnyNamespace()).withLabels(labels)).list();
        KubernetesHelper.prepareOutboundMessage(exchange, configMapsList.getItems());
    }

    protected void doGetConfigMap(Exchange exchange) {
        String cfMapName = exchange.getIn().getHeader("CamelKubernetesConfigMapName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(cfMapName)) {
            LOG.error("Get a specific ConfigMap require specify a ConfigMap name");
            throw new IllegalArgumentException("Get a specific ConfigMap require specify a ConfigMap name");
        }
        ConfigMap configMap = namespaceName != null ? (ConfigMap)((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inNamespace(namespaceName)).withName(cfMapName)).get() : (ConfigMap)((Resource)this.getEndpoint().getKubernetesClient().configMaps().withName(cfMapName)).get();
        KubernetesHelper.prepareOutboundMessage(exchange, configMap);
    }

    protected void doUpdateConfigMap(Exchange exchange) {
        this.doCreateOrUpdateConfigMap(exchange, "Update", Updatable::update);
    }

    protected void doCreateConfigMap(Exchange exchange) {
        this.doCreateOrUpdateConfigMap(exchange, "Create", CreateOrReplaceable::create);
    }

    private void doCreateOrUpdateConfigMap(Exchange exchange, String operationName, Function<Resource<ConfigMap>, ConfigMap> operation) {
        String cfMapName = exchange.getIn().getHeader("CamelKubernetesConfigMapName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        HashMap configMapData = exchange.getIn().getHeader("CamelKubernetesConfigData", HashMap.class);
        HashMap configMapAnnotations = exchange.getIn().getHeader("CamelKubernetesConfigMapsAnnotations", HashMap.class);
        if (ObjectHelper.isEmpty(cfMapName)) {
            LOG.error("{} a specific configMap require specify a configMap name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific configMap require specify a configMap name", operationName));
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("{} a specific configMap require specify a namespace name", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific configMap require specify a namespace name", operationName));
        }
        if (ObjectHelper.isEmpty(configMapData)) {
            LOG.error("{} a specific configMap require specify a data map", (Object)operationName);
            throw new IllegalArgumentException(String.format("%s a specific configMap require specify a data map", operationName));
        }
        Map labels = exchange.getIn().getHeader("CamelKubernetesConfigMapsLabels", Map.class);
        ConfigMapBuilder cfMapCreating = new ConfigMapBuilder();
        if (ObjectHelper.isEmpty(configMapAnnotations)) {
            ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)cfMapCreating.withNewMetadata().withName(cfMapName)).withLabels(labels)).endMetadata()).withData(configMapData);
        } else {
            ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)cfMapCreating.withNewMetadata().withName(cfMapName)).withLabels(labels)).withAnnotations(configMapAnnotations)).endMetadata()).withData(configMapData);
        }
        ConfigMap configMap = operation.apply((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inNamespace(namespaceName)).resource(cfMapCreating.build()));
        KubernetesHelper.prepareOutboundMessage(exchange, configMap);
    }

    protected void doDeleteConfigMap(Exchange exchange) {
        String configMapName = exchange.getIn().getHeader("CamelKubernetesConfigMapName", String.class);
        String namespaceName = exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty(configMapName)) {
            LOG.error("Delete a specific config map require specify a config map name");
            throw new IllegalArgumentException("Delete a specific config map require specify a config map name");
        }
        if (ObjectHelper.isEmpty(namespaceName)) {
            LOG.error("Delete a specific config map require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific config map require specify a namespace name");
        }
        List<StatusDetails> statusDetails = ((Resource)((NonNamespaceOperation)this.getEndpoint().getKubernetesClient().configMaps().inNamespace(namespaceName)).withName(configMapName)).delete();
        boolean cfMapDeleted = ObjectHelper.isNotEmpty(statusDetails);
        KubernetesHelper.prepareOutboundMessage(exchange, cfMapDeleted);
    }
}

