/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.nodes;

import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesNodesConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesNodesConsumer.class);
    private final Processor processor;
    private ExecutorService executor;
    private NodesConsumerTask nodesWatcher;

    public KubernetesNodesConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.processor = processor;
    }

    @Override
    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.nodesWatcher = new NodesConsumerTask();
        this.executor.submit(this.nodesWatcher);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Nodes Consumer");
        if (this.executor != null) {
            KubernetesHelper.close(this.nodesWatcher, this.nodesWatcher::getWatch);
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class NodesConsumerTask
    implements Runnable {
        private Watch watch;

        NodesConsumerTask() {
        }

        @Override
        public void run() {
            NonNamespaceOperation<Node, NodeList, Resource<Node>> w = KubernetesNodesConsumer.this.getEndpoint().getKubernetesClient().nodes();
            if (ObjectHelper.isNotEmpty(KubernetesNodesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey()) && ObjectHelper.isNotEmpty(KubernetesNodesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue())) {
                w.withLabel(KubernetesNodesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelKey(), KubernetesNodesConsumer.this.getEndpoint().getKubernetesConfiguration().getLabelValue());
            }
            ObjectHelper.ifNotEmpty(KubernetesNodesConsumer.this.getEndpoint().getKubernetesConfiguration().getResourceName(), w::withName);
            this.watch = w.watch(new Watcher<Node>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void eventReceived(Watcher.Action action, Node resource) {
                    Exchange exchange = KubernetesNodesConsumer.this.createExchange(false);
                    exchange.getIn().setBody(resource);
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)action);
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", System.currentTimeMillis());
                    try {
                        KubernetesNodesConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesNodesConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, e);
                    }
                    finally {
                        KubernetesNodesConsumer.this.releaseExchange(exchange, false);
                    }
                }

                @Override
                public void onClose(WatcherException cause) {
                    if (cause != null) {
                        LOG.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

