/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.alibabacloud.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.hive.alibabacloud.v1.MachinePool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private String imageID;
    private String instanceType;
    private String systemDiskCategory;
    private Integer systemDiskSize;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withImageID(instance.getImageID());
            this.withInstanceType(instance.getInstanceType());
            this.withSystemDiskCategory(instance.getSystemDiskCategory());
            this.withSystemDiskSize(instance.getSystemDiskSize());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getImageID() {
        return this.imageID;
    }

    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)this;
    }

    public boolean hasImageID() {
        return this.imageID != null;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public A withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return (A)this;
    }

    public boolean hasInstanceType() {
        return this.instanceType != null;
    }

    public String getSystemDiskCategory() {
        return this.systemDiskCategory;
    }

    public A withSystemDiskCategory(String systemDiskCategory) {
        this.systemDiskCategory = systemDiskCategory;
        return (A)this;
    }

    public boolean hasSystemDiskCategory() {
        return this.systemDiskCategory != null;
    }

    public Integer getSystemDiskSize() {
        return this.systemDiskSize;
    }

    public A withSystemDiskSize(Integer systemDiskSize) {
        this.systemDiskSize = systemDiskSize;
        return (A)this;
    }

    public boolean hasSystemDiskSize() {
        return this.systemDiskSize != null;
    }

    public A addToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    public A setToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    public A removeFromZones(String ... items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromZones(Collection<String> items) {
        if (this.zones == null) {
            return (A)this;
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)this;
    }

    public List<String> getZones() {
        return this.zones;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove("zones");
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)o;
        if (!Objects.equals(this.imageID, that.imageID)) {
            return false;
        }
        if (!Objects.equals(this.instanceType, that.instanceType)) {
            return false;
        }
        if (!Objects.equals(this.systemDiskCategory, that.systemDiskCategory)) {
            return false;
        }
        if (!Objects.equals(this.systemDiskSize, that.systemDiskSize)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.imageID, this.instanceType, this.systemDiskCategory, this.systemDiskSize, this.zones, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageID != null) {
            sb.append("imageID:");
            sb.append(this.imageID + ",");
        }
        if (this.instanceType != null) {
            sb.append("instanceType:");
            sb.append(this.instanceType + ",");
        }
        if (this.systemDiskCategory != null) {
            sb.append("systemDiskCategory:");
            sb.append(this.systemDiskCategory + ",");
        }
        if (this.systemDiskSize != null) {
            sb.append("systemDiskSize:");
            sb.append(this.systemDiskSize + ",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(this.zones + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

