/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.cloud;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.cloud.KubernetesServiceDiscovery;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClientServiceDiscovery
extends KubernetesServiceDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesClientServiceDiscovery.class);
    private final String namespace;
    private final String portName;
    private KubernetesClient client;

    public KubernetesClientServiceDiscovery(KubernetesConfiguration configuration) {
        super(configuration);
        this.namespace = configuration.getNamespace() != null ? configuration.getNamespace() : System.getenv("KUBERNETES_NAMESPACE");
        this.portName = configuration.getPortName();
        this.client = null;
    }

    @Override
    public List<ServiceDefinition> getServices(String name) {
        LOG.debug("Discovering endpoints from namespace: {} with name: {}", (Object)this.namespace, (Object)name);
        Endpoints endpoints = (Endpoints)((Resource)((NonNamespaceOperation)this.client.endpoints().inNamespace(this.namespace)).withName(name)).get();
        ArrayList<ServiceDefinition> result = new ArrayList<ServiceDefinition>();
        if (endpoints != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found {} endpoints in namespace: {} for name: {} and portName: {}", new Object[]{endpoints.getSubsets().size(), this.namespace, name, this.portName});
            }
            for (EndpointSubset subset : endpoints.getSubsets()) {
                if (subset.getPorts().size() == 1) {
                    this.addServers(name, result, subset.getPorts().get(0), subset);
                    continue;
                }
                this.addPortSet(name, result, subset);
            }
        }
        return result;
    }

    private void addPortSet(String name, List<ServiceDefinition> result, EndpointSubset subset) {
        List<EndpointPort> ports = subset.getPorts();
        int portSize = ports.size();
        for (int p = 0; p < portSize; ++p) {
            EndpointPort port = ports.get(p);
            if (!ObjectHelper.isEmpty(this.portName) && !this.portName.endsWith(port.getName())) continue;
            this.addServers(name, result, port, subset);
        }
    }

    protected void addServers(String name, List<ServiceDefinition> servers, EndpointPort port, EndpointSubset subset) {
        List<EndpointAddress> addresses = subset.getAddresses();
        int size = addresses.size();
        for (int i = 0; i < size; ++i) {
            servers.add(new DefaultServiceDefinition(name, addresses.get(i).getIp(), port.getPort()));
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.client != null) {
            return;
        }
        KubernetesConfiguration configuration = this.getConfiguration();
        ConfigBuilder builder = new ConfigBuilder();
        builder.withMasterUrl(configuration.getMasterUrl());
        if (this.hasUsernameAndPassword(configuration) && ObjectHelper.isEmpty(configuration.getOauthToken())) {
            builder.withUsername(configuration.getUsername());
            builder.withPassword(configuration.getPassword());
        } else {
            builder.withOauthToken(configuration.getOauthToken());
        }
        ObjectHelper.ifNotEmpty(configuration.getCaCertData(), builder::withCaCertData);
        ObjectHelper.ifNotEmpty(configuration.getCaCertFile(), builder::withCaCertFile);
        ObjectHelper.ifNotEmpty(configuration.getClientCertData(), builder::withClientCertData);
        ObjectHelper.ifNotEmpty(configuration.getClientCertFile(), builder::withClientCertFile);
        ObjectHelper.ifNotEmpty(configuration.getApiVersion(), builder::withApiVersion);
        ObjectHelper.ifNotEmpty(configuration.getClientKeyAlgo(), builder::withClientKeyAlgo);
        ObjectHelper.ifNotEmpty(configuration.getClientKeyData(), builder::withClientKeyData);
        ObjectHelper.ifNotEmpty(configuration.getClientKeyFile(), builder::withClientKeyFile);
        ObjectHelper.ifNotEmpty(configuration.getClientKeyPassphrase(), builder::withClientKeyPassphrase);
        ObjectHelper.ifNotEmpty(configuration.getTrustCerts(), builder::withTrustCerts);
        this.client = new KubernetesClientBuilder().withConfig(builder.build()).build();
    }

    private boolean hasUsernameAndPassword(KubernetesConfiguration configuration) {
        return ObjectHelper.isNotEmpty(configuration.getUsername()) && ObjectHelper.isNotEmpty(configuration.getPassword());
    }

    @Override
    protected void doStop() throws Exception {
        if (this.client != null) {
            IOHelper.close((Closeable)this.client);
            this.client = null;
        }
    }

    public String toString() {
        return "KubernetesClientServiceDiscovery{namespace='" + this.namespace + "', portName='" + this.portName + "'}";
    }
}

