/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Traceable;
import org.apache.camel.processor.loadbalancer.ExceptionFailureStatistics;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailOverLoadBalancer
extends LoadBalancerSupport
implements Traceable,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(FailOverLoadBalancer.class);
    private final List<Class<?>> exceptions;
    private CamelContext camelContext;
    private boolean roundRobin;
    private boolean sticky;
    private int maximumFailoverAttempts = -1;
    private final AtomicInteger counter = new AtomicInteger(-1);
    private final AtomicInteger lastGoodIndex = new AtomicInteger(-1);
    private final ExceptionFailureStatistics statistics = new ExceptionFailureStatistics();

    public FailOverLoadBalancer() {
        this.exceptions = null;
    }

    public FailOverLoadBalancer(List<Class<?>> exceptions) {
        this.exceptions = exceptions;
        for (Class<?> type : exceptions) {
            if (ObjectHelper.isAssignableFrom(Throwable.class, type)) continue;
            throw new IllegalArgumentException("Class is not an instance of Throwable: " + type);
        }
        this.statistics.init(exceptions);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public int getLastGoodIndex() {
        return this.lastGoodIndex.get();
    }

    public List<Class<?>> getExceptions() {
        return this.exceptions;
    }

    public boolean isRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public int getMaximumFailoverAttempts() {
        return this.maximumFailoverAttempts;
    }

    public void setMaximumFailoverAttempts(int maximumFailoverAttempts) {
        this.maximumFailoverAttempts = maximumFailoverAttempts;
    }

    protected boolean shouldFailOver(Exchange exchange) {
        if (exchange == null) {
            return false;
        }
        boolean answer = false;
        if (exchange.getException() != null) {
            if (this.exceptions == null || this.exceptions.isEmpty()) {
                answer = true;
            } else {
                for (Class<?> exception : this.exceptions) {
                    if (exchange.getException(exception) == null) continue;
                    answer = true;
                    break;
                }
            }
            if (answer) {
                this.statistics.onHandledFailure(exchange.getException());
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Should failover: {} for exchangeId: {}", (Object)answer, (Object)exchange.getExchangeId());
        }
        return answer;
    }

    @Override
    public boolean isRunAllowed() {
        boolean forceShutdown = this.camelContext.getShutdownStrategy().isForceShutdown();
        if (forceShutdown) {
            LOG.trace("Run not allowed as ShutdownStrategy is forcing shutting down");
        }
        return !forceShutdown && super.isRunAllowed();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        AsyncProcessor[] processors = this.doGetProcessors();
        exchange.getContext().getCamelContextExtension().getReactiveExecutor().schedule(new State(exchange, callback, processors)::run);
        return false;
    }

    protected Exchange prepareExchangeForFailover(Exchange exchange) {
        return ExchangeHelper.createCopy(exchange, true);
    }

    @Override
    public String getTraceLabel() {
        return "failover";
    }

    public ExceptionFailureStatistics getExceptionFailureStatistics() {
        return this.statistics;
    }

    public void reset() {
        this.lastGoodIndex.set(-1);
        this.counter.set(-1);
        this.statistics.reset();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.reset();
    }

    protected class State {
        final Exchange exchange;
        final AsyncCallback callback;
        final AsyncProcessor[] processors;
        int index;
        int attempts;
        Exchange copy;

        public State(Exchange exchange, AsyncCallback callback, AsyncProcessor[] processors) {
            this.exchange = exchange;
            this.callback = callback;
            this.processors = processors;
            if (FailOverLoadBalancer.this.isSticky()) {
                int idx = FailOverLoadBalancer.this.lastGoodIndex.get();
                this.index = Math.max(idx, 0);
            } else if (FailOverLoadBalancer.this.isRoundRobin()) {
                this.index = FailOverLoadBalancer.this.counter.updateAndGet(x -> ++x < processors.length ? x : 0);
            }
            LOG.trace("Failover starting with endpoint index {}", (Object)this.index);
        }

        public void run() {
            if (this.copy != null && !FailOverLoadBalancer.this.shouldFailOver(this.copy)) {
                FailOverLoadBalancer.this.lastGoodIndex.set(this.index);
                ExchangeHelper.copyResults(this.exchange, this.copy);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failover complete for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                }
                this.callback.done(false);
                return;
            }
            if (!FailOverLoadBalancer.this.isRunAllowed()) {
                LOG.trace("Run not allowed, will reject executing exchange: {}", (Object)this.exchange);
                if (this.exchange.getException() == null) {
                    this.exchange.setException(new RejectedExecutionException());
                }
                this.callback.done(false);
                return;
            }
            if (this.copy != null) {
                ++this.attempts;
                if (FailOverLoadBalancer.this.maximumFailoverAttempts > -1 && this.attempts > FailOverLoadBalancer.this.maximumFailoverAttempts) {
                    LOG.debug("Breaking out of failover after {} failover attempts", (Object)this.attempts);
                    ExchangeHelper.copyResults(this.exchange, this.copy);
                    this.callback.done(false);
                    return;
                }
                ++this.index;
                FailOverLoadBalancer.this.counter.incrementAndGet();
            }
            if (this.index >= this.processors.length) {
                if (FailOverLoadBalancer.this.isRoundRobin()) {
                    LOG.trace("Failover is round robin enabled and therefore starting from the first endpoint");
                    this.index = 0;
                    FailOverLoadBalancer.this.counter.set(0);
                } else {
                    LOG.trace("Breaking out of failover as we reached the end of endpoints to use for failover");
                    ExchangeHelper.copyResults(this.exchange, this.copy);
                    this.callback.done(false);
                    return;
                }
            }
            this.copy = FailOverLoadBalancer.this.prepareExchangeForFailover(this.exchange);
            AsyncProcessor processor = this.processors[this.index];
            LOG.debug("Processing failover at attempt {} for {}", (Object)this.attempts, (Object)this.copy);
            processor.process(this.copy, doneSync -> this.exchange.getContext().getCamelContextExtension().getReactiveExecutor().schedule(this::run));
        }
    }
}

