/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.model.Scope;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.ShortNames;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=JsonDeserializer.None.class)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class CustomResource<S, T>
implements HasMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(CustomResource.class);
    private ObjectMeta metadata = new ObjectMeta();
    @JsonProperty(value="spec")
    protected S spec;
    @JsonProperty(value="status")
    protected T status;
    private final String singular;
    private final String crdName;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private final String kind;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private final String apiVersion;
    private final String scope;
    private final String plural;
    private final boolean served;
    private final boolean storage;
    private final boolean deprecated;
    private final String deprecationWarning;

    public CustomResource() {
        String version = HasMetadata.super.getApiVersion();
        Class<?> clazz = this.getClass();
        if (Utils.isNullOrEmpty(version)) {
            throw new IllegalArgumentException(clazz.getName() + " CustomResource must provide an API version using @" + Group.class.getName() + " and @" + Version.class.getName() + " annotations");
        }
        this.apiVersion = version;
        this.kind = HasMetadata.super.getKind();
        this.scope = this instanceof Namespaced ? Scope.NAMESPACED.value() : Scope.CLUSTER.value();
        this.singular = HasMetadata.super.getSingular();
        this.plural = HasMetadata.super.getPlural();
        this.crdName = CustomResource.getCRDName(clazz);
        this.served = CustomResource.getServed(clazz);
        this.storage = CustomResource.getStorage(clazz);
        this.deprecated = CustomResource.getDeprecated(clazz);
        this.deprecationWarning = CustomResource.getDeprecationWarning(clazz);
        this.spec = this.initSpec();
        this.status = this.initStatus();
    }

    public static boolean getServed(Class<?> clazz) {
        Version annotation = clazz.getAnnotation(Version.class);
        return annotation == null || annotation.served();
    }

    public static boolean getStorage(Class<?> clazz) {
        Version annotation = clazz.getAnnotation(Version.class);
        return annotation == null || annotation.storage();
    }

    public static boolean getDeprecated(Class<?> clazz) {
        Version annotation = clazz.getAnnotation(Version.class);
        return annotation == null || annotation.deprecated();
    }

    public static String getDeprecationWarning(Class<?> clazz) {
        Version annotation = clazz.getAnnotation(Version.class);
        return annotation != null && Utils.isNotNullOrEmpty(annotation.deprecationWarning()) ? annotation.deprecationWarning() : null;
    }

    protected S initSpec() {
        return null;
    }

    protected T initStatus() {
        return null;
    }

    public String toString() {
        return "CustomResource{kind='" + this.getKind() + '\'' + ", apiVersion='" + this.getApiVersion() + '\'' + ", metadata=" + this.metadata + ", spec=" + this.spec + ", status=" + this.status + ", deprecated=" + this.deprecated + ", deprecationWarning=" + this.deprecationWarning + '}';
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public void setApiVersion(String version) {
        LOG.debug("Calling CustomResource#setApiVersion doesn't do anything because the API version is computed and shouldn't be changed");
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        LOG.debug("Calling CustomResource#setKind doesn't do anything because the Kind is computed and shouldn't be changed");
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @Deprecated
    public static String getPlural(Class<?> clazz) {
        return HasMetadata.getPlural(clazz);
    }

    @Override
    @JsonIgnore
    public String getPlural() {
        return this.plural;
    }

    @Deprecated
    public static String getSingular(Class<?> clazz) {
        return HasMetadata.getSingular(clazz);
    }

    @Override
    @JsonIgnore
    public String getSingular() {
        return this.singular;
    }

    public static String getCRDName(Class<?> clazz) {
        return HasMetadata.getFullResourceName(clazz);
    }

    @JsonIgnore
    public String getCRDName() {
        return this.crdName;
    }

    public static String[] getShortNames(Class<?> clazz) {
        return Optional.ofNullable(clazz.getAnnotation(ShortNames.class)).map(ShortNames::value).orElse(new String[0]);
    }

    @JsonIgnore
    public String getScope() {
        return this.scope;
    }

    @JsonIgnore
    public String getGroup() {
        return HasMetadata.getGroup(this.getClass());
    }

    @JsonIgnore
    public String getVersion() {
        return HasMetadata.getVersion(this.getClass());
    }

    @JsonIgnore
    public boolean isServed() {
        return this.served;
    }

    @JsonIgnore
    public boolean isStorage() {
        return this.storage;
    }

    @JsonIgnore
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @JsonIgnore
    public String getDeprecationWarning() {
        return this.deprecationWarning;
    }

    public S getSpec() {
        return this.spec;
    }

    public void setSpec(S spec) {
        this.spec = spec;
    }

    public T getStatus() {
        return this.status;
    }

    public void setStatus(T status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomResource)) {
            return false;
        }
        CustomResource that = (CustomResource)o;
        if (this.served != that.served) {
            return false;
        }
        if (this.storage != that.storage) {
            return false;
        }
        if (this.deprecated != that.deprecated) {
            return false;
        }
        if (!Objects.equals(this.deprecationWarning, that.deprecationWarning)) {
            return false;
        }
        if (!this.metadata.equals(that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        if (!this.singular.equals(that.singular)) {
            return false;
        }
        if (!this.crdName.equals(that.crdName)) {
            return false;
        }
        if (!this.kind.equals(that.kind)) {
            return false;
        }
        if (!this.apiVersion.equals(that.apiVersion)) {
            return false;
        }
        if (!this.scope.equals(that.scope)) {
            return false;
        }
        return this.plural.equals(that.plural);
    }

    public int hashCode() {
        int result = this.metadata.hashCode();
        result = 31 * result + (this.spec != null ? this.spec.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + this.singular.hashCode();
        result = 31 * result + this.crdName.hashCode();
        result = 31 * result + this.kind.hashCode();
        result = 31 * result + this.apiVersion.hashCode();
        result = 31 * result + this.scope.hashCode();
        result = 31 * result + this.plural.hashCode();
        result = 31 * result + (this.served ? 1 : 0);
        result = 31 * result + (this.storage ? 1 : 0);
        result = 31 * result + (this.deprecated ? 1 : 0);
        result = 31 * result + (this.deprecationWarning != null ? this.deprecationWarning.hashCode() : 0);
        return result;
    }
}

