/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpStatusMessage;
import io.fabric8.kubernetes.client.http.SendAsyncUtils;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface HttpResponse<T>
extends HttpHeaders {
    default public boolean isSuccessful() {
        return HttpResponse.isSuccessful(this.code());
    }

    public static boolean isSuccessful(int code) {
        return code >= 200 && code < 300;
    }

    public int code();

    default public String message() {
        return HttpStatusMessage.getMessageForStatus(this.code());
    }

    public T body();

    default public String bodyString() throws IOException {
        T body = this.body();
        SupportedResponses supportedResponse = SupportedResponses.from(body);
        if (supportedResponse == null) {
            return "";
        }
        return supportedResponse.asString(body);
    }

    public HttpRequest request();

    public Optional<HttpResponse<?>> previousResponse();

    public static enum SupportedResponses {
        TEXT(String.class, Object::toString, SendAsyncUtils::string),
        INPUT_STREAM(InputStream.class, body -> IOHelpers.readFully((InputStream)body, StandardCharsets.UTF_8), SendAsyncUtils::inputStream),
        READER(Reader.class, body -> IOHelpers.readFully((Reader)body), SendAsyncUtils::reader),
        BYTE_ARRAY(byte[].class, body -> new String((byte[])body, StandardCharsets.UTF_8), SendAsyncUtils::bytes);

        private final Class<?> type;
        private final ToString toString;
        private final Async<?> async;

        private <T> SupportedResponses(Class<T> type, ToString toString2, Async<T> async) {
            this.type = type;
            this.toString = toString2;
            this.async = async;
        }

        private String asString(Object body) throws IOException {
            return this.toString.toString(body);
        }

        <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpClient client) {
            return this.async.sendAsync(request, client);
        }

        public static SupportedResponses from(Object object) {
            if (object == null) {
                return null;
            }
            return SupportedResponses.from(object.getClass());
        }

        public static SupportedResponses from(Class<?> type) {
            for (SupportedResponses sr : SupportedResponses.values()) {
                if (!sr.type.isAssignableFrom(type)) continue;
                return sr;
            }
            throw new IllegalArgumentException("Unsupported response type: " + type.getName());
        }

        @FunctionalInterface
        static interface Async<T> {
            public CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest var1, HttpClient var2);
        }

        @FunctionalInterface
        static interface ToString {
            public String toString(Object var1) throws IOException;
        }
    }
}

