/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.internal;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPath;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLFromServiceUtil {
    public static final Logger logger = LoggerFactory.getLogger(URLFromServiceUtil.class);
    public static final String DEFAULT_PROTO = "tcp";
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String PORT_SUFFIX = "_SERVICE_PORT";
    private static final String PROTO_SUFFIX = "_TCP_PROTO";

    private URLFromServiceUtil() {
    }

    public static String resolveHostFromEnvVarOrSystemProperty(String serviceName) {
        return URLFromServiceUtil.getEnvVarOrSystemProperty(URLFromServiceUtil.toServiceHostEnvironmentVariable(serviceName), "");
    }

    private static String getEnvVarOrSystemProperty(String envVarName, String defaultValue) {
        String answer = null;
        try {
            answer = System.getenv(envVarName);
        }
        catch (Exception e) {
            logger.warn("Failed to look up environment variable $" + envVarName + ". " + e, (Throwable)e);
        }
        if (answer == null || answer.isEmpty()) {
            answer = System.getProperty(envVarName, defaultValue);
        }
        if (!answer.isEmpty()) {
            return answer;
        }
        return defaultValue;
    }

    public static String resolveProtocolFromEnvVarOrSystemProperty(String serviceName, String servicePort) {
        return URLFromServiceUtil.getEnvVarOrSystemProperty(URLFromServiceUtil.toEnvVariable(serviceName + PORT_SUFFIX + "_" + servicePort + PROTO_SUFFIX), DEFAULT_PROTO);
    }

    public static String resolvePortFromEnvVarOrSystemProperty(String serviceName, String portName) {
        String envVarName = URLFromServiceUtil.toServicePortEnvironmentVariable(serviceName, portName);
        return URLFromServiceUtil.getEnvVarOrSystemProperty(envVarName, "");
    }

    public static String toServicePortEnvironmentVariable(String serviceName, String portName) {
        String name = serviceName + PORT_SUFFIX + (!portName.isEmpty() ? "_" + portName : "");
        return URLFromServiceUtil.toEnvVariable(name);
    }

    private static String toServiceHostEnvironmentVariable(String serviceName) {
        return URLFromServiceUtil.toEnvVariable(serviceName + HOST_SUFFIX);
    }

    public static String toEnvVariable(String serviceName) {
        return serviceName.toUpperCase(Locale.ROOT).replaceAll("-", "_");
    }

    public static String getURLFromExtensionsV1beta1IngressList(List<Ingress> ingressList, String namespace, String serviceName, ServicePort port) {
        for (Ingress item : ingressList) {
            String url;
            String ns = KubernetesResourceUtil.getNamespace(item);
            if (!Objects.equals(ns, namespace) || item.getSpec() == null || (url = URLFromServiceUtil.getURLFromIngressSpec(item.getSpec(), serviceName, port)) == null) continue;
            return url;
        }
        return null;
    }

    public static String getURLFromNetworkingV1IngressList(List<io.fabric8.kubernetes.api.model.networking.v1.Ingress> ingressList, String namespace, String serviceName, ServicePort port) {
        for (io.fabric8.kubernetes.api.model.networking.v1.Ingress item : ingressList) {
            String url;
            String ns = KubernetesResourceUtil.getNamespace(item);
            if (!Objects.equals(ns, namespace) || item.getSpec() == null || (url = URLFromServiceUtil.getURLFromNetworkV1IngressSpec(item.getSpec(), serviceName, port)) == null) continue;
            return url;
        }
        return null;
    }

    public static String getURLFromNetworkV1IngressSpec(io.fabric8.kubernetes.api.model.networking.v1.IngressSpec spec, String serviceName, ServicePort port) {
        List<io.fabric8.kubernetes.api.model.networking.v1.IngressRule> ingressRules = spec.getRules();
        if (ingressRules != null && !ingressRules.isEmpty()) {
            for (io.fabric8.kubernetes.api.model.networking.v1.IngressRule rule : ingressRules) {
                io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressRuleValue http = rule.getHttp();
                if (http == null || http.getPaths() == null) continue;
                return URLFromServiceUtil.getURLFromNetworkV1IngressRules(http.getPaths(), spec, serviceName, port, rule);
            }
        }
        return null;
    }

    public static String getURLFromNetworkV1IngressRules(List<HTTPIngressPath> paths, io.fabric8.kubernetes.api.model.networking.v1.IngressSpec spec, String serviceName, ServicePort port, io.fabric8.kubernetes.api.model.networking.v1.IngressRule rule) {
        for (HTTPIngressPath path : paths) {
            String backendServiceName;
            io.fabric8.kubernetes.api.model.networking.v1.IngressBackend backend = path.getBackend();
            if (backend == null || !serviceName.equals(backendServiceName = backend.getService().getName()) || !URLFromServiceUtil.portsMatch(port, new IntOrString(backend.getService().getPort().getNumber()))) continue;
            return URLFromServiceUtil.getURLFromIngressBackend(spec.getTls() != null && !spec.getTls().isEmpty(), path.getPath(), rule.getHost());
        }
        return null;
    }

    public static String getURLFromIngressSpec(IngressSpec spec, String serviceName, ServicePort port) {
        List<IngressRule> ingressRules = spec.getRules();
        if (ingressRules != null && !ingressRules.isEmpty()) {
            for (IngressRule rule : ingressRules) {
                HTTPIngressRuleValue http = rule.getHttp();
                if (http == null || http.getPaths() == null) continue;
                return URLFromServiceUtil.getURLFromIngressRules(http.getPaths(), spec, serviceName, port, rule);
            }
        }
        return null;
    }

    public static String getURLFromIngressRules(List<io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath> paths, IngressSpec spec, String serviceName, ServicePort port, IngressRule rule) {
        for (io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath path : paths) {
            String backendServiceName;
            IngressBackend backend = path.getBackend();
            if (backend == null || !serviceName.equals(backendServiceName = backend.getServiceName()) || !URLFromServiceUtil.portsMatch(port, backend.getServicePort())) continue;
            return URLFromServiceUtil.getURLFromIngressBackend(spec.getTls() != null && !spec.getTls().isEmpty(), path.getPath(), rule.getHost());
        }
        return null;
    }

    private static String getURLFromIngressBackend(boolean tlsProvided, String pathPostFix, String host) {
        if (tlsProvided) {
            return URLFromServiceUtil.getURLFromTLSHost(host, pathPostFix);
        }
        if (host != null && !host.isEmpty()) {
            pathPostFix = URLFromServiceUtil.fixPathPostFixIfEmpty(pathPostFix);
            return "http://" + URLUtils.pathJoin(host, pathPostFix);
        }
        return null;
    }

    public static String getURLFromTLSHost(String host, String pathPostFix) {
        if (!host.isEmpty()) {
            pathPostFix = URLFromServiceUtil.fixPathPostFixIfEmpty(pathPostFix);
            return "https://" + URLUtils.pathJoin(host, pathPostFix);
        }
        return null;
    }

    private static String fixPathPostFixIfEmpty(String pathPostFix) {
        return pathPostFix.isEmpty() ? "/" : pathPostFix;
    }

    private static boolean portsMatch(ServicePort servicePort, IntOrString intOrString) {
        if (intOrString != null) {
            Integer port = servicePort.getPort();
            Integer intVal = intOrString.getIntVal();
            String strVal = intOrString.getStrVal();
            if (intVal != null) {
                if (port != null) {
                    return port.intValue() == intVal.intValue();
                }
            } else if (strVal != null) {
                return strVal.equals(servicePort.getName());
            }
        }
        return false;
    }

    public static ServicePort getServicePortByName(Service service, String portName) {
        if (portName.isEmpty()) {
            return service.getSpec().getPorts().iterator().next();
        }
        for (ServicePort servicePort : service.getSpec().getPorts()) {
            if (!Objects.equals(servicePort.getName(), portName)) continue;
            return servicePort;
        }
        return null;
    }
}

