/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.logging;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

public final class LoggingEventListener
extends EventListener {
    private final HttpLoggingInterceptor.Logger logger;
    private long startNs;

    private LoggingEventListener(HttpLoggingInterceptor.Logger logger) {
        this.logger = logger;
    }

    @Override
    public void callStart(Call call) {
        this.startNs = System.nanoTime();
        this.logWithTime("callStart: " + call.request());
    }

    @Override
    public void dnsStart(Call call, String domainName) {
        this.logWithTime("dnsStart: " + domainName);
    }

    @Override
    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        this.logWithTime("dnsEnd: " + inetAddressList);
    }

    @Override
    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        this.logWithTime("connectStart: " + inetSocketAddress + " " + proxy);
    }

    @Override
    public void secureConnectStart(Call call) {
        this.logWithTime("secureConnectStart");
    }

    @Override
    public void secureConnectEnd(Call call, @Nullable Handshake handshake2) {
        this.logWithTime("secureConnectEnd");
    }

    @Override
    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol) {
        this.logWithTime("connectEnd: " + (Object)((Object)protocol));
    }

    @Override
    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol, IOException ioe) {
        this.logWithTime("connectFailed: " + (Object)((Object)protocol) + " " + ioe);
    }

    @Override
    public void connectionAcquired(Call call, Connection connection) {
        this.logWithTime("connectionAcquired: " + connection);
    }

    @Override
    public void connectionReleased(Call call, Connection connection) {
        this.logWithTime("connectionReleased");
    }

    @Override
    public void requestHeadersStart(Call call) {
        this.logWithTime("requestHeadersStart");
    }

    @Override
    public void requestHeadersEnd(Call call, Request request) {
        this.logWithTime("requestHeadersEnd");
    }

    @Override
    public void requestBodyStart(Call call) {
        this.logWithTime("requestBodyStart");
    }

    @Override
    public void requestBodyEnd(Call call, long byteCount) {
        this.logWithTime("requestBodyEnd: byteCount=" + byteCount);
    }

    @Override
    public void responseHeadersStart(Call call) {
        this.logWithTime("responseHeadersStart");
    }

    @Override
    public void responseHeadersEnd(Call call, Response response) {
        this.logWithTime("responseHeadersEnd: " + response);
    }

    @Override
    public void responseBodyStart(Call call) {
        this.logWithTime("responseBodyStart");
    }

    @Override
    public void responseBodyEnd(Call call, long byteCount) {
        this.logWithTime("responseBodyEnd: byteCount=" + byteCount);
    }

    @Override
    public void callEnd(Call call) {
        this.logWithTime("callEnd");
    }

    @Override
    public void callFailed(Call call, IOException ioe) {
        this.logWithTime("callFailed: " + ioe);
    }

    private void logWithTime(String message) {
        long timeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startNs);
        this.logger.log("[" + timeMs + " ms] " + message);
    }

    public static class Factory
    implements EventListener.Factory {
        private final HttpLoggingInterceptor.Logger logger;

        public Factory() {
            this(HttpLoggingInterceptor.Logger.DEFAULT);
        }

        public Factory(HttpLoggingInterceptor.Logger logger) {
            this.logger = logger;
        }

        @Override
        public EventListener create(Call call) {
            return new LoggingEventListener(this.logger);
        }
    }
}

